/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Union;

public class CompositeAlignmentHelper {
    private static int getCompositeAlignmentMultiple(DataOrganization dataOrganization, Composite composite) {
        Structure struct;
        DataTypeComponent flexibleArrayComponent;
        DataTypeComponent[] dataTypeComponents;
        int allComponentsLCM = 1;
        int packingAlignment = composite.getPackingValue();
        for (DataTypeComponent dataTypeComponent : dataTypeComponents = composite.getComponents()) {
            int impartedAlignment = CompositeAlignmentHelper.getPackedAlignment(dataOrganization, packingAlignment, dataTypeComponent);
            if (impartedAlignment == 0) continue;
            allComponentsLCM = DataOrganizationImpl.getLeastCommonMultiple(allComponentsLCM, impartedAlignment);
        }
        if (composite instanceof Structure && (flexibleArrayComponent = (struct = (Structure)composite).getFlexibleArrayComponent()) != null) {
            allComponentsLCM = CompositeAlignmentHelper.getComponentAlignmentLCM(dataOrganization, allComponentsLCM, packingAlignment, flexibleArrayComponent);
        }
        return allComponentsLCM;
    }

    private static int getComponentAlignmentLCM(DataOrganization dataOrganization, int allComponentsLCM, int packingValue, DataTypeComponent component) {
        int componentAlignment = CompositeAlignmentHelper.getPackedAlignment(dataOrganization, packingValue, component);
        allComponentsLCM = DataOrganizationImpl.getLeastCommonMultiple(allComponentsLCM, componentAlignment);
        return allComponentsLCM;
    }

    public static int getPackedAlignment(DataOrganization dataOrganization, int packingValue, DataTypeComponent component) {
        if (component.isZeroBitFieldComponent() && component.getParent() instanceof Union && !dataOrganization.getBitFieldPacking().useMSConvention()) {
            return 0;
        }
        DataType componentDt = component.getDataType();
        int dtSize = componentDt.getLength();
        if (dtSize <= 0) {
            dtSize = component.getLength();
        }
        return CompositeAlignmentHelper.getPackedAlignment(dataOrganization, packingValue, componentDt, dtSize);
    }

    private static int getPackedAlignment(int componentAlignment, int forcedAlignment, int packingAlignment) {
        int alignment = componentAlignment;
        if (packingAlignment != 0) {
            if (forcedAlignment > packingAlignment) {
                alignment = forcedAlignment;
            } else if (alignment > packingAlignment) {
                alignment = packingAlignment;
            }
        }
        return alignment;
    }

    public static int getPackedAlignment(DataOrganization dataOrganization, int packingAlignment, DataType componentDt, int dtSize) {
        boolean componentForcingAlignment;
        int componentAlignment = dataOrganization.getAlignment(componentDt, dtSize);
        int componentForcedAlignment = dataOrganization.getForcedAlignment(componentDt);
        boolean bl = componentForcingAlignment = componentForcedAlignment > 0;
        if (componentForcingAlignment) {
            componentAlignment = DataOrganizationImpl.getLeastCommonMultiple(componentAlignment, componentForcedAlignment);
        }
        return CompositeAlignmentHelper.getPackedAlignment(componentAlignment, componentForcedAlignment, packingAlignment);
    }

    public static int getAlignment(DataOrganization dataOrganization, Composite dataType) {
        int absoluteMaxAlignment;
        if (!dataType.isInternallyAligned()) {
            return 1;
        }
        int lcm = CompositeAlignmentHelper.getCompositeAlignmentMultiple(dataOrganization, dataType);
        int minimumAlignment = dataType.getMinimumAlignment();
        if (minimumAlignment != 0 && lcm % minimumAlignment != 0) {
            lcm = DataOrganizationImpl.getLeastCommonMultiple(lcm, minimumAlignment);
        }
        return (absoluteMaxAlignment = dataOrganization.getAbsoluteMaxAlignment()) == 0 || lcm < absoluteMaxAlignment ? lcm : absoluteMaxAlignment;
    }
}

