/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.block;

import ghidra.program.model.address.Address;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceImpl;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.block.SimpleBlockModel;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.LinkedList;

public class SimpleDestReferenceIterator
implements CodeBlockReferenceIterator {
    private LinkedList<CodeBlockReferenceImpl> blockRefQueue = new LinkedList();
    private TaskMonitor monitor;

    public SimpleDestReferenceIterator(CodeBlock block, boolean followIndirectFlows, TaskMonitor monitor) throws CancelledException {
        this.monitor = monitor;
        SimpleDestReferenceIterator.getDestinations(block, this.blockRefQueue, followIndirectFlows, monitor);
    }

    @Override
    public CodeBlockReference next() throws CancelledException {
        this.monitor.checkCanceled();
        return this.blockRefQueue.isEmpty() ? null : (CodeBlockReference)this.blockRefQueue.removeFirst();
    }

    @Override
    public boolean hasNext() throws CancelledException {
        this.monitor.checkCanceled();
        return !this.blockRefQueue.isEmpty();
    }

    public static int getNumDestinations(CodeBlock block, boolean followIndirectFlows, TaskMonitor monitor) throws CancelledException {
        return SimpleDestReferenceIterator.getDestinations(block, null, followIndirectFlows, monitor);
    }

    private static int getDestinations(CodeBlock block, LinkedList<CodeBlockReferenceImpl> blockRefQueue, boolean followIndirectFlows, TaskMonitor monitor) throws CancelledException {
        Address addr;
        if (block == null) {
            return 0;
        }
        CodeBlockModel m = block.getModel().getBasicBlockModel();
        if (!(m instanceof SimpleBlockModel)) {
            throw new IllegalArgumentException();
        }
        SimpleBlockModel model = (SimpleBlockModel)m;
        boolean includeExternals = model.externalsIncluded();
        Address start = block.getMinAddress();
        Address end = block.getMaxAddress();
        if (start == null || start.isExternalAddress()) {
            return 0;
        }
        int count = 0;
        Listing listing = model.getListing();
        ReferenceIterator refIter = model.getProgram().getReferenceManager().getReferenceIterator(start);
        Instruction instr = null;
        while (refIter.hasNext()) {
            if (monitor != null && monitor.isCancelled()) {
                throw new CancelledException();
            }
            Reference ref = refIter.next();
            Address fromAddr = ref.getFromAddress();
            if (fromAddr.compareTo(end) > 0) break;
            RefType refType = ref.getReferenceType();
            if (!refType.isFlow()) continue;
            if (refType == RefType.INDIRECTION) {
                Instruction destInstr = listing.getInstructionContaining(ref.getToAddress());
                int cnt = 0;
                if (destInstr == null && followIndirectFlows) {
                    if (instr == null || !instr.getMinAddress().equals(fromAddr)) {
                        instr = listing.getInstructionAt(fromAddr);
                    }
                    cnt = SimpleDestReferenceIterator.followIndirection(blockRefQueue, includeExternals, block, ref, instr.getFlowType().isCall() ? RefType.COMPUTED_CALL : RefType.COMPUTED_JUMP, monitor);
                }
                if (cnt == 0) {
                    SimpleDestReferenceIterator.queueDestReference(blockRefQueue, block, fromAddr, ref.getToAddress(), RefType.INDIRECTION);
                    cnt = 1;
                }
                count += cnt;
                continue;
            }
            SimpleDestReferenceIterator.queueDestReference(blockRefQueue, block, fromAddr, ref.getToAddress(), (FlowType)refType);
            ++count;
        }
        if (followIndirectFlows && count == 0 && block.getFlowType().isComputed() && (instr = listing.getInstructionContaining(block.getMaxAddress())) != null) {
            while (instr.isInDelaySlot()) {
                Reference[] fallFrom = instr.getFallFrom();
                if (fallFrom == null) {
                    Msg.warn(SimpleDestReferenceIterator.class, (Object)("WARNING: Invalid delay slot instruction found at " + instr.getMinAddress()));
                    break;
                }
                instr = listing.getInstructionContaining((Address)fallFrom);
            }
            for (Reference ref : instr.getReferencesFrom()) {
                count += SimpleDestReferenceIterator.followIndirection(blockRefQueue, includeExternals, block, ref, instr.getFlowType().isCall() ? RefType.COMPUTED_CALL : RefType.COMPUTED_JUMP, monitor);
            }
        }
        if ((instr = listing.getInstructionContaining(end)) != null && (instr = instr.getNext()) != null && (addr = instr.getFallFrom()) != null && addr.compareTo(end) <= 0) {
            SimpleDestReferenceIterator.queueDestReference(blockRefQueue, block, addr, instr.getMinAddress(), RefType.FALL_THROUGH);
            ++count;
        }
        return count;
    }

    private static int followIndirection(LinkedList<CodeBlockReferenceImpl> blockRefQueue, boolean includeExternals, CodeBlock srcBlock, Reference srcRef, FlowType indirectFlowType, TaskMonitor monitor) throws CancelledException {
        SimpleBlockModel model = (SimpleBlockModel)srcBlock.getModel();
        Address addr = srcRef.getToAddress();
        Listing listing = model.getListing();
        Data data = listing.getDefinedDataContaining(addr);
        if (data == null) {
            return 0;
        }
        int cnt = 0;
        int offset = (int)addr.subtract(data.getMinAddress());
        Data primitive = data.getPrimitiveAt(offset);
        if (primitive != null) {
            Reference[] refs = primitive.getReferencesFrom();
            for (int i = 0; i < refs.length; ++i) {
                monitor.checkCanceled();
                CodeBlock destBlock = null;
                Address toAddr = refs[i].getToAddress();
                if (toAddr.isMemoryAddress()) {
                    CodeUnit cu = listing.getCodeUnitAt(toAddr);
                    if (cu != null) {
                        if (cu instanceof Instruction) {
                            if (blockRefQueue != null) {
                                destBlock = model.getFirstCodeBlockContaining(toAddr, monitor);
                            }
                        } else if (cu instanceof Data && ((Data)cu).isDefined()) {
                            continue;
                        }
                    }
                } else if (toAddr.isExternalAddress()) {
                    if (!includeExternals) continue;
                    if (blockRefQueue != null) {
                        destBlock = model.getFirstCodeBlockContaining(toAddr, monitor);
                    }
                }
                if (blockRefQueue != null) {
                    if (destBlock == null) {
                        destBlock = model.createSimpleDataBlock(toAddr, toAddr);
                    }
                    blockRefQueue.add(new CodeBlockReferenceImpl(srcBlock, destBlock, indirectFlowType, toAddr, srcRef.getFromAddress()));
                }
                ++cnt;
            }
        }
        return cnt;
    }

    private static void queueDestReference(LinkedList<CodeBlockReferenceImpl> blockRefQueue, CodeBlock srcBlock, Address fromAddr, Address toAddr, FlowType flowType) {
        if (blockRefQueue == null) {
            return;
        }
        blockRefQueue.add(new CodeBlockReferenceImpl(srcBlock, null, flowType, toAddr, fromAddr));
    }
}

