/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBHandle;
import db.Record;
import db.RecordIterator;
import ghidra.program.database.ManagerDB;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.symbol.OldVariableStorageDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.program.util.LanguageTranslator;
import ghidra.util.Lock;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Hashtable;

public class OldVariableStorageManagerDB
implements ManagerDB {
    private ProgramDB program;
    private AddressMap addrMap;
    private Lock lock;
    private OldVariableStorageDBAdapter adapter;
    private DBHandle handle;
    private long lastNamespaceCacheID;
    private Hashtable<Address, OldVariableStorage> variableAddrLookupCache = new Hashtable();
    private Hashtable<Address, OldVariableStorage> storageAddrLookupCache = new Hashtable();

    public OldVariableStorageManagerDB(DBHandle handle, AddressMap addrMap, int openMode, Lock lock, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        this.addrMap = addrMap;
        this.lock = lock;
        this.handle = handle;
        this.adapter = OldVariableStorageDBAdapter.getAdapter(handle, openMode, monitor);
    }

    public static boolean isOldVariableStorageManagerUpgradeRequired(DBHandle handle) {
        return handle.getTable("VariableStorage") != null;
    }

    @Override
    public void invalidateCache(boolean all) {
        this.lastNamespaceCacheID = -1L;
        this.variableAddrLookupCache.clear();
        this.storageAddrLookupCache.clear();
    }

    @Override
    public void programReady(int openMode, int currentRevision, TaskMonitor monitor) throws IOException, CancelledException {
    }

    @Override
    public void setProgram(ProgramDB program) {
        this.program = program;
    }

    void deleteTable() throws IOException {
        this.handle.deleteTable("VariableStorage");
        this.invalidateCache(true);
    }

    private void cacheNamespaceStorage(long namespaceID) throws IOException {
        Record[] records;
        this.variableAddrLookupCache.clear();
        this.storageAddrLookupCache.clear();
        this.lastNamespaceCacheID = namespaceID;
        for (Record rec : records = this.adapter.getRecordsForNamespace(namespaceID)) {
            OldVariableStorage varStore = new OldVariableStorage(rec);
            this.variableAddrLookupCache.put(varStore.variableAddr, varStore);
            this.storageAddrLookupCache.put(varStore.storageAddr, varStore);
        }
    }

    private OldVariableStorage getVariableStorage(Address variableAddr) throws IOException {
        OldVariableStorage varStore;
        if (!variableAddr.isVariableAddress()) {
            throw new IllegalArgumentException();
        }
        if (this.lastNamespaceCacheID != -1L && (varStore = this.variableAddrLookupCache.get(variableAddr)) != null) {
            return varStore;
        }
        Record rec = this.adapter.getRecord(variableAddr.getOffset());
        if (rec == null) {
            return null;
        }
        this.cacheNamespaceStorage(rec.getLongValue(1));
        return this.variableAddrLookupCache.get(variableAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address getStorageAddress(Address variableAddr) throws IOException {
        this.lock.acquire();
        try {
            OldVariableStorage varStore = this.getVariableStorage(variableAddr);
            if (varStore != null) {
                Address address = varStore.storageAddr;
                return address;
            }
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    public boolean isUpgradeOldVariableAddressesRequired() {
        return this.adapter.upgradeOldVariableAddressesRequired;
    }

    @Override
    public void deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLanguage(LanguageTranslator translator, TaskMonitor monitor) throws CancelledException, IOException {
        monitor.initialize((long)this.adapter.getRecordCount());
        int cnt = 0;
        this.lock.acquire();
        try {
            RecordIterator recIter = this.adapter.getRecords();
            while (recIter.hasNext()) {
                Register newReg;
                monitor.checkCanceled();
                Record rec = recIter.next();
                Address storageAddr = this.addrMap.decodeAddress(rec.getLongValue(0));
                Register oldReg = translator.getOldRegister(storageAddr, 0);
                if (oldReg != null && (newReg = translator.getNewRegister(oldReg)) != null) {
                    rec.setLongValue(0, this.addrMap.getKey(newReg.getAddress(), true));
                    this.adapter.updateRecord(rec);
                }
                monitor.setProgress((long)(++cnt));
            }
        }
        finally {
            this.invalidateCache(true);
            this.lock.release();
        }
    }

    private class OldVariableStorage {
        private final Address variableAddr;
        private final Address storageAddr;

        private OldVariableStorage(Record record) {
            this.variableAddr = AddressSpace.VARIABLE_SPACE.getAddress(record.getKey());
            this.storageAddr = OldVariableStorageManagerDB.this.addrMap.decodeAddress(record.getLongValue(0));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OldVariableStorage)) {
                return false;
            }
            return this.variableAddr.getOffset() == ((OldVariableStorage)obj).variableAddr.getOffset();
        }

        public int hashCode() {
            return (int)this.variableAddr.getOffset();
        }
    }
}

