/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import db.DBHandle;
import db.Record;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.code.ProtoDBAdapter;
import ghidra.program.database.code.PrototypeManager;
import ghidra.program.database.util.DatabaseVersionException;
import java.io.IOException;

class ProtoDBAdapterV1
implements ProtoDBAdapter {
    private Table table;

    ProtoDBAdapterV1(DBHandle handle) throws DatabaseVersionException {
        this.table = handle.getTable("Prototypes");
        this.testVersion(1);
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public int getNumRecords() throws IOException {
        return this.table.getRecordCount();
    }

    private void testVersion(int expectedVersion) throws DatabaseVersionException {
        if (this.table == null) {
            throw new DatabaseVersionException("Instruction table not found");
        }
        int versionNumber = this.table.getSchema().getVersion();
        if (versionNumber != expectedVersion) {
            throw new DatabaseVersionException("Prototype table: Expected Version " + expectedVersion + ", got " + versionNumber);
        }
    }

    @Override
    public void createRecord(int protoID, long addr, byte[] b, boolean inDelaySlot) throws IOException {
        Record record = PrototypeManager.PROTO_SCHEMA.createRecord((long)protoID);
        record.setBinaryData(0, b);
        record.setLongValue(1, addr);
        record.setBooleanValue(2, inDelaySlot);
        this.table.putRecord(record);
    }

    @Override
    public long getKey() throws IOException {
        return this.table.getKey();
    }

    @Override
    public Record getRecord(int protoId) throws IOException {
        return this.table.getRecord((long)protoId);
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return this.table.iterator();
    }

    @Override
    public void deleteAll() throws IOException {
        this.table.deleteAll();
    }
}

