/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.bookmark;

import db.DBHandle;
import db.Record;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.bookmark.BookmarkTypeDBAdapter;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.ArrayList;

public class BookmarkTypeDBAdapterV0
extends BookmarkTypeDBAdapter {
    private Table table;

    public BookmarkTypeDBAdapterV0(DBHandle dbHandle, boolean create) throws VersionException, IOException {
        if (create) {
            this.table = dbHandle.createTable("Bookmark Types", SCHEMA);
        } else {
            this.table = dbHandle.getTable("Bookmark Types");
            if (this.table == null) {
                throw new VersionException(true);
            }
            if (this.table.getSchema().getVersion() != 0) {
                throw new VersionException(false);
            }
        }
    }

    @Override
    Record[] getRecords() throws IOException {
        ArrayList<Record> list = new ArrayList<Record>();
        RecordIterator iter = this.table.iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        Record[] recs = new Record[list.size()];
        list.toArray(recs);
        return recs;
    }

    @Override
    void addType(int typeId, String type) throws IOException {
        Record rec = SCHEMA.createRecord((long)typeId);
        rec.setString(0, type);
        this.table.putRecord(rec);
    }

    @Override
    void deleteRecord(long typeId) throws IOException {
        this.table.deleteRecord(typeId);
    }
}

