/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.bookmark;

import db.Record;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import ghidra.program.database.bookmark.BookmarkDBManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkType;

public class BookmarkDB
extends DatabaseObject
implements Bookmark {
    private BookmarkDBManager mgr;
    private Record record;

    BookmarkDB(BookmarkDBManager mgr, DBObjectCache<BookmarkDB> cache, Record record) {
        super(cache, record.getKey());
        this.mgr = mgr;
        this.record = record;
    }

    public String toString() {
        return this.getTypeString() + " - " + this.getCategory() + " - " + this.getComment() + " - " + this.getAddress();
    }

    void setRecord(Record rec) {
        if (rec.getKey() != this.key) {
            throw new IllegalArgumentException("Key mismatch");
        }
        this.record = rec;
    }

    @Override
    public long getId() {
        return this.key;
    }

    @Override
    public Address getAddress() {
        this.checkIsValid();
        return this.mgr.getAddress(this.record.getLongValue(0));
    }

    @Override
    public BookmarkType getType() {
        return this.mgr.getBookmarkType((int)(this.key >> 48));
    }

    @Override
    public String getTypeString() {
        return this.getType().getTypeString();
    }

    @Override
    public String getCategory() {
        return this.record.getString(1);
    }

    public void setComment(String comment) {
        this.checkDeleted();
        if (comment == null) {
            comment = "";
        }
        if (!comment.equals(this.record.getString(2))) {
            this.record.setString(2, comment);
            this.mgr.bookmarkChanged(this);
        }
    }

    @Override
    public String getComment() {
        return this.record.getString(2);
    }

    @Override
    public void set(String category, String comment) {
        this.checkDeleted();
        if (category == null) {
            category = "";
        }
        if (comment == null) {
            comment = "";
        }
        if (!comment.equals(this.record.getString(2)) || !category.equals(this.record.getString(1))) {
            this.record.setString(1, category);
            this.record.setString(2, comment);
            this.mgr.bookmarkChanged(this);
        }
    }

    @Override
    protected boolean refresh() {
        return this.refresh(null);
    }

    @Override
    protected boolean refresh(Record rec) {
        if (rec == null) {
            rec = this.mgr.getRecord(this.key);
        }
        if (rec == null) {
            return false;
        }
        this.record = rec;
        return true;
    }

    Record getRecord() {
        return this.checkIsValid() ? this.record : null;
    }

    public int hashCode() {
        return (int)this.key;
    }

    @Override
    public int compareTo(Bookmark otherBm) {
        int rc = this.getAddress().compareTo(otherBm.getAddress());
        if (rc != 0) {
            return rc;
        }
        rc = this.getTypeString().compareTo(otherBm.getTypeString());
        if (rc != 0) {
            return rc;
        }
        rc = this.getCategory().compareTo(otherBm.getCategory());
        if (rc != 0) {
            return rc;
        }
        return this.getComment().compareTo(otherBm.getComment());
    }
}

