/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.generic;

import ghidra.app.plugin.processors.generic.Handle;
import ghidra.app.plugin.processors.generic.Operand;
import ghidra.app.plugin.processors.generic.Position;
import ghidra.app.plugin.processors.generic.VarnodeTemplate;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.io.Serializable;
import java.util.HashMap;

public class OpTemplate
implements Serializable {
    private Operand omit;
    private VarnodeTemplate output;
    private VarnodeTemplate[] input;
    private int numInputs;
    private int opcode;
    private AddressFactory addressFactory;

    public OpTemplate(int opc, VarnodeTemplate[] in, VarnodeTemplate out, AddressFactory af) {
        this.opcode = opc;
        this.input = in;
        this.output = out;
        this.numInputs = in.length;
        this.addressFactory = af;
    }

    public PcodeOp getPcode(HashMap<Object, Handle> handles, Position position, int opSequenceNumber, int off) throws Exception {
        Varnode ptr;
        Address addr;
        Varnode space;
        int opc = this.opcode;
        Varnode out = null;
        if (this.output != null) {
            out = this.output.resolve(handles, position, off);
        }
        Varnode[] in = new Varnode[this.numInputs];
        for (int i = 0; i < this.numInputs; ++i) {
            in[i] = this.input[i].resolve(handles, position, off);
        }
        if (this.opcode == 3) {
            Varnode ptr2 = in[1];
            if (ptr2.isConstant()) {
                space = in[0];
                Varnode src = in[2];
                addr = this.addressFactory.getAddress((int)space.getOffset(), ptr2.getOffset());
                out = new Varnode(addr, src.getSize());
                in = new Varnode[]{src};
                opc = 1;
            }
        } else if (this.opcode == 2 && (ptr = in[1]).isConstant()) {
            space = in[0];
            Varnode dest = out;
            addr = this.addressFactory.getAddress((int)space.getOffset(), ptr.getOffset());
            in = new Varnode[]{new Varnode(addr, dest.getSize())};
            opc = 1;
        }
        for (int i = 0; i < in.length; ++i) {
            in[i].trim();
        }
        return new PcodeOp(position.startAddr(), opSequenceNumber, opc, in, out);
    }

    public int opcode() {
        return this.opcode;
    }

    public VarnodeTemplate input(int i) {
        return this.input[i];
    }

    public VarnodeTemplate output() {
        return this.output;
    }

    public void setOmit(Operand ref) {
        this.omit = ref;
    }

    public boolean omit() {
        return this.omit != null && !this.omit.dynamic();
    }
}

