/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh;

import ghidra.app.plugin.assembler.Assembler;
import ghidra.app.plugin.assembler.AssemblyError;
import ghidra.app.plugin.assembler.AssemblySelectionError;
import ghidra.app.plugin.assembler.AssemblySelector;
import ghidra.app.plugin.assembler.AssemblySemanticException;
import ghidra.app.plugin.assembler.AssemblySyntaxException;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParseAcceptResult;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParseErrorResult;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParseResult;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParser;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyContextGraph;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyDefaultContext;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolutionResults;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedConstructor;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyTreeResolver;
import ghidra.app.plugin.assembler.sleigh.util.DbgTimer;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.disassemble.DisassemblerMessageListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.lang.InstructionBlock;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SleighAssembler
implements Assembler {
    public static final int DEFAULT_MAX_RECURSION_DEPTH = 2;
    protected static final DbgTimer dbg = DbgTimer.INACTIVE;
    protected AssemblySelector selector;
    protected Program program;
    protected Listing listing;
    protected Memory memory;
    protected Disassembler dis;
    protected AssemblyParser parser;
    protected AssemblyDefaultContext defaultContext;
    protected AssemblyContextGraph ctxGraph;
    protected SleighLanguage lang;

    protected SleighAssembler(AssemblySelector selector, Program program, AssemblyParser parser, AssemblyDefaultContext defaultContext, AssemblyContextGraph ctxGraph) {
        this(selector, (SleighLanguage)program.getLanguage(), parser, defaultContext, ctxGraph);
        this.program = program;
        this.listing = program.getListing();
        this.memory = program.getMemory();
        this.dis = Disassembler.getDisassembler(program, TaskMonitor.DUMMY, DisassemblerMessageListener.IGNORE);
    }

    protected SleighAssembler(AssemblySelector selector, SleighLanguage lang, AssemblyParser parser, AssemblyDefaultContext defaultContext, AssemblyContextGraph ctxGraph) {
        this.selector = selector;
        this.lang = lang;
        this.parser = parser;
        this.defaultContext = defaultContext;
        this.ctxGraph = ctxGraph;
    }

    @Override
    public Instruction patchProgram(AssemblyResolvedConstructor res, Address at) throws MemoryAccessException {
        if (!res.getInstruction().isFullMask()) {
            throw new AssemblySelectionError("Selected instruction must have a full mask.");
        }
        return this.patchProgram(res.getInstruction().getVals(), at);
    }

    @Override
    public Instruction patchProgram(byte[] insbytes, Address at) throws MemoryAccessException {
        this.listing.clearCodeUnits(at, at.add(insbytes.length - 1), false);
        this.memory.setBytes(at, insbytes);
        this.dis.disassemble(at, new AddressSet(at));
        return this.listing.getInstructionAt(at);
    }

    @Override
    public InstructionBlock assemble(Address at, String ... assembly) throws AssemblySyntaxException, AssemblySemanticException, MemoryAccessException, AddressOverflowException {
        InstructionBlock block = new InstructionBlock(at);
        for (String part : assembly) {
            for (String line : part.split("\n")) {
                RegisterValue rv = this.program.getProgramContext().getDisassemblyContext(at);
                dbg.println(rv);
                AssemblyPatternBlock ctx = AssemblyPatternBlock.fromRegisterValue(rv);
                ctx = ctx.fillMask();
                byte[] insbytes = this.assembleLine(at, line, ctx);
                if (insbytes == null) {
                    return null;
                }
                Instruction ins = this.patchProgram(insbytes, at);
                block.addInstruction(ins);
                at = at.addNoWrap(insbytes.length);
            }
        }
        return block;
    }

    @Override
    public byte[] assembleLine(Address at, String line) throws AssemblySyntaxException, AssemblySemanticException {
        AssemblyPatternBlock ctx = this.defaultContext.getDefaultAt(at);
        ctx = ctx.fillMask();
        return this.assembleLine(at, line, ctx);
    }

    @Override
    public Collection<AssemblyParseResult> parseLine(String line) {
        return this.parser.parse(line, this.getProgramLabels());
    }

    @Override
    public AssemblyResolutionResults resolveTree(AssemblyParseResult parse, Address at) {
        AssemblyPatternBlock ctx = this.getContextAt(at);
        ctx = ctx.fillMask();
        return this.resolveTree(parse, at, ctx);
    }

    @Override
    public AssemblyResolutionResults resolveTree(AssemblyParseResult parse, Address at, AssemblyPatternBlock ctx) {
        if (parse.isError()) {
            AssemblyResolutionResults results = new AssemblyResolutionResults();
            AssemblyParseErrorResult err = (AssemblyParseErrorResult)parse;
            results.add(AssemblyResolution.error(err.describeError(), "Parsing", null));
            return results;
        }
        AssemblyParseAcceptResult acc = (AssemblyParseAcceptResult)parse;
        AssemblyTreeResolver tr = new AssemblyTreeResolver(this.lang, at.getOffset(), acc.getTree(), ctx, this.ctxGraph);
        return tr.resolve();
    }

    @Override
    public AssemblyResolutionResults resolveLine(Address at, String line) throws AssemblySyntaxException {
        return this.resolveLine(at, line, this.getContextAt(at).fillMask());
    }

    @Override
    public AssemblyResolutionResults resolveLine(Address at, String line, AssemblyPatternBlock ctx) throws AssemblySyntaxException {
        if (!ctx.isFullMask()) {
            throw new AssemblyError("Context must be fully-specified (full length, no shift, no unknowns)");
        }
        if (this.lang.getContextBaseRegister() != null && ctx.length() < this.lang.getContextBaseRegister().getMinimumByteSize()) {
            throw new AssemblyError("Context must be fully-specified (full length, no shift, no unknowns)");
        }
        Collection<AssemblyParseResult> parse = this.parseLine(line);
        if (!(parse = this.selector.filterParse(parse)).iterator().hasNext()) {
            throw new AssemblySelectionError("Must select at least one parse result. Report errors via AssemblySyntaxError");
        }
        AssemblyResolutionResults results = new AssemblyResolutionResults();
        for (AssemblyParseResult p : parse) {
            results.absorb(this.resolveTree(p, at, ctx));
        }
        return results;
    }

    @Override
    public byte[] assembleLine(Address at, String line, AssemblyPatternBlock ctx) throws AssemblySemanticException, AssemblySyntaxException {
        AssemblyResolutionResults results = this.resolveLine(at, line, ctx);
        AssemblyResolvedConstructor res = this.selector.select(results, ctx);
        if (res == null) {
            throw new AssemblySelectionError("Must select exactly one instruction. Report errors via AssemblySemanticError");
        }
        if (!res.getInstruction().isFullMask()) {
            throw new AssemblySelectionError("Selected instruction must have a full mask.");
        }
        if (res.getContext().combine(ctx) == null) {
            throw new AssemblySelectionError("Selected instruction must have compatible context");
        }
        return res.getInstruction().getVals();
    }

    protected Map<String, Long> getProgramLabels() {
        HashMap<String, Long> labels = new HashMap<String, Long>();
        for (Register reg : this.lang.getRegisters()) {
            if ("register".equals(reg.getAddressSpace().getName())) continue;
            labels.put(reg.getName(), Long.valueOf(reg.getOffset()));
        }
        if (this.program != null) {
            SymbolIterator it = this.program.getSymbolTable().getAllSymbols(false);
            while (it.hasNext()) {
                Symbol sym = it.next();
                labels.put(sym.getName(), sym.getAddress().getOffset());
            }
        }
        return labels;
    }

    @Override
    public AssemblyPatternBlock getContextAt(Address addr) {
        if (this.program != null) {
            RegisterValue rv = this.program.getProgramContext().getDisassemblyContext(addr);
            return AssemblyPatternBlock.fromRegisterValue(rv);
        }
        return this.defaultContext.getDefaultAt(addr);
    }
}

