/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.DisplayStringProvider;
import docking.widgets.table.DynamicColumnTableModel;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GTableColumnModel;
import docking.widgets.table.RowFilterTransformer;
import docking.widgets.table.RowObjectTableModel;
import ghidra.docking.settings.Settings;
import ghidra.util.table.column.GColumnRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.table.TableColumnModel;

public class DefaultRowFilterTransformer<ROW_OBJECT>
implements RowFilterTransformer<ROW_OBJECT> {
    private List<String> columnData = new ArrayList<String>();
    private TableColumnModel columnModel;
    private final RowObjectTableModel<ROW_OBJECT> model;

    public DefaultRowFilterTransformer(RowObjectTableModel<ROW_OBJECT> tableModel, TableColumnModel columnModel) {
        this.model = tableModel;
        this.columnModel = columnModel;
    }

    @Override
    public List<String> transform(ROW_OBJECT rowObject) {
        this.columnData.clear();
        int columnCount = this.model.getColumnCount();
        for (int col = 0; col < columnCount; ++col) {
            String value = this.getStringValue(rowObject, col);
            if (value == null) continue;
            this.columnData.add(value);
        }
        return this.columnData;
    }

    protected String getStringValue(ROW_OBJECT rowObject, int column) {
        if (this.columnModel instanceof GTableColumnModel && !((GTableColumnModel)this.columnModel).isVisible(column)) {
            return null;
        }
        Object value = this.model.getColumnValueForRow(rowObject, column);
        if (value == null) {
            return null;
        }
        String renderedString = this.getRenderedColumnValue(value, column);
        if (renderedString != null) {
            return renderedString;
        }
        if (value instanceof DisplayStringProvider) {
            return ((DisplayStringProvider)value).toString();
        }
        if (value instanceof JLabel) {
            JLabel label = (JLabel)value;
            String valueString = label.getText();
            return valueString == null ? "" : valueString;
        }
        return value.toString();
    }

    private String getRenderedColumnValue(Object columnValue, int columnIndex) {
        if (!(this.model instanceof DynamicColumnTableModel)) {
            return null;
        }
        DynamicColumnTableModel columnBasedModel = (DynamicColumnTableModel)this.model;
        GColumnRenderer<Object> renderer = this.getColumnRenderer(columnBasedModel, columnIndex);
        if (renderer == null) {
            return null;
        }
        GColumnRenderer.ColumnConstraintFilterMode mode = renderer.getColumnConstraintFilterMode();
        if (mode == GColumnRenderer.ColumnConstraintFilterMode.USE_COLUMN_CONSTRAINTS_ONLY) {
            return null;
        }
        Settings settings = columnBasedModel.getColumnSettings(columnIndex);
        String s = renderer.getFilterString(columnValue, settings);
        return s;
    }

    private GColumnRenderer<Object> getColumnRenderer(DynamicColumnTableModel<ROW_OBJECT> columnBasedModel, int columnIndex) {
        DynamicTableColumn<ROW_OBJECT, ?, ?> column = columnBasedModel.getColumn(columnIndex);
        GColumnRenderer<Object> columnRenderer = column.getColumnRenderer();
        return columnRenderer;
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultRowFilterTransformer other = (DefaultRowFilterTransformer)obj;
        if (!Objects.equals(this.columnData, other.columnData)) {
            return false;
        }
        if (!Objects.equals(this.columnModel, other.columnModel)) {
            return false;
        }
        return this.model == other.model;
    }
}

