/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.AdjustmentListener;
import javax.accessibility.AccessibleContext;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.plaf.ScrollBarUI;

public class SideKickVerticalScrollbar
extends JScrollBar {
    private JScrollBar delegate;
    private final JViewport viewport;

    public SideKickVerticalScrollbar(Component sideKick, JViewport viewport) {
        this.viewport = viewport;
        this.delegate = new MyScrollBar();
        this.setLayout(new BorderLayout());
        this.add((Component)this.delegate, "West");
        JPanel panel = new JPanel(new SideKickLayout());
        panel.add(sideKick);
        this.add((Component)panel, "East");
    }

    @Override
    public void addAdjustmentListener(AdjustmentListener l) {
        this.delegate.addAdjustmentListener(l);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return this.delegate.getAccessibleContext();
    }

    @Override
    public AdjustmentListener[] getAdjustmentListeners() {
        return this.delegate.getAdjustmentListeners();
    }

    @Override
    public int getBlockIncrement() {
        return this.delegate.getBlockIncrement();
    }

    @Override
    public int getBlockIncrement(int direction) {
        return this.delegate.getBlockIncrement(direction);
    }

    @Override
    public int getMaximum() {
        return this.delegate.getMaximum();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.delegate.getMaximumSize();
    }

    @Override
    public int getMinimum() {
        return this.delegate.getMinimum();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.delegate.getMinimumSize();
    }

    @Override
    public BoundedRangeModel getModel() {
        return this.delegate.getModel();
    }

    @Override
    public int getOrientation() {
        return this.delegate.getOrientation();
    }

    @Override
    public ScrollBarUI getUI() {
        return this.delegate.getUI();
    }

    @Override
    public String getUIClassID() {
        return this.delegate.getUIClassID();
    }

    @Override
    public int getUnitIncrement() {
        return this.delegate.getUnitIncrement();
    }

    @Override
    public int getUnitIncrement(int direction) {
        return this.delegate.getUnitIncrement(direction);
    }

    @Override
    public int getValue() {
        return this.delegate.getValue();
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.delegate.getValueIsAdjusting();
    }

    @Override
    public int getVisibleAmount() {
        return this.delegate.getVisibleAmount();
    }

    @Override
    public void removeAdjustmentListener(AdjustmentListener l) {
        this.delegate.removeAdjustmentListener(l);
    }

    @Override
    public void setBlockIncrement(int blockIncrement) {
        this.delegate.setBlockIncrement(blockIncrement);
    }

    @Override
    public void setEnabled(boolean x) {
        this.delegate.setEnabled(x);
    }

    @Override
    public void setMaximum(int maximum) {
        this.delegate.setMaximum(maximum);
    }

    @Override
    public void setMaximumSize(Dimension maximumSize) {
        this.delegate.setMaximumSize(maximumSize);
    }

    @Override
    public void setMinimum(int minimum) {
        this.delegate.setMinimum(minimum);
    }

    @Override
    public void setMinimumSize(Dimension minimumSize) {
        this.delegate.setMinimumSize(minimumSize);
    }

    @Override
    public void setModel(BoundedRangeModel newModel) {
        this.delegate.setModel(newModel);
    }

    @Override
    public void setOrientation(int orientation) {
        this.delegate.setOrientation(orientation);
    }

    @Override
    public void setUI(ScrollBarUI ui) {
        this.delegate.setUI(ui);
    }

    @Override
    public void setUnitIncrement(int unitIncrement) {
        this.delegate.setUnitIncrement(unitIncrement);
    }

    @Override
    public void setValue(int value) {
        this.delegate.setValue(value);
    }

    @Override
    public void setValueIsAdjusting(boolean b) {
        this.delegate.setValueIsAdjusting(b);
    }

    @Override
    public void setValues(int newValue, int newExtent, int newMin, int newMax) {
        this.delegate.setValues(newValue, newExtent, newMin, newMax);
    }

    @Override
    public void setVisibleAmount(int extent) {
        this.delegate.setVisibleAmount(extent);
    }

    @Override
    public void updateUI() {
        if (this.delegate == null) {
            return;
        }
        this.delegate.updateUI();
    }

    class SideKickLayout
    implements LayoutManager {
        SideKickLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension size = parent.getSize();
            Component sideKick = parent.getComponent(0);
            int height = size.height;
            int y = 0;
            Component[] components = SideKickVerticalScrollbar.this.delegate.getComponents();
            if (components.length == 2) {
                Component topButton = SideKickVerticalScrollbar.this.delegate.getComponent(1);
                Component bottomButton = SideKickVerticalScrollbar.this.delegate.getComponent(0);
                Rectangle topBounds = topButton.getBounds();
                Rectangle bottomBounds = bottomButton.getBounds();
                height = size.height - topBounds.height - bottomBounds.height;
                y = topBounds.y + topBounds.height;
            } else {
                Dimension preferredSize = SideKickVerticalScrollbar.this.delegate.getPreferredSize();
                y = preferredSize.width / 2;
                height -= preferredSize.width;
            }
            sideKick.setBounds(0, y, size.width, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getComponent(0).getPreferredSize();
        }
    }

    class MyScrollBar
    extends JScrollBar {
        MyScrollBar() {
        }

        @Override
        public int getUnitIncrement(int direction) {
            if (SideKickVerticalScrollbar.this.viewport != null && SideKickVerticalScrollbar.this.viewport.getView() instanceof Scrollable) {
                Scrollable view = (Scrollable)((Object)SideKickVerticalScrollbar.this.viewport.getView());
                Rectangle vr = SideKickVerticalScrollbar.this.viewport.getViewRect();
                return view.getScrollableUnitIncrement(vr, this.getOrientation(), direction);
            }
            return super.getUnitIncrement(direction);
        }

        @Override
        public int getBlockIncrement(int direction) {
            if (SideKickVerticalScrollbar.this.viewport == null) {
                return SideKickVerticalScrollbar.this.delegate.getBlockIncrement(direction);
            }
            if (SideKickVerticalScrollbar.this.viewport.getView() instanceof Scrollable) {
                Scrollable view = (Scrollable)((Object)SideKickVerticalScrollbar.this.viewport.getView());
                Rectangle vr = SideKickVerticalScrollbar.this.viewport.getViewRect();
                return view.getScrollableBlockIncrement(vr, this.getOrientation(), direction);
            }
            return super.getBlockIncrement(direction);
        }
    }
}

