/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ComponentPlaceholder;
import docking.ComponentProvider;
import docking.PlaceholderManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class PlaceholderSet {
    private Map<ComponentProvider, ComponentPlaceholder> activePlaceholderMap = new HashMap<ComponentProvider, ComponentPlaceholder>();
    private Set<ComponentPlaceholder> unusedPlaceholders = new HashSet<ComponentPlaceholder>();
    private PlaceholderManager manager;

    PlaceholderSet(PlaceholderManager manager) {
        this.manager = manager;
    }

    void addRestoredPlaceholder(ComponentPlaceholder restoredPlaceholder) {
        ComponentPlaceholder existingPlaceholder = this.getMatchingUnusedPlaceholder(restoredPlaceholder);
        if (existingPlaceholder == null) {
            this.unusedPlaceholders.add(restoredPlaceholder);
            return;
        }
        if (restoredPlaceholder.wantsToBeShowing()) {
            this.unusedPlaceholders.remove(existingPlaceholder);
            existingPlaceholder.dispose();
            this.unusedPlaceholders.add(restoredPlaceholder);
        } else {
            restoredPlaceholder.dispose();
        }
    }

    void placeholderUsed(ComponentProvider provider, ComponentPlaceholder placeholder) {
        this.unusedPlaceholders.remove(placeholder);
        this.activePlaceholderMap.put(provider, placeholder);
    }

    ComponentPlaceholder placeholderFreed(ComponentProvider provider) {
        boolean keepAround;
        ComponentPlaceholder removedPlaceholder = this.activePlaceholderMap.remove(provider);
        if (removedPlaceholder == null) {
            return null;
        }
        boolean bl = keepAround = !this.containsAnyMatchingPlaceholder(removedPlaceholder);
        if (keepAround) {
            this.unusedPlaceholders.add(removedPlaceholder);
        }
        this.manager.disposePlaceholder(removedPlaceholder, keepAround);
        return removedPlaceholder;
    }

    Set<ComponentPlaceholder> getUsedPlaceholders() {
        return new HashSet<ComponentPlaceholder>(this.activePlaceholderMap.values());
    }

    Set<ComponentPlaceholder> getUnusedPlaceholders() {
        return this.unusedPlaceholders;
    }

    ComponentPlaceholder getPlaceholder(ComponentProvider provider) {
        return this.activePlaceholderMap.get(provider);
    }

    boolean containsPlaceholder(ComponentProvider provider) {
        return this.activePlaceholderMap.containsKey(provider);
    }

    void resetPlaceholdersWithoutProviders() {
        for (ComponentPlaceholder placeholder : this.unusedPlaceholders) {
            if (placeholder.hasProvider()) continue;
            placeholder.reset();
        }
    }

    void clear() {
        this.activePlaceholderMap.clear();
        this.unusedPlaceholders.clear();
    }

    Map<ComponentProvider, ComponentPlaceholder> getProviderMap() {
        return this.activePlaceholderMap;
    }

    void removeAll(String owner) {
        HashSet<Map.Entry<ComponentProvider, ComponentPlaceholder>> entries = new HashSet<Map.Entry<ComponentProvider, ComponentPlaceholder>>(this.activePlaceholderMap.entrySet());
        for (Map.Entry entry : entries) {
            ComponentPlaceholder placeholder = (ComponentPlaceholder)entry.getValue();
            this.manager.disposePlaceholder(placeholder, false);
        }
        this.activePlaceholderMap.clear();
        for (ComponentPlaceholder componentPlaceholder : this.unusedPlaceholders) {
            this.manager.disposePlaceholder(componentPlaceholder, false);
        }
        this.unusedPlaceholders.clear();
    }

    private boolean containsAnyMatchingPlaceholder(ComponentPlaceholder matchee) {
        return this.containsMatchingUnusedPlaceholder(matchee) || this.containsMatchingActivePlaceholder(matchee);
    }

    private boolean containsMatchingActivePlaceholder(ComponentPlaceholder matchee) {
        Collection<ComponentPlaceholder> activePlaceholders = this.activePlaceholderMap.values();
        return this.getMatchingPlaceholders(activePlaceholders, matchee) != null;
    }

    private boolean containsMatchingUnusedPlaceholder(ComponentPlaceholder matchee) {
        return this.getMatchingUnusedPlaceholder(matchee) != null;
    }

    private ComponentPlaceholder getMatchingUnusedPlaceholder(ComponentPlaceholder matchee) {
        return this.getMatchingPlaceholders(this.unusedPlaceholders, matchee);
    }

    private ComponentPlaceholder getMatchingPlaceholders(Collection<ComponentPlaceholder> placeholders, ComponentPlaceholder matchee) {
        String name = matchee.getName();
        for (ComponentPlaceholder placeholder : placeholders) {
            if (!placeholder.getName().equals(name)) continue;
            return placeholder;
        }
        return null;
    }
}

