/*
 * Decompiled with CFR 0.152.
 */
package utilities.util.reflection;

import ghidra.util.exception.AssertException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ReflectionUtilities {
    private static final String JAVA_AWT_PATTERN = "java.awt";
    private static final String JAVA_REFLECT_PATTERN = "java.lang.reflect";
    private static final String JDK_INTERNAL_REFLECT_PATTERN = "jdk.internal.reflect";
    private static final String SWING_JAVA_PATTERN = "java.swing";
    private static final String SWING_JAVAX_PATTERN = "javax.swing";
    private static final String SUN_AWT_PATTERN = "sun.awt";
    private static final String SUN_REFLECT_PATTERN = "sun.reflect";
    private static final String SECURITY_PATTERN = "java.security";
    private static final String JUNIT_PATTERN = ".junit";
    private static final String MOCKIT_PATTERN = "mockit";

    private ReflectionUtilities() {
    }

    public static Field locateStaticFieldObjectOnClass(String fieldName, Class<?> containingClass) {
        Field field;
        block2: {
            field = null;
            try {
                field = containingClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException nsfe) {
                Class<?> parentClass = containingClass.getSuperclass();
                if (parentClass == null) break block2;
                field = ReflectionUtilities.locateFieldObjectOnClass(fieldName, parentClass);
            }
        }
        return field;
    }

    public static Field locateFieldObjectOnClass(String fieldName, Class<?> containingClass) {
        Field field;
        block2: {
            field = null;
            try {
                field = containingClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException nsfe) {
                Class<?> parentClass = containingClass.getSuperclass();
                if (parentClass == null) break block2;
                field = ReflectionUtilities.locateFieldObjectOnClass(fieldName, parentClass);
            }
        }
        return field;
    }

    public static Method locateMethodObjectOnClass(String methodName, Class<?> containingClass, Class<?>[] parameterTypes) {
        Method method;
        block2: {
            method = null;
            try {
                method = containingClass.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException nsme) {
                Class<?> parentClass = containingClass.getSuperclass();
                if (parentClass == null) break block2;
                method = ReflectionUtilities.locateMethodObjectOnClass(methodName, parentClass, parameterTypes);
            }
        }
        return method;
    }

    public static Constructor<?> locateConstructorOnClass(Class<?> containingClass, Class<?>[] parameterTypes) {
        Constructor<?> constructor = null;
        try {
            constructor = containingClass.getDeclaredConstructor(parameterTypes);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return constructor;
    }

    public static Field locateFieldByTypeOnClass(Class<?> classType, Class<?> containingClass) {
        Field[] declaredFields;
        for (Field field : declaredFields = containingClass.getDeclaredFields()) {
            Class<?> fieldClass = field.getType();
            if (fieldClass != classType) continue;
            return field;
        }
        Class<?> parentClass = containingClass.getSuperclass();
        if (parentClass == null) {
            return null;
        }
        return ReflectionUtilities.locateFieldByTypeOnClass(classType, parentClass);
    }

    public static String getClassNameOlderThan(Class<?> ... classes) {
        Throwable t = ReflectionUtilities.createThrowableWithStackOlderThan(classes);
        StackTraceElement[] stackTrace = t.getStackTrace();
        return stackTrace[0].getClassName();
    }

    public static Throwable createThrowableWithStackOlderThan(Class<?> ... classes) {
        List toFind = Arrays.stream(classes).map(c -> c.getName()).collect(Collectors.toList());
        if (toFind.isEmpty()) {
            toFind.add(0, ReflectionUtilities.class.getName());
        }
        Throwable t = new Throwable();
        StackTraceElement[] trace = t.getStackTrace();
        int lastIgnoreIndex = -1;
        for (int i = 0; i < trace.length; ++i) {
            StackTraceElement element = trace[i];
            String className = element.getClassName();
            int nameIndex = toFind.indexOf(className);
            if (nameIndex != -1) {
                lastIgnoreIndex = i;
                continue;
            }
            if (lastIgnoreIndex != -1) break;
        }
        if (lastIgnoreIndex == -1) {
            throw new AssertException("Did not find the following classes in the call stack: " + Arrays.toString(classes));
        }
        if (lastIgnoreIndex == trace.length - 1) {
            throw new AssertException("Call stack only contains the classes to ignore: " + Arrays.toString(classes));
        }
        int startIndex = lastIgnoreIndex + 1;
        StackTraceElement[] updatedTrace = Arrays.copyOfRange(trace, startIndex, trace.length);
        t.setStackTrace(updatedTrace);
        return t;
    }

    public static StackTraceElement[] movePastStackTracePattern(StackTraceElement[] trace, String pattern) {
        boolean foundIt = false;
        int desiredStartIndex = 0;
        for (int i = 0; i < trace.length; ++i) {
            StackTraceElement element = trace[i];
            String traceString = element.toString();
            boolean matches = ReflectionUtilities.containsAny(traceString, pattern);
            if (foundIt && !matches) {
                desiredStartIndex = i;
                break;
            }
            foundIt |= matches;
        }
        if (!foundIt) {
            return trace;
        }
        StackTraceElement[] updatedTrace = Arrays.copyOfRange(trace, desiredStartIndex, trace.length);
        return updatedTrace;
    }

    public static StackTraceElement[] filterStackTrace(StackTraceElement[] trace, String ... patterns) {
        ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>();
        for (StackTraceElement element : trace) {
            String traceString = element.toString();
            if (ReflectionUtilities.containsAny(traceString, patterns)) continue;
            list.add(element);
        }
        return list.toArray(new StackTraceElement[list.size()]);
    }

    public static Throwable createFilteredThrowable(String ... patterns) {
        Throwable t = ReflectionUtilities.createThrowableWithStackOlderThan(new Class[0]);
        StackTraceElement[] trace = t.getStackTrace();
        StackTraceElement[] filtered = ReflectionUtilities.filterStackTrace(trace, patterns);
        t.setStackTrace(filtered);
        return t;
    }

    public static Throwable createJavaFilteredThrowable() {
        Throwable t = ReflectionUtilities.createThrowableWithStackOlderThan(new Class[0]);
        return ReflectionUtilities.filterJavaThrowable(t);
    }

    public static String createJavaFilteredThrowableString() {
        Throwable t = ReflectionUtilities.createThrowableWithStackOlderThan(new Class[0]);
        Throwable filtered = ReflectionUtilities.filterJavaThrowable(t);
        return ReflectionUtilities.stackTraceToString(filtered);
    }

    public static Throwable filterJavaThrowable(Throwable t) {
        StackTraceElement[] trace = t.getStackTrace();
        StackTraceElement[] filtered = ReflectionUtilities.filterStackTrace(trace, JAVA_AWT_PATTERN, JAVA_REFLECT_PATTERN, JDK_INTERNAL_REFLECT_PATTERN, SWING_JAVA_PATTERN, SWING_JAVAX_PATTERN, SECURITY_PATTERN, SUN_AWT_PATTERN, SUN_REFLECT_PATTERN, MOCKIT_PATTERN, JUNIT_PATTERN);
        t.setStackTrace(filtered);
        return t;
    }

    private static boolean containsAny(String s, String ... patterns) {
        for (String p : patterns) {
            if (!s.contains(p)) continue;
            return true;
        }
        return false;
    }

    public static String createStackTraceForAllThreads() {
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        Set<Map.Entry<Thread, StackTraceElement[]>> entrySet = allStackTraces.entrySet();
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Thread, StackTraceElement[]> entry : entrySet) {
            StackTraceElement[] value;
            builder.append("Thread: " + entry.getKey().getName()).append('\n');
            for (StackTraceElement stackTraceElement : value = entry.getValue()) {
                builder.append('\t').append("at ").append(stackTraceElement).append('\n');
            }
        }
        return builder.toString();
    }

    public static LinkedHashSet<Class<?>> getSharedHierarchy(List<?> list) {
        Object seed = list.get(0);
        LinkedHashSet master = new LinkedHashSet();
        Class<?> start = seed.getClass();
        boolean shareType = list.stream().allMatch(t -> t.getClass().equals(start));
        if (shareType) {
            master.add(start);
        }
        LinkedHashSet<Class<Class<?>>> parents = ReflectionUtilities.getAllParents(seed.getClass());
        Iterator<?> iterator = list.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            LinkedHashSet<Class<?>> next = ReflectionUtilities.getAllParents(o.getClass());
            parents.retainAll(next);
        }
        master.addAll(parents);
        if (master.isEmpty()) {
            master.add(Object.class);
        }
        return master;
    }

    public static LinkedHashSet<Class<?>> getSharedParents(List<?> list) {
        Object seed = list.get(0);
        LinkedHashSet<Class<Class<?>>> master = ReflectionUtilities.getAllParents(seed.getClass());
        Iterator<?> iterator = list.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            LinkedHashSet<Class<?>> next = ReflectionUtilities.getAllParents(o.getClass());
            master.retainAll(next);
        }
        if (master.isEmpty()) {
            master.add(Object.class);
        }
        return master;
    }

    public static String stackTraceToString(Throwable t) {
        StringBuffer sb = new StringBuffer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        String msg = t.getMessage();
        if (msg != null) {
            ps.println(msg);
        }
        t.printStackTrace(ps);
        sb.append(baos.toString());
        ps.close();
        try {
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static LinkedHashSet<Class<?>> getAllParents(Class<?> c) {
        LinkedHashSet l = new LinkedHashSet();
        if (Object.class.equals(c)) {
            l.add(Object.class);
            return l;
        }
        ReflectionUtilities.doGetAllParents(c, l);
        return l;
    }

    private static void doGetAllParents(Class<?> c, LinkedHashSet<Class<?>> accumulator) {
        Class<?>[] interfaces = c.getInterfaces();
        accumulator.addAll(Arrays.asList(interfaces));
        for (Class<?> clazz : interfaces) {
            ReflectionUtilities.doGetAllParents(clazz, accumulator);
        }
        Class<?> superclass = c.getSuperclass();
        if (superclass != null) {
            accumulator.add(superclass);
            ReflectionUtilities.doGetAllParents(superclass, accumulator);
        }
    }

    public static <T> List<Class<?>> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        HashMap<Type, Type> resolvedTypesDictionary = new HashMap<Type, Type>();
        Type baseClassAsType = ReflectionUtilities.walkClassHierarchyAndResolveTypes(baseClass, resolvedTypesDictionary, childClass);
        Type[] baseClassDeclaredTypeArguments = ReflectionUtilities.getDeclaredTypeArguments(baseClassAsType);
        return ReflectionUtilities.resolveBaseClassTypeArguments(resolvedTypesDictionary, baseClassDeclaredTypeArguments);
    }

    private static <T> Type walkClassHierarchyAndResolveTypes(Class<T> baseClass, Map<Type, Type> resolvedTypes, Type type) {
        while (!ReflectionUtilities.getClass(type).equals(baseClass)) {
            if (type instanceof Class) {
                type = ((Class)type).getGenericSuperclass();
            } else {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class rawType = (Class)parameterizedType.getRawType();
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
                for (int i = 0; i < actualTypeArguments.length; ++i) {
                    resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
                }
                if (!rawType.equals(baseClass)) {
                    type = rawType.getGenericSuperclass();
                }
            }
            if (type != null) continue;
            return type;
        }
        return type;
    }

    private static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionUtilities.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Type componentType = arrayType.getGenericComponentType();
            Class<?> componentClass = ReflectionUtilities.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    private static List<Class<?>> resolveBaseClassTypeArguments(Map<Type, Type> resolvedTypes, Type[] genericTypeArguments) {
        ArrayList typeArgumentsAsClasses = new ArrayList();
        for (Type baseType : genericTypeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(ReflectionUtilities.getClass(baseType));
        }
        return typeArgumentsAsClasses;
    }

    private static Type[] getDeclaredTypeArguments(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getTypeParameters();
        }
        return ((ParameterizedType)type).getActualTypeArguments();
    }
}

