/*
 * Decompiled with CFR 0.152.
 */
package ghidra;

import generic.jar.ResourceFile;
import ghidra.GhidraApplicationLayout;
import ghidra.GhidraClassLoader;
import ghidra.GhidraLaunchable;
import ghidra.framework.GModule;
import ghidra.util.SystemUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import utility.module.ModuleUtilities;

public class GhidraLauncher {
    public static void main(String[] args) throws Exception {
        if (!(ClassLoader.getSystemClassLoader() instanceof GhidraClassLoader)) {
            throw new ClassNotFoundException("ERROR: Ghidra class loader not in use.  Confirm JVM argument \"-Djava.system.class.loader argument=" + GhidraClassLoader.class.getName() + "\" is set.");
        }
        GhidraApplicationLayout layout = new GhidraApplicationLayout();
        List<String> classpathList = new ArrayList<String>();
        if (SystemUtilities.isInDevelopmentMode()) {
            GhidraLauncher.addModuleBinPaths(classpathList, layout.getModules());
            GhidraLauncher.addExternalJarPaths(classpathList, layout.getApplicationRootDirs());
        } else {
            GhidraLauncher.addPatchPaths(classpathList, layout.getApplicationInstallationDir());
            GhidraLauncher.addModuleJarPaths(classpathList, layout.getModules());
        }
        classpathList = GhidraLauncher.orderClasspath(classpathList, layout.getModules());
        GhidraClassLoader loader = (GhidraClassLoader)ClassLoader.getSystemClassLoader();
        classpathList.forEach(entry -> loader.addPath((String)entry));
        Class<?> cls = ClassLoader.getSystemClassLoader().loadClass(args[0]);
        if (!GhidraLaunchable.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("ERROR: \"" + args[0] + "\" is not a launchable class");
        }
        GhidraLaunchable launchable = (GhidraLaunchable)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        launchable.launch(layout, Arrays.copyOfRange(args, 1, args.length));
    }

    private static void addPatchPaths(List<String> pathList, ResourceFile installDir) {
        ResourceFile patchDir = new ResourceFile(installDir, "Ghidra/patch");
        if (patchDir.exists()) {
            pathList.addAll(GhidraLauncher.findJarsInDir(patchDir));
        }
    }

    private static void addModuleBinPaths(List<String> pathList, Map<String, GModule> modules) {
        ModuleUtilities.getModuleBinDirectories(modules).forEach(d -> pathList.add(d.getAbsolutePath()));
    }

    private static void addModuleJarPaths(List<String> pathList, Map<String, GModule> modules) {
        ModuleUtilities.getModuleLibDirectories(modules).forEach(d -> pathList.addAll(GhidraLauncher.findJarsInDir(d)));
    }

    private static void addExternalJarPaths(List<String> pathList, Collection<ResourceFile> appRootDirs) throws IOException {
        String LIBDEPS = "build/libraryDependencies.txt";
        ResourceFile libraryDependenciesFile = null;
        for (ResourceFile root : appRootDirs) {
            ResourceFile f;
            if (libraryDependenciesFile != null || !(f = new ResourceFile(root.getParentFile(), "build/libraryDependencies.txt")).isFile()) continue;
            libraryDependenciesFile = f;
        }
        if (libraryDependenciesFile == null) {
            throw new FileNotFoundException("build/libraryDependencies.txt file was not found!  Please do a prepDev.");
        }
        HashSet<String> pathSet = new HashSet<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(libraryDependenciesFile.getFile(false)));){
            String line;
            while ((line = reader.readLine()) != null) {
                String path = line.trim();
                if (path.startsWith("Module:") || !path.endsWith(".jar")) continue;
                ResourceFile jarFile = new ResourceFile(path);
                if (!jarFile.isFile()) {
                    System.err.println("Failed to find required jar file: " + jarFile);
                    continue;
                }
                pathSet.add(jarFile.getAbsolutePath());
            }
        }
        if (pathSet.isEmpty()) {
            throw new IllegalStateException("Files listed in 'build/libraryDependencies.txt' are incorrect--rebuild this file");
        }
        pathList.addAll(pathSet);
    }

    public static List<String> findJarsInDir(ResourceFile dir) {
        ArrayList<String> list = new ArrayList<String>();
        ResourceFile[] names = dir.listFiles();
        if (names != null) {
            for (ResourceFile file : names) {
                if (!file.getName().endsWith(".jar")) continue;
                list.add(file.getAbsolutePath());
            }
        }
        return list;
    }

    private static List<String> orderClasspath(List<String> pathList, Map<String, GModule> modules) {
        Set flatJars = modules.values().stream().flatMap(m -> m.getFatJars().stream()).collect(Collectors.toSet());
        ArrayList<String> orderedList = new ArrayList<String>(pathList);
        for (String path : pathList) {
            if (!flatJars.contains(new File(path).getName())) continue;
            orderedList.remove(path);
            orderedList.add(path);
        }
        return orderedList;
    }
}

