/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.SatelliteVisualizationViewer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.event.mouse.VisualGraphPluggableGraphMouse;
import ghidra.graph.viewer.event.mouse.VisualGraphSatelliteGraphMouse;
import ghidra.graph.viewer.renderer.VisualGraphRenderer;
import ghidra.graph.viewer.renderer.VisualVertexSatelliteRenderer;
import java.awt.Dimension;

public class SatelliteGraphViewer<V extends VisualVertex, E extends VisualEdge<V>>
extends SatelliteVisualizationViewer<V, E> {
    protected GraphViewer<V, E> graphViewer;
    private boolean docked;

    public SatelliteGraphViewer(GraphViewer<V, E> master, Dimension preferredSize) {
        super(master, preferredSize);
        this.graphViewer = master;
        this.setRenderer((Renderer)new VisualGraphRenderer(null));
        this.setGraphMouse(new VisualGraphSatelliteGraphMouse());
    }

    public void setDocked(boolean docked) {
        this.docked = docked;
    }

    public boolean isDocked() {
        return this.docked;
    }

    public Renderer.Vertex<V, E> getPreferredVertexRenderer() {
        return new VisualVertexSatelliteRenderer();
    }

    public VisualGraphPluggableGraphMouse<V, E> getGraphMouse() {
        return (VisualGraphPluggableGraphMouse)super.getGraphMouse();
    }

    public void setGraphMouse(VisualizationViewer.GraphMouse graphMouse) {
        if (!(graphMouse instanceof VisualGraphPluggableGraphMouse)) {
            return;
        }
        super.setGraphMouse(graphMouse);
    }
}

