/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pdb.PdbInfoDotNetIface;
import ghidra.app.util.datatype.microsoft.GUID;
import ghidra.app.util.datatype.microsoft.GuidDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class PdbInfoDotNet
implements PdbInfoDotNetIface {
    public static final int MAGIC = 1381188691;
    private byte[] magic;
    private GUID guid;
    private int age;
    private String pdbName;

    public static boolean isMatch(BinaryReader reader, int ptr) throws IOException {
        int value = reader.readByte((long)ptr) << 24 | reader.readByte((long)(ptr + 1)) << 16 | reader.readByte((long)(ptr + 2)) << 8 | reader.readByte((long)(ptr + 3));
        return 1381188691 == value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PdbInfoDotNet(BinaryReader reader, int ptr) throws IOException {
        long origIndex = reader.getPointerIndex();
        reader.setPointerIndex(ptr);
        try {
            this.magic = reader.readNextByteArray(4);
            this.guid = new GUID(reader);
            this.age = reader.readNextInt();
            this.pdbName = reader.readNextAsciiString();
        }
        finally {
            reader.setPointerIndex(origIndex);
        }
    }

    public String getPdbName() {
        return this.pdbName;
    }

    public int getAge() {
        return this.age;
    }

    public int getSignature() {
        return this.guid.getData1();
    }

    public GUID getGUID() {
        return this.guid;
    }

    public byte[] getMagic() {
        return this.magic;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("DotNetPdbInfo", 0);
        struct.add((DataType)new StringDataType(), this.magic.length, "signature", null);
        struct.add((DataType)new GuidDataType(), "guid", null);
        struct.add((DataType)new DWordDataType(), "age", null);
        if (this.pdbName.length() > 0) {
            struct.add((DataType)new StringDataType(), this.pdbName.length(), "pdbname", null);
        }
        struct.setCategoryPath(new CategoryPath("/PDB"));
        return struct;
    }
}

