/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.MenuData;
import docking.widgets.tree.GTreeNode;
import ghidra.framework.main.datatable.ProjectDataTreeContextAction;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.main.datatree.ProjectDataTreeActionContext;
import javax.swing.tree.TreePath;

public class ProjectDataCollapseAction
extends ProjectDataTreeContextAction {
    public ProjectDataCollapseAction(String owner, String group) {
        super("Collapse All", owner);
        this.setPopupMenuData(new MenuData(new String[]{"Collapse All"}, group));
        this.markHelpUnnecessary();
    }

    @Override
    protected void actionPerformed(ProjectDataTreeActionContext context) {
        DataTree tree = context.getTree();
        TreePath[] paths = context.getSelectionPaths();
        this.collapse(tree, paths[0]);
    }

    @Override
    public boolean isAddToPopup(ProjectDataTreeActionContext context) {
        return context.getFolderCount() == 1 && context.getFileCount() == 0;
    }

    @Override
    protected boolean isEnabledForContext(ProjectDataTreeActionContext context) {
        return context.getFolderCount() == 1 && context.getFileCount() == 0;
    }

    private void collapse(DataTree tree, TreePath path) {
        tree.collapseAll((GTreeNode)path.getLastPathComponent());
    }
}

