/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.GenericDateCellRenderer;
import docking.widgets.OptionDialog;
import docking.widgets.table.ColumnSortState;
import docking.widgets.table.GTable;
import docking.widgets.table.TableSortStateEditor;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.datatree.CheckoutsTableModel;
import ghidra.framework.main.projectdata.actions.CheckoutsActionContext;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainFolderListenerAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.remote.User;
import ghidra.framework.store.ItemCheckoutStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class CheckoutsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Component parent;
    private PluginTool tool;
    private DomainFile domainFile;
    private CheckoutsTableModel tableModel;
    private GTable table;
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy MMM dd hh:mm aaa");
    private MyFolderListener listener;
    private User user;

    public CheckoutsPanel(Component parent, PluginTool tool, User user, DomainFile domainFile, ItemCheckoutStatus[] checkouts) {
        super(new BorderLayout());
        this.parent = parent;
        this.tool = tool;
        this.user = user;
        this.domainFile = domainFile;
        this.create(checkouts);
        this.listener = new MyFolderListener();
        tool.getProject().getProjectData().addDomainFolderChangeListener(this.listener);
    }

    public void dispose() {
        this.tool.getProject().getProjectData().removeDomainFolderChangeListener(this.listener);
        this.domainFile = null;
    }

    private void refresh() {
        try {
            this.tableModel.refresh(this.domainFile.getCheckouts());
        }
        catch (IOException e) {
            this.tableModel.refresh(new ItemCheckoutStatus[0]);
            ClientUtil.handleException((RepositoryAdapter)this.tool.getProject().getRepository(), (Exception)e, (String)"Get Check Out Status", (Component)this.parent);
        }
    }

    private void create(ItemCheckoutStatus[] checkouts) {
        this.tableModel = new CheckoutsTableModel(checkouts);
        TableSortStateEditor tsse = new TableSortStateEditor();
        tsse.addSortedColumn(0, ColumnSortState.SortDirection.DESCENDING);
        this.tableModel.setTableSortState(tsse.createTableSortState());
        this.table = new GTable((TableModel)((Object)this.tableModel));
        JScrollPane sp = new JScrollPane((Component)this.table);
        this.table.setPreferredScrollableViewportSize(new Dimension(680, 120));
        this.table.setSelectionMode(0);
        this.add((Component)sp, "Center");
        TableColumnModel columnModel = this.table.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        column.setPreferredWidth(120);
        column.setCellRenderer((TableCellRenderer)new GenericDateCellRenderer((DateFormat)this.dateFormatter, "Date when file was checked out"));
        columnModel.getColumn(1).setPreferredWidth(50);
        columnModel.getColumn(2).setPreferredWidth(80);
        columnModel.getColumn(3).setPreferredWidth(120);
        columnModel.getColumn(4).setPreferredWidth(120);
        columnModel.getColumn(5).setPreferredWidth(180);
    }

    private void terminateCheckout(int[] rows) {
        HashSet<ItemCheckoutStatus> toTerminate = new HashSet<ItemCheckoutStatus>();
        for (int i = 0; i < rows.length; ++i) {
            ItemCheckoutStatus item = (ItemCheckoutStatus)this.tableModel.getRowObject(rows[i]);
            toTerminate.add(item);
        }
        for (ItemCheckoutStatus item : toTerminate) {
            int result = OptionDialog.showYesNoDialog((Component)this, (String)"Confirm Terminate Checkout", (String)("Are you sure want to terminate the checkout for " + item.getUser() + ", version " + item.getCheckoutVersion() + "?"));
            if (result == 0) {
                return;
            }
            if (result != 1) continue;
            try {
                this.domainFile.terminateCheckout(item.getCheckoutId());
            }
            catch (IOException e) {
                ClientUtil.handleException((RepositoryAdapter)this.tool.getProject().getRepository(), (Exception)e, (String)"Terminate Checkout", (Component)this);
                this.tableModel.refresh(new ItemCheckoutStatus[0]);
            }
        }
    }

    public void createActions(DialogComponentProvider provider) {
        DockingAction terminateCheckoutAction = new DockingAction("Terminate Checkout", "Checkouts Panel", false){

            public void actionPerformed(ActionContext context) {
                CheckoutsActionContext checkoutsContext = (CheckoutsActionContext)context;
                int[] rows = checkoutsContext.getSelectedRows();
                CheckoutsPanel.this.terminateCheckout(rows);
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (CheckoutsPanel.this.user != null && !CheckoutsPanel.this.user.isAdmin()) {
                    return false;
                }
                if (!(context instanceof CheckoutsActionContext)) {
                    return false;
                }
                CheckoutsActionContext checkoutsContext = (CheckoutsActionContext)context;
                int[] rows = checkoutsContext.getSelectedRows();
                return rows.length > 0;
            }
        };
        terminateCheckoutAction.setDescription("Terminates the selected Checkout");
        terminateCheckoutAction.setPopupMenuData(new MenuData(new String[]{"Terminate Checkout"}, "AAA"));
        provider.addAction((DockingActionIf)terminateCheckoutAction);
    }

    public int[] getSelectedRows() {
        return this.table.getSelectedRows();
    }

    private class MyFolderListener
    extends DomainFolderListenerAdapter {
        private MyFolderListener() {
        }

        @Override
        public void domainFileStatusChanged(DomainFile file, boolean fileIDset) {
            if (file.equals(CheckoutsPanel.this.domainFile)) {
                CheckoutsPanel.this.refresh();
            }
        }

        @Override
        public void domainFileRemoved(DomainFolder parentFolder, String name, String fileID) {
            if (parentFolder.equals(CheckoutsPanel.this.domainFile.getParent()) && CheckoutsPanel.this.domainFile.getName().equals(name)) {
                CheckoutsPanel.this.parent.setVisible(false);
                CheckoutsPanel.this.dispose();
            }
        }
    }
}

