/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.coff;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderInputStream;
import ghidra.app.util.bin.format.coff.CoffException;
import ghidra.app.util.bin.format.coff.archive.CoffArchiveHeader;
import ghidra.app.util.bin.format.coff.archive.CoffArchiveMemberHeader;
import ghidra.file.formats.coff.CoffArchiveFileSystemFactory;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemIndexHelper;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@FileSystemInfo(type="coff", description="COFF Archive", factory=CoffArchiveFileSystemFactory.class)
public class CoffArchiveFileSystem
implements GFileSystem {
    private final FSRLRoot fsFSRL;
    private FileSystemIndexHelper<CoffArchiveMemberHeader> fsih;
    private FileSystemRefManager refManager = new FileSystemRefManager((GFileSystem)this);
    private ByteProvider provider;

    public CoffArchiveFileSystem(FSRLRoot fsFSRL, ByteProvider provider) {
        this.fsFSRL = fsFSRL;
        this.provider = provider;
        this.fsih = new FileSystemIndexHelper((GFileSystem)this, fsFSRL);
    }

    public void mount(TaskMonitor monitor) throws IOException {
        try {
            monitor.setMessage("Opening COFF archive...");
            CoffArchiveHeader caf = CoffArchiveHeader.read((ByteProvider)this.provider, (TaskMonitor)monitor);
            for (CoffArchiveMemberHeader camh : caf.getArchiveMemberHeaders()) {
                if (!camh.isCOFF()) continue;
                String name = camh.getName().replace('\\', '/');
                monitor.setMessage(name);
                this.fsih.storeFile(name, this.fsih.getFileCount(), false, camh.getSize(), (Object)camh);
            }
        }
        catch (CoffException e) {
            throw new IOException(e);
        }
    }

    public String getName() {
        return this.fsFSRL.getContainer().getName();
    }

    public FSRLRoot getFSRL() {
        return this.fsFSRL;
    }

    public InputStream getInputStream(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        CoffArchiveMemberHeader entry = (CoffArchiveMemberHeader)this.fsih.getMetadata(file);
        return entry != null && entry.isCOFF() ? new ByteProviderInputStream(this.provider, entry.getPayloadOffset(), entry.getSize()) : null;
    }

    public void close() throws IOException {
        this.refManager.onClose();
        if (this.provider != null) {
            this.provider.close();
            this.provider = null;
        }
        this.fsih.clear();
    }

    public boolean isClosed() {
        return this.provider == null;
    }

    public int getFileCount() {
        return this.fsih.getFileCount();
    }

    public String getInfo(GFile file, TaskMonitor monitor) {
        CoffArchiveMemberHeader entry = (CoffArchiveMemberHeader)this.fsih.getMetadata(file);
        return entry == null ? null : FSUtilities.infoMapToString(this.getInfoMap(entry));
    }

    public Map<String, String> getInfoMap(CoffArchiveMemberHeader blob) {
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        info.put("Name", blob.getName());
        info.put("Size", Long.toString(blob.getSize()) + ", 0x" + Long.toHexString(blob.getSize()));
        info.put("UserID", blob.getUserId());
        info.put("GroupID", blob.getGroupId());
        info.put("Mode", blob.getMode());
        info.put("Time", new Date(blob.getDate()).toString());
        return info;
    }

    public GFile lookup(String path) throws IOException {
        return this.fsih.lookup(path);
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return this.fsih.getListing(directory);
    }

    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }
}

