/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.xml;

import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SpecXmlUtils {
    public static boolean decodeBoolean(String val) {
        if (val != null && val.length() != 0) {
            switch (val.charAt(0)) {
                case '1': 
                case 't': 
                case 'y': {
                    return true;
                }
                case '0': 
                case 'f': 
                case 'n': {
                    return false;
                }
            }
        }
        return false;
    }

    public static String encodeBoolean(boolean val) {
        return val ? "true" : "false";
    }

    public static void encodeBooleanAttribute(StringBuilder buf, String nm, boolean val) {
        buf.append(' ');
        buf.append(nm);
        buf.append("=\"");
        buf.append(val ? "true" : "false");
        buf.append('\"');
    }

    public static void encodeStringAttribute(StringBuilder buf, String nm, String val) {
        buf.append(' ');
        buf.append(nm);
        buf.append("=\"");
        buf.append(val);
        buf.append('\"');
    }

    public static String encodeSignedInteger(long val) {
        return Long.toString(val, 10);
    }

    public static String encodeUnsignedInteger(long val) {
        return "0x" + Long.toHexString(val);
    }

    public static void encodeSignedIntegerAttribute(StringBuilder buf, String nm, long val) {
        buf.append(' ');
        buf.append(nm);
        buf.append("=\"");
        buf.append(SpecXmlUtils.encodeSignedInteger(val));
        buf.append('\"');
    }

    public static void encodeUnsignedIntegerAttribute(StringBuilder buf, String nm, long val) {
        buf.append(' ');
        buf.append(nm);
        buf.append("=\"");
        buf.append(SpecXmlUtils.encodeUnsignedInteger(val));
        buf.append('\"');
    }

    public static void encodeDoubleAttribute(StringBuilder buf, String nm, double val) {
        buf.append(' ');
        buf.append(nm);
        buf.append("=\"");
        buf.append(Double.toString(val));
        buf.append('\"');
    }

    public static int decodeInt(String intString) {
        if (intString == null) {
            return 0;
        }
        if ("0".equals(intString)) {
            return 0;
        }
        BigInteger bi = null;
        bi = intString.startsWith("0x") ? new BigInteger(intString.substring(2), 16) : (intString.startsWith("0") ? new BigInteger(intString.substring(1), 8) : new BigInteger(intString, 10));
        return bi.intValue();
    }

    public static long decodeLong(String longString) {
        if (longString == null) {
            return 0L;
        }
        if ("0".equals(longString)) {
            return 0L;
        }
        BigInteger bi = null;
        bi = longString.startsWith("0x") ? new BigInteger(longString.substring(2), 16) : (longString.startsWith("0") ? new BigInteger(longString.substring(1), 8) : new BigInteger(longString, 10));
        return bi.longValue();
    }

    public static void xmlEscape(StringBuilder buf, String val) {
        for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            if (c <= '>') {
                switch (c) {
                    case '&': {
                        buf.append("&amp;");
                        break;
                    }
                    case '<': {
                        buf.append("&lt;");
                        break;
                    }
                    case '>': {
                        buf.append("&gt;");
                        break;
                    }
                    case '\"': {
                        buf.append("&quot;");
                        break;
                    }
                    case '\'': {
                        buf.append("&apos;");
                        break;
                    }
                    default: {
                        buf.append(c);
                        break;
                    }
                }
                continue;
            }
            buf.append(c);
        }
    }

    public static void xmlEscapeAttribute(StringBuilder buf, String nm, String val) {
        buf.append(' ');
        buf.append(nm);
        buf.append("=\"");
        SpecXmlUtils.xmlEscape(buf, val);
        buf.append('\"');
    }

    public static void xmlEscapeWriter(Writer writer, String val) throws IOException {
        for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            if (c == '&') {
                writer.append("&amp;");
                continue;
            }
            if (c == '<') {
                writer.append("&lt;");
                continue;
            }
            if (c == '>') {
                writer.append("&gt;");
                continue;
            }
            if (c == '\"') {
                writer.append("&quot;");
                continue;
            }
            if (c == '\'') {
                writer.append("&apos;");
                continue;
            }
            writer.append(c);
        }
    }

    public static ErrorHandler getXmlHandler() {
        return new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXException {
                throw new SAXException("Error: " + exception);
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                throw new SAXException("Fatal error: " + exception);
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                throw new SAXException("Warning: " + exception);
            }
        };
    }
}

