/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.graph.attributes;

import ghidra.util.datastruct.LongObjectHashtable;
import ghidra.util.graph.KeyIndexableSet;
import ghidra.util.graph.KeyedObject;
import ghidra.util.graph.attributes.Attribute;

public class ObjectAttribute<T extends KeyedObject>
extends Attribute<T> {
    private LongObjectHashtable<Object> values = new LongObjectHashtable();
    private static String attributeType = "OBJECT_TYPE";
    private static final String emptyString = "";

    public ObjectAttribute(String name, KeyIndexableSet<T> set) {
        super(name, set);
    }

    public boolean setValue(T o, Object value) {
        if (value == null) {
            return false;
        }
        if (this.owningSet().contains(o)) {
            this.values.put(o.key(), value);
            this.update();
            return true;
        }
        return false;
    }

    public Object getValue(KeyedObject o) {
        return this.values.get(o.key());
    }

    @Override
    public String attributeType() {
        return attributeType;
    }

    @Override
    public void clear() {
        this.values.removeAll();
    }

    @Override
    public String getValueAsString(KeyedObject o) {
        Object v;
        if (this.values.contains(o.key()) && (v = this.getValue(o)) != null) {
            return v.toString();
        }
        return emptyString;
    }
}

