/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.xml.XmlUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;
import utilities.util.FileUtilities;

public class SaveState {
    private HashMap<String, Object> map;
    private String saveStateName;

    public SaveState(String name) {
        this.saveStateName = name;
        this.map = new HashMap();
    }

    public SaveState() {
        this("SAVE_STATE");
    }

    public SaveState(File file) throws IOException {
        this(SaveState.getXmlElementFromFile(file));
    }

    public SaveState(Element root) {
        this.map = new HashMap();
        this.saveStateName = root.getName();
        for (Element elem : root.getChildren()) {
            String tag = elem.getName();
            String name = elem.getAttributeValue("NAME");
            String type = elem.getAttributeValue("TYPE");
            String value = elem.getAttributeValue("VALUE");
            if (tag.equals("XML")) {
                this.map.put(name, elem.getChildren().get(0));
                continue;
            }
            if (tag.equals("BYTES")) {
                if (value == null) continue;
                this.map.put(name, NumericUtilities.convertStringToBytes(value));
                continue;
            }
            if (tag.equals("STATE")) {
                try {
                    if (type == null) continue;
                    if (type.equals("byte")) {
                        this.map.put(name, Byte.valueOf(value));
                        continue;
                    }
                    if (type.equals("short")) {
                        this.map.put(name, Short.valueOf(value));
                        continue;
                    }
                    if (type.equals("int")) {
                        this.map.put(name, Integer.valueOf(value));
                        continue;
                    }
                    if (type.equals("long")) {
                        this.map.put(name, Long.valueOf(value));
                        continue;
                    }
                    if (type.equals("float")) {
                        this.map.put(name, Float.valueOf(value));
                        continue;
                    }
                    if (type.equals("double")) {
                        this.map.put(name, Double.valueOf(value));
                        continue;
                    }
                    if (type.equals("boolean")) {
                        this.map.put(name, Boolean.valueOf(value));
                        continue;
                    }
                    if (!type.equals("string")) continue;
                    String encodedValue = elem.getAttributeValue("ENCODED_VALUE");
                    if (value == null && encodedValue != null) {
                        byte[] strBytes = NumericUtilities.convertStringToBytes(encodedValue);
                        value = new String(strBytes, StandardCharsets.UTF_8);
                    }
                    this.map.put(name, value);
                }
                catch (Exception e) {
                    Msg.warn((Object)this, (Object)"Error processing primitive value in saveState", (Throwable)e);
                }
                continue;
            }
            if (tag.equals("ARRAY")) {
                if (type == null) continue;
                try {
                    Element e;
                    Object[] vals;
                    List list = elem.getChildren("A");
                    Iterator it = list.iterator();
                    int i = 0;
                    if (type.equals("short")) {
                        vals = new short[list.size()];
                        while (it.hasNext()) {
                            e = (Element)it.next();
                            vals[i++] = Short.parseShort(e.getAttributeValue("VALUE"));
                        }
                        this.map.put(name, vals);
                        continue;
                    }
                    if (type.equals("int")) {
                        vals = new int[list.size()];
                        while (it.hasNext()) {
                            e = (Element)it.next();
                            vals[i++] = Integer.parseInt(e.getAttributeValue("VALUE"));
                        }
                        this.map.put(name, vals);
                        continue;
                    }
                    if (type.equals("long")) {
                        vals = new long[list.size()];
                        while (it.hasNext()) {
                            e = (Element)it.next();
                            vals[i++] = (short)Long.parseLong(e.getAttributeValue("VALUE"));
                        }
                        this.map.put(name, vals);
                        continue;
                    }
                    if (type.equals("float")) {
                        vals = new float[list.size()];
                        while (it.hasNext()) {
                            e = (Element)it.next();
                            vals[i++] = (short)Float.parseFloat(e.getAttributeValue("VALUE"));
                        }
                        this.map.put(name, vals);
                        continue;
                    }
                    if (type.equals("double")) {
                        vals = new double[list.size()];
                        while (it.hasNext()) {
                            e = (Element)it.next();
                            vals[i++] = (short)Double.parseDouble(e.getAttributeValue("VALUE"));
                        }
                        this.map.put(name, vals);
                        continue;
                    }
                    if (type.equals("boolean")) {
                        vals = new boolean[list.size()];
                        while (it.hasNext()) {
                            e = (Element)it.next();
                            vals[i++] = (short)(Boolean.valueOf(e.getAttributeValue("VALUE")).booleanValue() ? 1 : 0);
                        }
                        this.map.put(name, vals);
                        continue;
                    }
                    if (!type.equals("string")) continue;
                    vals = new String[list.size()];
                    while (it.hasNext()) {
                        e = (Element)it.next();
                        vals[i++] = (short)e.getAttributeValue("VALUE");
                    }
                    this.map.put(name, vals);
                }
                catch (Exception exc) {
                    Msg.warn((Object)this, (Object)"Error processing array value in saveState", (Throwable)exc);
                }
                continue;
            }
            if (tag.equals("ENUM")) {
                if (type == null || type.equals("stringenum") || !type.equals("enum")) continue;
                String className = elem.getAttributeValue("CLASS");
                try {
                    Enum e;
                    Class<Enum> enumClass = Class.forName(className).asSubclass(Enum.class);
                    Method m = enumClass.getMethod("valueOf", String.class);
                    if (m == null || (e = (Enum)m.invoke(null, value)) == null) continue;
                    this.map.put(name, e);
                }
                catch (Exception e) {
                    Msg.warn((Object)this, (Object)("Error processing enum class " + className), (Throwable)e);
                }
                continue;
            }
            if (!tag.equals("NULL")) continue;
            this.map.put(name, null);
        }
    }

    public Element saveToXml() {
        return this.saveToXml(null);
    }

    private static Element getXmlElementFromFile(File file) throws IOException {
        byte[] bytes = FileUtilities.getBytesFromFile((File)file);
        return XmlUtilities.byteArrayToXml(bytes);
    }

    public void saveToFile(File file) throws FileNotFoundException, IOException {
        Element saveToXml = this.saveToXml(null);
        byte[] bytes = XmlUtilities.xmlToByteArray(saveToXml);
        FileUtilities.writeBytes((File)file, (byte[])bytes);
    }

    public Element saveToXml(Set<String> restrictedSet) {
        Element root = new Element(this.saveStateName);
        for (String key : this.map.keySet()) {
            Element arrElem;
            Element arrElem2;
            Object[] arr;
            if (restrictedSet != null && !restrictedSet.contains(key)) continue;
            Object value = this.map.get(key);
            Element elem = null;
            if (value instanceof Element) {
                elem = this.createElementFromElement(key, (Element)value);
            } else if (value instanceof Byte) {
                elem = new Element("STATE");
                elem.setAttribute("NAME", key);
                elem.setAttribute("TYPE", "byte");
                elem.setAttribute("VALUE", ((Byte)value).toString());
            } else if (value instanceof Short) {
                elem = new Element("STATE");
                elem.setAttribute("NAME", key);
                elem.setAttribute("TYPE", "short");
                elem.setAttribute("VALUE", ((Short)value).toString());
            } else if (value instanceof Integer) {
                elem = new Element("STATE");
                elem.setAttribute("NAME", key);
                elem.setAttribute("TYPE", "int");
                elem.setAttribute("VALUE", ((Integer)value).toString());
            } else if (value instanceof Long) {
                elem = new Element("STATE");
                elem.setAttribute("NAME", key);
                elem.setAttribute("TYPE", "long");
                elem.setAttribute("VALUE", ((Long)value).toString());
            } else if (value instanceof Float) {
                elem = new Element("STATE");
                elem.setAttribute("NAME", key);
                elem.setAttribute("TYPE", "float");
                elem.setAttribute("VALUE", ((Float)value).toString());
            } else if (value instanceof Double) {
                elem = new Element("STATE");
                elem.setAttribute("NAME", key);
                elem.setAttribute("TYPE", "double");
                elem.setAttribute("VALUE", ((Double)value).toString());
            } else if (value instanceof Boolean) {
                elem = new Element("STATE");
                elem.setAttribute("NAME", key);
                elem.setAttribute("TYPE", "boolean");
                elem.setAttribute("VALUE", ((Boolean)value).toString());
            } else if (value instanceof String) {
                elem = new Element("STATE");
                elem.setAttribute("NAME", key);
                elem.setAttribute("TYPE", "string");
                if (XmlUtilities.hasInvalidXMLCharacters((String)value)) {
                    elem.setAttribute("ENCODED_VALUE", NumericUtilities.convertBytesToString(((String)value).getBytes(StandardCharsets.UTF_8)));
                } else {
                    elem.setAttribute("VALUE", (String)value);
                }
            } else if (value instanceof byte[]) {
                elem = new Element("BYTES");
                elem.setAttribute("NAME", key);
                elem.setAttribute("VALUE", NumericUtilities.convertBytesToString((byte[])value));
            } else if (value instanceof short[]) {
                elem = new Element("ARRAY");
                elem.setAttribute("NAME", key);
                elem.setAttribute("TYPE", "short");
                for (short s : arr = (short[])value) {
                    Element arrElem22 = new Element("A");
                    arrElem22.setAttribute("VALUE", "" + s);
                    elem.addContent((Content)arrElem22);
                }
            } else if (value instanceof int[]) {
                elem = new Element("ARRAY");
                elem.setAttribute("NAME", key);
                elem.setAttribute("TYPE", "int");
                for (short s : arr = (Object[])((int[])value)) {
                    arrElem2 = new Element("A");
                    arrElem2.setAttribute("VALUE", "" + s);
                    elem.addContent((Content)arrElem2);
                }
            } else if (value instanceof long[]) {
                elem = new Element("ARRAY");
                elem.setAttribute("NAME", key);
                elem.setAttribute("TYPE", "long");
                for (short s : arr = (Object[])((long[])value)) {
                    arrElem = new Element("A");
                    arrElem.setAttribute("VALUE", "" + s);
                    elem.addContent((Content)arrElem);
                }
            } else if (value instanceof float[]) {
                elem = new Element("ARRAY");
                elem.setAttribute("NAME", key);
                elem.setAttribute("TYPE", "float");
                for (short s : arr = (Object[])((float[])value)) {
                    arrElem2 = new Element("A");
                    arrElem2.setAttribute("VALUE", "" + s);
                    elem.addContent((Content)arrElem2);
                }
            } else if (value instanceof double[]) {
                elem = new Element("ARRAY");
                elem.setAttribute("NAME", key);
                elem.setAttribute("TYPE", "double");
                for (short s : arr = (Object[])((double[])value)) {
                    arrElem = new Element("A");
                    arrElem.setAttribute("VALUE", "" + s);
                    elem.addContent((Content)arrElem);
                }
            } else if (value instanceof boolean[]) {
                elem = new Element("ARRAY");
                elem.setAttribute("NAME", key);
                elem.setAttribute("TYPE", "boolean");
                for (boolean bl : arr = (Object[])((boolean[])value)) {
                    arrElem2 = new Element("A");
                    arrElem2.setAttribute("VALUE", "" + bl);
                    elem.addContent((Content)arrElem2);
                }
            } else if (value instanceof String[]) {
                elem = new Element("ARRAY");
                elem.setAttribute("NAME", key);
                elem.setAttribute("TYPE", "string");
                for (short s : arr = (Object[])((String[])value)) {
                    arrElem2 = new Element("A");
                    if (s != null) {
                        arrElem2.setAttribute("VALUE", (String)s);
                    }
                    elem.addContent((Content)arrElem2);
                }
            } else if (value instanceof Enum) {
                Enum e = (Enum)value;
                elem = new Element("ENUM");
                elem.setAttribute("NAME", key);
                elem.setAttribute("TYPE", "enum");
                elem.setAttribute("CLASS", e.getClass().getName());
                elem.setAttribute("VALUE", e.name());
            } else {
                elem = new Element("NULL");
                elem.setAttribute("NAME", key);
            }
            root.addContent((Content)elem);
        }
        return root;
    }

    protected Element createElementFromElement(String internalKey, Element internalElement) {
        Element newElement = new Element("XML");
        newElement.setAttribute("NAME", internalKey);
        Element internalElementClone = (Element)internalElement.clone();
        newElement.addContent((Content)internalElementClone);
        return newElement;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void remove(String name) {
        this.map.remove(name);
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    public String[] getNames() {
        String[] names = new String[this.map.size()];
        int idx = 0;
        Iterator<String> iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            names[idx] = iter.next();
            ++idx;
        }
        return names;
    }

    void putObject(String name, Object obj) {
        this.map.put(name, obj);
    }

    Object getObject(String name) {
        return this.map.get(name);
    }

    public void putInt(String name, int value) {
        this.map.put(name, new Integer(value));
    }

    public void putByte(String name, byte value) {
        this.map.put(name, new Byte(value));
    }

    public void putShort(String name, short value) {
        this.map.put(name, new Short(value));
    }

    public void putLong(String name, long value) {
        this.map.put(name, new Long(value));
    }

    public void putString(String name, String value) {
        this.map.put(name, value);
    }

    public void putBoolean(String name, boolean value) {
        this.map.put(name, new Boolean(value));
    }

    public void putFloat(String name, float value) {
        this.map.put(name, new Float(value));
    }

    public void putDouble(String name, double value) {
        this.map.put(name, new Double(value));
    }

    public int getInt(String name, int defaultValue) {
        try {
            Integer val = (Integer)this.map.get(name);
            if (val != null) {
                return val;
            }
        }
        catch (Exception e) {
            Msg.debug((Object)this, (Object)("Two different types for option name: " + name));
        }
        return defaultValue;
    }

    public byte getByte(String name, byte defaultValue) {
        try {
            Byte val = (Byte)this.map.get(name);
            if (val != null) {
                return val;
            }
        }
        catch (Exception e) {
            Msg.debug((Object)this, (Object)("Two different types for option name: " + name));
        }
        return defaultValue;
    }

    public short getShort(String name, short defaultValue) {
        try {
            Short val = (Short)this.map.get(name);
            if (val != null) {
                return val;
            }
        }
        catch (Exception e) {
            Msg.debug((Object)this, (Object)("Two different types for option name: " + name));
        }
        return defaultValue;
    }

    public long getLong(String name, long defaultValue) {
        try {
            Long val = (Long)this.map.get(name);
            if (val != null) {
                return val;
            }
        }
        catch (Exception e) {
            Msg.debug((Object)this, (Object)("Two different types for option name: " + name));
        }
        return defaultValue;
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        try {
            Boolean val = (Boolean)this.map.get(name);
            if (val != null) {
                return val;
            }
        }
        catch (Exception e) {
            Msg.debug((Object)this, (Object)("Two different types for option name: " + name));
        }
        return defaultValue;
    }

    public String getString(String name, String defaultValue) {
        try {
            return this.map.containsKey(name) ? (String)this.map.get(name) : defaultValue;
        }
        catch (Exception e) {
            Msg.debug((Object)this, (Object)("Two different types for option name: " + name));
            return defaultValue;
        }
    }

    public float getFloat(String name, float defaultValue) {
        try {
            Float val = (Float)this.map.get(name);
            if (val != null) {
                return val.floatValue();
            }
        }
        catch (Exception e) {
            Msg.debug((Object)this, (Object)("Two different types for option name: " + name));
        }
        return defaultValue;
    }

    public double getDouble(String name, double defaultValue) {
        try {
            Double val = (Double)this.map.get(name);
            if (val != null) {
                return val;
            }
        }
        catch (Exception e) {
            Msg.debug((Object)this, (Object)("Two different types for option name: " + name));
        }
        return defaultValue;
    }

    public void putInts(String name, int[] value) {
        this.map.put(name, value);
    }

    public void putBytes(String name, byte[] value) {
        this.map.put(name, value);
    }

    public void putShorts(String name, short[] value) {
        this.map.put(name, value);
    }

    public void putLongs(String name, long[] value) {
        this.map.put(name, value);
    }

    public void putStrings(String name, String[] value) {
        this.map.put(name, value);
    }

    public void putEnum(String name, Enum<?> value) {
        if ((value.getClass().getModifiers() & 1) == 0) {
            throw new IllegalArgumentException("enum '" + value.name() + "' must be public");
        }
        this.map.put(name, value);
    }

    public void putBooleans(String name, boolean[] value) {
        this.map.put(name, value);
    }

    public void putFloats(String name, float[] value) {
        this.map.put(name, value);
    }

    public void putDoubles(String name, double[] value) {
        this.map.put(name, value);
    }

    public int[] getInts(String name, int[] defaultValue) {
        return this.map.containsKey(name) ? (int[])this.map.get(name) : defaultValue;
    }

    public byte[] getBytes(String name, byte[] defaultValue) {
        return this.map.containsKey(name) ? (byte[])this.map.get(name) : defaultValue;
    }

    public short[] getShorts(String name, short[] defaultValue) {
        return this.map.containsKey(name) ? (short[])this.map.get(name) : defaultValue;
    }

    public long[] getLongs(String name, long[] defaultValue) {
        return this.map.containsKey(name) ? (long[])this.map.get(name) : defaultValue;
    }

    public boolean[] getBooleans(String name, boolean[] defaultValue) {
        return this.map.containsKey(name) ? (boolean[])this.map.get(name) : defaultValue;
    }

    public String[] getStrings(String name, String[] defaultValue) {
        return this.map.containsKey(name) ? (String[])this.map.get(name) : defaultValue;
    }

    public <T extends Enum<T>> T getEnum(String name, T defaultValue) {
        if (defaultValue != null && (defaultValue.getClass().getModifiers() & 1) == 0) {
            throw new IllegalArgumentException("enum '" + defaultValue.name() + "' must be public");
        }
        try {
            if (this.map.containsKey(name)) {
                return (T)((Enum)this.map.get(name));
            }
        }
        catch (ClassCastException e) {
            this.map.put(name, defaultValue);
        }
        return defaultValue;
    }

    public float[] getFloats(String name, float[] defaultValue) {
        return this.map.containsKey(name) ? (float[])this.map.get(name) : defaultValue;
    }

    public double[] getDoubles(String name, double[] defaultValue) {
        return this.map.containsKey(name) ? (double[])this.map.get(name) : defaultValue;
    }

    public boolean hasValue(String name) {
        return this.map.containsKey(name);
    }

    public void putXmlElement(String name, Element element) {
        this.map.put(name, element);
    }

    public Element getXmlElement(String name) {
        try {
            return (Element)this.map.get(name);
        }
        catch (Exception exc) {
            Msg.debug((Object)this, (Object)("Two different types for option name: " + name));
            return null;
        }
    }
}

