/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class SpeedUnitUtils {
    protected static final long kibibyte = SpeedUnitUtils.mypow(2L, 10L);
    protected static final long mebibyte = SpeedUnitUtils.mypow(2L, 20L);
    protected static final long gibibyte = SpeedUnitUtils.mypow(2L, 30L);
    protected static final long tebibyte = SpeedUnitUtils.mypow(2L, 40L);
    protected static final long pebibyte = SpeedUnitUtils.mypow(2L, 50L);
    protected static final long exbibyte = SpeedUnitUtils.mypow(2L, 60L);
    protected static final long kilo = SpeedUnitUtils.mypow(10L, 3L);
    protected static final long mega = SpeedUnitUtils.mypow(10L, 6L);
    protected static final long giga = SpeedUnitUtils.mypow(10L, 9L);
    protected static final long tera = SpeedUnitUtils.mypow(10L, 12L);
    protected static final long peta = SpeedUnitUtils.mypow(10L, 15L);
    protected static final long exa = SpeedUnitUtils.mypow(10L, 18L);
    protected static DecimalFormat standardUnitFormatter = new DecimalFormat("0");

    protected static String format(double d, DecimalFormat unitFormatter) {
        double rounded = SpeedUnitUtils.roundDoubleToDecimals(d, unitFormatter.getMaximumFractionDigits());
        return unitFormatter.format(rounded);
    }

    public static double roundDoubleToDecimals(double d, int decimals) {
        long integerPart = (long)d;
        double remaining = d - (double)integerPart;
        if (decimals > 0) {
            BigDecimal bd = new BigDecimal(remaining, new MathContext(decimals, RoundingMode.DOWN));
            return (double)integerPart + bd.doubleValue();
        }
        return integerPart;
    }

    public static String bytesToBinaryUnit(long size) {
        return SpeedUnitUtils.bytesToBinaryUnit(size, standardUnitFormatter);
    }

    public static String bytesToBinaryUnit(long size, DecimalFormat unitFormatter) {
        String result = size >= exbibyte ? SpeedUnitUtils.format((double)size / (double)exbibyte, unitFormatter) + " EiB" : (size >= pebibyte ? SpeedUnitUtils.format((double)size / (double)pebibyte, unitFormatter) + " PiB" : (size >= tebibyte ? SpeedUnitUtils.format((double)size / (double)tebibyte, unitFormatter) + " TiB" : (size >= gibibyte ? SpeedUnitUtils.format((double)size / (double)gibibyte, unitFormatter) + " GiB" : (size >= mebibyte ? SpeedUnitUtils.format((double)size / (double)mebibyte, unitFormatter) + " MiB" : (size >= kibibyte ? SpeedUnitUtils.format((double)size / (double)kibibyte, unitFormatter) + " KiB" : size + " B")))));
        return result;
    }

    public static String bytesToDecimalBitUnit(long bytes) {
        return SpeedUnitUtils.bytesToDecimalBitUnit(bytes, standardUnitFormatter);
    }

    public static String bytesToDecimalBitUnit(long bytes, DecimalFormat unitFormatter) {
        long bits = bytes * 8L;
        String result = bits >= exa ? SpeedUnitUtils.format((double)bits / (double)exa, unitFormatter) + " Ebit" : (bits >= peta ? SpeedUnitUtils.format((double)bits / (double)peta, unitFormatter) + " Pbit" : (bits >= tera ? SpeedUnitUtils.format((double)bits / (double)tera, unitFormatter) + " Tbit" : (bits >= giga ? SpeedUnitUtils.format((double)bits / (double)giga, unitFormatter) + " Gbit" : (bits >= mega ? SpeedUnitUtils.format((double)bits / (double)mega, unitFormatter) + " Mbit" : (bits >= kilo ? SpeedUnitUtils.format((double)bits / (double)kilo, unitFormatter) + " Kbit" : bits + " bit")))));
        return result;
    }

    protected static long mypow(long a, long n) throws IllegalArgumentException {
        if (n < 0L) {
            throw new IllegalArgumentException("b can not be negative");
        }
        long result = 1L;
        for (long i = 0L; i < n; ++i) {
            result *= a;
        }
        return result;
    }
}

