/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcodeInject;

import ghidra.app.util.pcodeInject.PcodeTextEmitter;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;

public class LdcMethods {
    static final String VALUE = "value";

    private LdcMethods() {
        throw new AssertionError();
    }

    public static String getPcodeForLdc(int constantPoolIndex, AbstractConstantPoolInfoJava[] constantPool) {
        byte tag = constantPool[constantPoolIndex].getTag();
        StringBuilder pCode = new StringBuilder();
        switch (tag) {
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 15: 
            case 16: {
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, VALUE, 4, "cpool", "0", Integer.toString(constantPoolIndex), "4");
                PcodeTextEmitter.emitPushCat1Value(pCode, VALUE);
                break;
            }
            case 5: 
            case 6: {
                PcodeTextEmitter.emitAssignVarnodeFromPcodeOpCall(pCode, VALUE, 8, "cpool", "0", Integer.toString(constantPoolIndex), "5");
                PcodeTextEmitter.emitPushCat2Value(pCode, VALUE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid load from constant pool: tag " + tag);
            }
        }
        return pCode.toString();
    }
}

