/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.util.Set;

public class ForwardSliceAction
extends AbstractDecompilerAction {
    private final DecompilerController controller;

    public ForwardSliceAction(DecompilerController controller) {
        super("Highlight Forward Slice");
        this.controller = controller;
        this.setPopupMenuData(new MenuData(new String[]{"Highlight Forward Slice"}, "Decompile"));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        Varnode varnode = DecompilerUtils.getVarnodeRef(tokenAtCursor);
        return varnode != null;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        Varnode varnode = DecompilerUtils.getVarnodeRef(tokenAtCursor);
        if (varnode != null) {
            PcodeOp op = tokenAtCursor.getPcodeOp();
            Set<Varnode> forwardSlice = DecompilerUtils.getForwardSlice(varnode);
            decompilerPanel.clearHighlights();
            decompilerPanel.addVarnodeHighlights(forwardSlice, decompilerPanel.getDefaultHighlightColor(), varnode, op, decompilerPanel.getDefaultSpecialColor());
            decompilerPanel.repaint();
        }
    }
}

