/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.util.TextSearchDictionaryEntry;
import java.util.Vector;

public class SearchDictionary {
    private final Vector<TextSearchDictionaryEntry> v = new Vector();
    private final Vector<TextSearchDictionaryEntry> e = new Vector();

    public SearchDictionary(DictionaryType dt) {
        if (dt.equals((Object)DictionaryType.VALID_TEXT_MEDIA_TYPES)) {
            this.buildValidTypesDictionary();
        }
        if (dt.equals((Object)DictionaryType.CSS_VALUES)) {
            this.buildCssSearchDictionary();
        }
        if (dt.equals((Object)DictionaryType.CSS_FILES)) {
            this.buildCSSTypesDictionary();
        }
        if (dt.equals((Object)DictionaryType.LINK_VALUES)) {
            this.buildLinkSearchDictionary();
        }
        if (dt.equals((Object)DictionaryType.SVG_MEDIA_TYPES)) {
            this.buildSVGSearchDictionary();
        }
    }

    void buildCSSTypesDictionary() {
        String description = "text/css";
        String value = "text/css";
        TextSearchDictionaryEntry de = new TextSearchDictionaryEntry(description, value, MessageId.CSS_009);
        this.v.add(de);
    }

    void buildCssSearchDictionary() {
        String description = "rotateX()";
        String value = "rotateX()";
        TextSearchDictionaryEntry de = new TextSearchDictionaryEntry(description, value, MessageId.CSS_009);
        this.v.add(de);
        description = "rotateY()";
        value = "rotateY()";
        de = new TextSearchDictionaryEntry(description, value, MessageId.CSS_009);
        this.v.add(de);
        description = "column-count";
        value = "column-count";
        de = new TextSearchDictionaryEntry(description, value, MessageId.CSS_009);
        this.v.add(de);
        description = "column-gap";
        value = "column-gap";
        de = new TextSearchDictionaryEntry(description, value, MessageId.CSS_009);
        this.v.add(de);
        description = "column-rule";
        value = "column-rule";
        de = new TextSearchDictionaryEntry(description, value, MessageId.CSS_009);
        this.v.add(de);
        description = "keyframes";
        value = "keyframes";
        de = new TextSearchDictionaryEntry(description, value, MessageId.CSS_009);
        this.v.add(de);
        description = "transition";
        value = "transition";
        de = new TextSearchDictionaryEntry(description, value, MessageId.CSS_009);
        this.v.add(de);
    }

    void buildValidTypesDictionary() {
        String description = "application/xhtml+xml";
        String value = "application/xhtml+xml";
        TextSearchDictionaryEntry de = new TextSearchDictionaryEntry(description, value, null);
        this.v.add(de);
    }

    void buildLinkSearchDictionary() {
        String description = "Http:";
        String value = "[Hh][Tt][Tt][Pp]*\\:";
        TextSearchDictionaryEntry de = new TextSearchDictionaryEntry(description, value, MessageId.HTM_005);
        this.v.add(de);
        description = "Ftp:";
        value = "[Ff][Tt][Pp]*\\:";
        de = new TextSearchDictionaryEntry(description, value, MessageId.HTM_005);
        this.v.add(de);
        description = "File:";
        value = "[Ff][Ii][Ll][Ee]*\\:";
        de = new TextSearchDictionaryEntry(description, value, MessageId.HTM_005);
        this.v.add(de);
    }

    public Vector<TextSearchDictionaryEntry> getDictEntries() {
        return this.v;
    }

    public Vector<TextSearchDictionaryEntry> getExceptionEntries() {
        return this.e;
    }

    void buildSVGSearchDictionary() {
        String description = "image/svg+xml";
        String value = "image/svg+xml";
        TextSearchDictionaryEntry de = new TextSearchDictionaryEntry(description, value, null);
        this.v.add(de);
    }

    public boolean isValidMediaType(String typeToCheck) {
        if (typeToCheck == null) {
            return false;
        }
        for (int i = 0; i < this.getDictEntries().size(); ++i) {
            if (this.getDictEntries().get(i).getRegexExp().compareToIgnoreCase(typeToCheck) != 0) continue;
            return true;
        }
        return false;
    }

    public static enum DictionaryType {
        VALID_TEXT_MEDIA_TYPES,
        CSS_FILES,
        CSS_VALUES,
        LINK_VALUES,
        SVG_MEDIA_TYPES;

    }
}

