/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.panelsearch.items;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.zaproxy.zap.view.panelsearch.HighlightedComponent;
import org.zaproxy.zap.view.panelsearch.HighlighterUtils;
import org.zaproxy.zap.view.panelsearch.SearchQuery;
import org.zaproxy.zap.view.panelsearch.items.AbstractComponentSearch;
import org.zaproxy.zap.view.panelsearch.items.TableCellElement;

public class TableCellElementSearch
extends AbstractComponentSearch<TableCellElement> {
    @Override
    protected boolean isSearchMatchingInternal(TableCellElement component, SearchQuery query) {
        Object value = component.getValue();
        return value != null && query.match(value.toString());
    }

    @Override
    protected HighlightedComponent highlightInternal(TableCellElement component) {
        HighlightTableCellRenderer cellRenderer = this.wrapTableCellRenderer(component);
        cellRenderer.addHighlighted(component);
        return new HighlightedComponent(component);
    }

    @Override
    protected void undoHighlightInternal(HighlightedComponent highlightedComponent, TableCellElement component) {
        this.revertWrappedTableCellRenderer(component);
    }

    private HighlightTableCellRenderer wrapTableCellRenderer(TableCellElement component) {
        if (!(this.getColumnRenderer(component) instanceof HighlightTableCellRenderer)) {
            TableCellRenderer currentColumnRenderer = this.getColumnRenderer(component);
            HighlightTableCellRenderer highlightTableCellRenderer = new HighlightTableCellRenderer(currentColumnRenderer);
            int cIndex = component.getTable().getColumn(component.getColumnIdentifier()).getModelIndex();
            for (int rIndex = 0; rIndex < component.getTable().getRowCount(); ++rIndex) {
                TableCellRenderer currentCellRenderer = component.getTable().getCellRenderer(rIndex, cIndex);
                highlightTableCellRenderer.addCellRenderer(rIndex, currentCellRenderer);
            }
            this.setColumnRenderer(component, highlightTableCellRenderer);
        }
        return (HighlightTableCellRenderer)this.getColumnRenderer(component);
    }

    private void revertWrappedTableCellRenderer(TableCellElement component) {
        if (this.getColumnRenderer(component) instanceof HighlightTableCellRenderer) {
            HighlightTableCellRenderer highlightRenderer = (HighlightTableCellRenderer)this.getColumnRenderer(component);
            this.setColumnRenderer(component, highlightRenderer.getOriginalColumnRenderer());
        }
    }

    private TableCellRenderer getColumnRenderer(TableCellElement component) {
        return component.getTable().getColumn(component.getColumnIdentifier()).getCellRenderer();
    }

    private void setColumnRenderer(TableCellElement component, TableCellRenderer renderer) {
        component.getTable().getColumn(component.getColumnIdentifier()).setCellRenderer(renderer);
    }

    public static class HighlightTableCellRenderer
    implements TableCellRenderer {
        private TableCellRenderer fallBackRenderer;
        private TableCellRenderer originalColumnRenderer;
        private HashMap<Integer, TableCellRenderer> originalCellRenderers = new HashMap();
        private Color selectColor;
        private ArrayList<TableCellElement> highlighted = new ArrayList();

        public HighlightTableCellRenderer(TableCellRenderer originalColumnRenderer) {
            this.originalColumnRenderer = originalColumnRenderer;
            this.fallBackRenderer = new DefaultTableCellRenderer();
            this.selectColor = UIManager.getColor("Table.selectionBackground");
            if (this.selectColor == null) {
                this.selectColor = new Color(57, 105, 138);
            }
        }

        public void addCellRenderer(int row, TableCellRenderer originalCellRenderer) {
            this.originalCellRenderers.put(row, originalCellRenderer);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component item = this.getRender(row).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Object columnIdentifier = table.getColumnModel().getColumn(column).getIdentifier();
            if (this.highlighted.stream().anyMatch(e -> e.getColumnIdentifier().equals(columnIdentifier) && e.getValue().equals(value))) {
                this.trySetOpaque(item, true);
                item.setBackground(HighlighterUtils.DEFAULT_HIGHLIGHT_COLOR);
            } else if (isSelected) {
                this.trySetOpaque(item, true);
                item.setBackground(this.selectColor);
            } else {
                this.resetRenderer(item);
            }
            return item;
        }

        private void resetRenderer(Component cell) {
            this.trySetOpaque(cell, false);
            cell.setBackground(null);
        }

        private void trySetOpaque(Component item, boolean isOpaque) {
            if (item instanceof DefaultTableCellRenderer) {
                ((DefaultTableCellRenderer)item).setOpaque(isOpaque);
            }
        }

        public TableCellRenderer getOriginalColumnRenderer() {
            if (this.originalColumnRenderer instanceof Component) {
                Component originalColumnRendererAsComponent = (Component)((Object)this.originalColumnRenderer);
                this.resetRenderer(originalColumnRendererAsComponent);
            }
            return this.originalColumnRenderer;
        }

        public void addHighlighted(TableCellElement element) {
            this.highlighted.add(element);
        }

        public TableCellRenderer getRender(int row) {
            TableCellRenderer usedCellRenderer = null;
            TableCellRenderer originalCellRenderer = this.originalCellRenderers.get(row);
            if (originalCellRenderer != null) {
                usedCellRenderer = originalCellRenderer;
            } else if (this.originalColumnRenderer != null) {
                usedCellRenderer = this.originalColumnRenderer;
            }
            if (usedCellRenderer == null) {
                return this.fallBackRenderer;
            }
            String className = usedCellRenderer.getClass().getName();
            if (className.equals("javax.swing.plaf.synth.SynthTableUI$SynthTableCellRenderer")) {
                return this.fallBackRenderer;
            }
            return usedCellRenderer;
        }
    }
}

