/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.panelsearch.items;

import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import org.zaproxy.zap.view.panelsearch.ComponentWithBackground;
import org.zaproxy.zap.view.panelsearch.HighlightedComponent;
import org.zaproxy.zap.view.panelsearch.HighlighterUtils;
import org.zaproxy.zap.view.panelsearch.JComponentWithBackground;
import org.zaproxy.zap.view.panelsearch.SearchQuery;
import org.zaproxy.zap.view.panelsearch.items.AbstractComponentSearch;

public class SpinnerSearch
extends AbstractComponentSearch<JSpinner> {
    private static final String HIGHLIGHTED_EDITOR = "highlightedEditorComponent";

    @Override
    protected boolean isSearchMatchingInternal(JSpinner component, SearchQuery query) {
        return query.match(component.getValue().toString());
    }

    @Override
    protected HighlightedComponent highlightInternal(JSpinner component) {
        HighlightedComponent highlightedUpAndDownComponent = HighlighterUtils.highlightBackground(new JComponentWithBackground(component), HighlighterUtils.DEFAULT_HIGHLIGHT_COLOR);
        HighlightedComponent highlightedEditorComponent = HighlighterUtils.highlightBackground(new SpinnerSearchComponentWithBackground(component), HighlighterUtils.DEFAULT_HIGHLIGHT_COLOR);
        highlightedUpAndDownComponent.put(HIGHLIGHTED_EDITOR, highlightedEditorComponent);
        return highlightedUpAndDownComponent;
    }

    @Override
    protected void undoHighlightInternal(HighlightedComponent highlightedComponent, JSpinner component) {
        HighlightedComponent highlightedUpAndDownComponent = highlightedComponent;
        HighlightedComponent highlightedEditorComponent = (HighlightedComponent)highlightedUpAndDownComponent.get(HIGHLIGHTED_EDITOR);
        HighlighterUtils.undoHighlightBackground(new JComponentWithBackground(component), highlightedUpAndDownComponent);
        HighlighterUtils.undoHighlightBackground(new SpinnerSearchComponentWithBackground(component), highlightedEditorComponent);
    }

    private static class SpinnerSearchComponentWithBackground
    extends ComponentWithBackground {
        private JSpinner component;

        public SpinnerSearchComponentWithBackground(JSpinner component) {
            this.component = component;
        }

        @Override
        public Object getComponent() {
            return this.component;
        }

        @Override
        public void setBackground(Color color) {
            this.getEditor().setBackground(color);
        }

        private JComponent getEditor() {
            return this.component.getEditor();
        }

        @Override
        public Color getBackground() {
            return this.getEditor().getBackground();
        }

        @Override
        public void setOpaque(boolean isOpaque) {
            this.getEditor().setOpaque(isOpaque);
        }

        @Override
        public boolean isOpaque() {
            return this.getEditor().isOpaque();
        }
    }
}

