/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.util;

import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;

public final class HttpTextViewUtils {
    public static final int[] INVALID_POSITION = new int[0];
    private static final Logger LOGGER = Logger.getLogger(HttpTextViewUtils.class);

    private HttpTextViewUtils() {
    }

    public static int[] getHeaderToViewPosition(JTextArea view, String header, int start, int end) {
        int finalEndPos;
        HttpTextViewUtils.validateView(view);
        HttpTextViewUtils.validateHeader(header);
        HttpTextViewUtils.validateStartEnd(start, end);
        if (!HttpTextViewUtils.isValidStartEndForLength(start, end, header.length())) {
            return INVALID_POSITION;
        }
        int excessChars = 0;
        int pos = 0;
        while ((pos = header.indexOf("\r\n", pos)) != -1 && pos < start) {
            pos += 2;
            ++excessChars;
        }
        int finalStartPos = start - excessChars;
        int len = view.getDocument().getLength();
        if (finalStartPos > len) {
            return INVALID_POSITION;
        }
        if (pos != -1) {
            while ((pos = header.indexOf("\r\n", pos)) != -1 && pos < end) {
                pos += 2;
                ++excessChars;
            }
        }
        if ((finalEndPos = end - excessChars) > len) {
            return INVALID_POSITION;
        }
        return new int[]{finalStartPos, finalEndPos};
    }

    private static void validateView(JTextArea view) {
        if (view == null || view.getDocument() == null) {
            throw new IllegalArgumentException("Parameter view must not be null and must have a Document.");
        }
    }

    private static void validateHeader(String header) {
        if (header == null) {
            throw new IllegalArgumentException("Parameter header must not be null.");
        }
    }

    private static void validateStartEnd(int start, int end) {
        if (start < 0) {
            throw new IllegalArgumentException("Parameter start must not be negative.");
        }
        if (end < 0) {
            throw new IllegalArgumentException("Parameter end must not be negative.");
        }
        if (start > end) {
            throw new IllegalArgumentException("Parameter start must not be greater than end.");
        }
    }

    private static boolean isValidStartEndForLength(int start, int end, int length) {
        return start <= length && end <= length;
    }

    public static int[] getBodyToViewPosition(JTextArea view, String header, int start, int end) {
        HttpTextViewUtils.validateView(view);
        HttpTextViewUtils.validateHeader(header);
        HttpTextViewUtils.validateStartEnd(start, end);
        if (!HttpTextViewUtils.isValidStartEndForLength(start, end, view.getDocument().getLength())) {
            return INVALID_POSITION;
        }
        int excessChars = 0;
        int pos = 0;
        while ((pos = header.indexOf("\r\n", pos)) != -1) {
            pos += 2;
            ++excessChars;
        }
        int len = view.getDocument().getLength();
        int bodyLen = len - header.length() + excessChars;
        if (bodyLen < 0 || start > bodyLen || end > bodyLen) {
            return INVALID_POSITION;
        }
        int finalStartPos = start + header.length() - excessChars;
        int finalEndPos = end + header.length() - excessChars;
        return new int[]{finalStartPos, finalEndPos};
    }

    public static int[] getViewToHeaderPosition(JTextArea view, int start, int end) {
        HttpTextViewUtils.validateView(view);
        HttpTextViewUtils.validateStartEnd(start, end);
        if (!HttpTextViewUtils.isValidStartEndForLength(start, end, view.getDocument().getLength())) {
            return INVALID_POSITION;
        }
        return HttpTextViewUtils.getViewToHeaderPositionImpl(view, start, end);
    }

    private static int[] getViewToHeaderPositionImpl(JTextArea view, int start, int end) {
        int finalStartPos = start;
        try {
            finalStartPos += view.getLineOfOffset(finalStartPos);
        }
        catch (BadLocationException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return INVALID_POSITION;
        }
        int finalEndPos = end;
        try {
            finalEndPos += view.getLineOfOffset(finalEndPos);
        }
        catch (BadLocationException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return INVALID_POSITION;
        }
        return new int[]{finalStartPos, finalEndPos};
    }

    public static int[] getViewToHeaderBodyPosition(JTextArea view, String header, int start, int end) {
        HttpTextViewUtils.validateView(view);
        HttpTextViewUtils.validateHeader(header);
        HttpTextViewUtils.validateStartEnd(start, end);
        if (!HttpTextViewUtils.isValidStartEndForLength(start, end, view.getDocument().getLength())) {
            return INVALID_POSITION;
        }
        int excessChars = 0;
        int pos = 0;
        while ((pos = header.indexOf("\r\n", pos)) != -1) {
            pos += 2;
            ++excessChars;
        }
        if (start + excessChars < header.length()) {
            int[] position = HttpTextViewUtils.getViewToHeaderPositionImpl(view, start, end);
            if (position[1] > header.length()) {
                position[1] = header.length();
            }
            return position;
        }
        int finalStartPos = start + excessChars - header.length();
        int finalEndPos = end + excessChars - header.length();
        return new int[]{finalStartPos, finalEndPos, 0};
    }
}

