/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.impl.models.http.response;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.AbstractHttpStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.HttpPanelViewModelUtils;

public class ResponseStringHttpPanelViewModel
extends AbstractHttpStringHttpPanelViewModel {
    private static final Logger logger = Logger.getLogger(ResponseStringHttpPanelViewModel.class);

    @Override
    public String getData() {
        if (this.httpMessage == null || this.httpMessage.getResponseHeader().isEmpty()) {
            return "";
        }
        return this.httpMessage.getResponseHeader().toString().replaceAll("\r\n", "\n") + this.getBody();
    }

    private String getBody() {
        if ("gzip".equals(this.httpMessage.getResponseHeader().getHeader("Content-Encoding"))) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.httpMessage.getResponseBody().getBytes());
                GZIPInputStream gis = new GZIPInputStream(bais);
                InputStreamReader isr = new InputStreamReader(gis);
                BufferedReader br = new BufferedReader(isr);
                StringBuilder sb = new StringBuilder();
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                br.close();
                isr.close();
                gis.close();
                bais.close();
                return sb.toString();
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
        return this.httpMessage.getResponseBody().toString();
    }

    @Override
    public void setData(String data) {
        String[] parts = data.split("\n\n");
        String header = parts[0].replaceAll("(?<!\r)\n", "\r\n");
        try {
            this.httpMessage.setResponseHeader(header);
        }
        catch (HttpMalformedHeaderException e) {
            logger.warn((Object)("Could not Save Header: " + header), (Throwable)e);
        }
        if (parts.length > 1) {
            String body = data.substring(parts[0].length() + 2);
            if ("gzip".equals(this.httpMessage.getResponseHeader().getHeader("Content-Encoding"))) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    GZIPOutputStream gis = new GZIPOutputStream(baos);
                    BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)gis, "UTF-8"));
                    bw.write(body);
                    bw.close();
                    gis.close();
                    baos.close();
                    this.httpMessage.getResponseBody().setBody(baos.toByteArray());
                    HttpPanelViewModelUtils.updateResponseContentLength(this.httpMessage);
                }
                catch (IOException e) {
                    System.out.println(e);
                }
            } else {
                this.httpMessage.setResponseBody(body);
            }
        } else {
            this.httpMessage.setResponseBody("");
        }
        HttpPanelViewModelUtils.updateResponseContentLength(this.httpMessage);
    }
}

