/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.brk.BreakPanelToolbarFactory;
import org.zaproxy.zap.extension.brk.BreakpointManagementInterface;
import org.zaproxy.zap.extension.brk.BreakpointsParam;
import org.zaproxy.zap.extension.brk.ExtensionBreak;
import org.zaproxy.zap.extension.httppanel.HttpPanel;
import org.zaproxy.zap.extension.httppanel.HttpPanelRequest;
import org.zaproxy.zap.extension.httppanel.HttpPanelResponse;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.tab.Tab;

public class BreakPanel
extends AbstractPanel
implements Tab,
BreakpointManagementInterface {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(BreakPanel.class);
    private static final String REQUEST_PANEL = "request";
    private static final String RESPONSE_PANEL = "response";
    private HttpPanelRequest requestPanel;
    private HttpPanelResponse responsePanel;
    private ExtensionBreak extension;
    private JPanel panelContent;
    private BreakPanelToolbarFactory breakToolbarFactory;
    private BreakpointsParam breakpointsParams;
    private final JToggleButton toolBarReqButton;
    private final JToggleButton toolBarResButton;
    private final JToggleButton toolBarAllButton;
    private final JButton toolBarBtnStep;
    private final JButton toolBarBtnContinue;
    private final JButton toolBarBtnDrop;
    private final JButton toolBarBtnBreakPoint;
    private Message msg;
    private boolean isAlwaysOnTop = false;
    private boolean request;
    private final BreakButtonsUI mainBreakButtons;
    private final BreakButtonsUI requestBreakButtons;
    private final BreakButtonsUI responseBreakButtons;
    private int currentButtonsLocation;
    private int currentButtonMode;

    public BreakPanel(ExtensionBreak extension, BreakpointsParam breakpointsParams) {
        this.extension = extension;
        this.breakpointsParams = breakpointsParams;
        this.setIcon(new ImageIcon(BreakPanel.class.getResource("/resource/icon/16/101grey.png")));
        this.setDefaultAccelerator(extension.getView().getMenuShortcutKeyStroke(66, 64, false));
        this.setMnemonic(Constant.messages.getChar("brk.panel.mnemonic"));
        this.setLayout(new BorderLayout());
        this.breakToolbarFactory = new BreakPanelToolbarFactory(breakpointsParams, this);
        this.panelContent = new JPanel(new CardLayout());
        this.add((Component)this.panelContent, "Center");
        this.requestPanel = new HttpPanelRequest(false, "view.break.");
        this.requestPanel.loadConfig(Model.getSingleton().getOptionsParam().getConfig());
        this.responsePanel = new HttpPanelResponse(false, "view.break.");
        this.responsePanel.loadConfig(Model.getSingleton().getOptionsParam().getConfig());
        this.panelContent.add((Component)this.requestPanel, REQUEST_PANEL);
        this.panelContent.add((Component)this.responsePanel, RESPONSE_PANEL);
        this.toolBarReqButton = this.breakToolbarFactory.getBtnBreakRequest();
        View.getSingleton().addMainToolbarButton(this.toolBarReqButton);
        this.toolBarResButton = this.breakToolbarFactory.getBtnBreakResponse();
        View.getSingleton().addMainToolbarButton(this.toolBarResButton);
        this.toolBarAllButton = this.breakToolbarFactory.getBtnBreakAll();
        View.getSingleton().addMainToolbarButton(this.toolBarAllButton);
        this.toolBarBtnStep = this.breakToolbarFactory.getBtnStep();
        View.getSingleton().addMainToolbarButton(this.toolBarBtnStep);
        this.toolBarBtnContinue = this.breakToolbarFactory.getBtnContinue();
        View.getSingleton().addMainToolbarButton(this.toolBarBtnContinue);
        this.toolBarBtnDrop = this.breakToolbarFactory.getBtnDrop();
        View.getSingleton().addMainToolbarButton(this.toolBarBtnDrop);
        this.toolBarBtnBreakPoint = this.breakToolbarFactory.getBtnBreakPoint();
        View.getSingleton().addMainToolbarButton(this.toolBarBtnBreakPoint);
        this.mainBreakButtons = new BreakButtonsUI("mainBreakButtons", this.breakToolbarFactory);
        this.add((Component)this.mainBreakButtons.getComponent(), "North");
        this.requestBreakButtons = new BreakButtonsUI("requestBreakButtons", this.breakToolbarFactory);
        this.requestPanel.addOptions(this.requestBreakButtons.getComponent(), HttpPanel.OptionsLocation.AFTER_COMPONENTS);
        this.responseBreakButtons = new BreakButtonsUI("responseBreakButtons", this.breakToolbarFactory);
        this.responsePanel.addOptions(this.responseBreakButtons.getComponent(), HttpPanel.OptionsLocation.AFTER_COMPONENTS);
        this.currentButtonsLocation = -1;
    }

    void setButtonsLocation(int location) {
        if (this.currentButtonsLocation == location) {
            this.mainBreakButtons.setVisible(location == 0 && this.isMainToolBarHidden());
            return;
        }
        this.currentButtonsLocation = location;
        switch (location) {
            case 0: {
                this.requestBreakButtons.setVisible(false);
                this.responseBreakButtons.setVisible(false);
                this.setToolbarButtonsVisible(true);
                this.mainBreakButtons.setVisible(this.isMainToolBarHidden());
                break;
            }
            case 1: 
            case 2: {
                this.requestBreakButtons.setVisible(true);
                this.responseBreakButtons.setVisible(true);
                this.setToolbarButtonsVisible(location == 2);
                this.mainBreakButtons.setVisible(false);
                break;
            }
            default: {
                this.setToolbarButtonsVisible(true);
            }
        }
    }

    private boolean isMainToolBarHidden() {
        return !this.extension.getModel().getOptionsParam().getViewParam().isShowMainToolbar();
    }

    @Override
    public boolean isBreakRequest() {
        return this.breakToolbarFactory.isBreakRequest();
    }

    @Override
    public boolean isBreakResponse() {
        return this.breakToolbarFactory.isBreakResponse();
    }

    @Override
    public boolean isBreakAll() {
        return this.breakToolbarFactory.isBreakAll();
    }

    @Override
    public void breakpointHit() {
        this.breakToolbarFactory.breakpointHit();
    }

    @Override
    public boolean isHoldMessage(Message aMessage) {
        return this.breakToolbarFactory.isHoldMessage();
    }

    public boolean isHoldMessage() {
        return this.breakToolbarFactory.isHoldMessage();
    }

    @Override
    public boolean isStepping() {
        return this.breakToolbarFactory.isStepping();
    }

    @Override
    public boolean isToBeDropped() {
        return this.breakToolbarFactory.isToBeDropped();
    }

    @Override
    public void breakpointDisplayed() {
        if (!View.getSingleton().isCanGetFocus()) {
            return;
        }
        final Boolean alwaysOnTopOption = this.breakpointsParams.getAlwaysOnTop();
        if (alwaysOnTopOption == null || alwaysOnTopOption.booleanValue()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    View.getSingleton().getMainFrame().setAlwaysOnTop(true);
                    View.getSingleton().getMainFrame().toFront();
                    BreakPanel.this.setTabFocus();
                    BreakPanel.this.isAlwaysOnTop = true;
                    if (alwaysOnTopOption == null) {
                        boolean keepOn = View.getSingleton().showConfirmDialog(Constant.messages.getString("brk.alwaysOnTop.message")) == 0;
                        BreakPanel.this.breakpointsParams.setAlwaysOnTop(keepOn);
                        if (!keepOn) {
                            View.getSingleton().getMainFrame().setAlwaysOnTop(false);
                            BreakPanel.this.isAlwaysOnTop = false;
                        }
                    }
                }
            });
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    View.getSingleton().getMainFrame().toFront();
                }
            });
        }
        catch (Exception e) {
            LOGGER.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void setToolbarButtonsVisible(boolean visible) {
        boolean simple = this.currentButtonMode == 1;
        this.toolBarReqButton.setVisible(visible && !simple);
        this.toolBarResButton.setVisible(visible && !simple);
        this.toolBarAllButton.setVisible(visible && simple);
        this.toolBarBtnStep.setVisible(visible);
        this.toolBarBtnContinue.setVisible(visible);
        this.toolBarBtnDrop.setVisible(visible);
        this.toolBarBtnBreakPoint.setVisible(visible);
    }

    @Override
    public void setMessage(final Message aMessage, final boolean isRequest) {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BreakPanel.this.msg = aMessage;
                    CardLayout cl = (CardLayout)BreakPanel.this.panelContent.getLayout();
                    BreakPanel.this.request = isRequest;
                    if (isRequest) {
                        BreakPanel.this.requestPanel.setMessage(aMessage, true);
                        BreakPanel.this.requestPanel.setEditable(true);
                        cl.show(BreakPanel.this.panelContent, BreakPanel.REQUEST_PANEL);
                    } else {
                        BreakPanel.this.responsePanel.setMessage(aMessage, true);
                        BreakPanel.this.responsePanel.setEditable(true);
                        cl.show(BreakPanel.this.panelContent, BreakPanel.RESPONSE_PANEL);
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isRequest() {
        return this.request;
    }

    @Override
    public Message getMessage() {
        return this.msg;
    }

    @Override
    public void saveMessage(final boolean isRequest) {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    CardLayout cl = (CardLayout)BreakPanel.this.panelContent.getLayout();
                    if (isRequest) {
                        BreakPanel.this.requestPanel.saveData();
                        cl.show(BreakPanel.this.panelContent, BreakPanel.REQUEST_PANEL);
                    } else {
                        BreakPanel.this.responsePanel.saveData();
                        cl.show(BreakPanel.this.panelContent, BreakPanel.RESPONSE_PANEL);
                    }
                }
            });
        }
        catch (Exception ie) {
            LOGGER.warn((Object)ie.getMessage(), (Throwable)ie);
        }
    }

    public void savePanels() {
        this.requestPanel.saveConfig(Model.getSingleton().getOptionsParam().getConfig());
        this.responsePanel.saveConfig(Model.getSingleton().getOptionsParam().getConfig());
    }

    @Override
    public void clearAndDisableRequest() {
        if (EventQueue.isDispatchThread()) {
            this.clearAndDisableRequestEventHandler();
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        BreakPanel.this.clearAndDisableRequestEventHandler();
                    }
                });
            }
            catch (Exception e) {
                LOGGER.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void clearAndDisableRequestEventHandler() {
        this.msg = null;
        this.requestPanel.clearView(false);
        this.requestPanel.setEditable(false);
        this.breakpointLeft();
    }

    @Override
    public void clearAndDisableResponse() {
        if (EventQueue.isDispatchThread()) {
            this.clearAndDisableResponseEventHandler();
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        BreakPanel.this.clearAndDisableResponseEventHandler();
                    }
                });
            }
            catch (Exception e) {
                LOGGER.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void clearAndDisableResponseEventHandler() {
        this.msg = null;
        this.responsePanel.clearView(false);
        this.responsePanel.setEditable(false);
        this.breakpointLeft();
    }

    private void breakpointLeft() {
        if (this.isAlwaysOnTop) {
            View.getSingleton().getMainFrame().setAlwaysOnTop(false);
            this.isAlwaysOnTop = false;
        }
    }

    @Override
    public void init() {
        this.breakToolbarFactory.init();
    }

    @Override
    public void reset() {
        this.msg = null;
        this.breakToolbarFactory.reset();
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
        if (mode.equals((Object)Control.Mode.safe)) {
            this.breakToolbarFactory.setBreakEnabled(false);
        } else {
            this.breakToolbarFactory.setBreakEnabled(true);
        }
    }

    @Override
    public void setBreakAllRequests(boolean brk) {
        this.breakToolbarFactory.setBreakRequest(brk);
    }

    @Override
    public void setBreakAllResponses(boolean brk) {
        this.breakToolbarFactory.setBreakResponse(brk);
    }

    @Override
    public void setBreakAll(boolean brk) {
        this.breakToolbarFactory.setBreakAll(brk);
    }

    @Override
    public void step() {
        this.breakToolbarFactory.step();
    }

    @Override
    public void cont() {
        this.breakToolbarFactory.setContinue(true);
        this.breakToolbarFactory.setBreakAll(false);
        this.breakToolbarFactory.setBreakRequest(false);
        this.breakToolbarFactory.setBreakResponse(false);
    }

    @Override
    public void drop() {
        this.breakToolbarFactory.drop();
    }

    public void showNewBreakPointDialog() {
        this.extension.addUiBreakpoint(new HttpMessage());
    }

    public void setButtonMode(int mode) {
        if (this.currentButtonMode == mode) {
            return;
        }
        this.currentButtonMode = mode;
        this.breakToolbarFactory.setButtonMode(mode);
        if (this.currentButtonsLocation == 0 || this.currentButtonsLocation == 2) {
            boolean simple = mode == 1;
            this.toolBarReqButton.setVisible(!simple);
            this.toolBarResButton.setVisible(!simple);
            this.toolBarAllButton.setVisible(simple);
        }
        this.mainBreakButtons.setButtonMode(mode);
        this.requestBreakButtons.setButtonMode(mode);
        this.responseBreakButtons.setButtonMode(mode);
    }

    private static class BreakButtonsUI {
        private final JToolBar toolBar;
        private final JToggleButton requestButton;
        private final JToggleButton responseButton;
        private final JToggleButton allButton;

        public BreakButtonsUI(String name, BreakPanelToolbarFactory breakToolbarFactory) {
            this.requestButton = breakToolbarFactory.getBtnBreakRequest();
            this.responseButton = breakToolbarFactory.getBtnBreakResponse();
            this.allButton = breakToolbarFactory.getBtnBreakAll();
            this.toolBar = new JToolBar();
            this.toolBar.setFloatable(false);
            this.toolBar.setBorder(BorderFactory.createEmptyBorder());
            this.toolBar.setRollover(true);
            this.toolBar.setName(name);
            this.toolBar.add(this.requestButton);
            this.toolBar.add(this.responseButton);
            this.toolBar.add(this.allButton);
            this.toolBar.add(breakToolbarFactory.getBtnStep());
            this.toolBar.add(breakToolbarFactory.getBtnContinue());
            this.toolBar.add(breakToolbarFactory.getBtnDrop());
            this.toolBar.add(breakToolbarFactory.getBtnBreakPoint());
        }

        public void setVisible(boolean visible) {
            this.toolBar.setVisible(visible);
        }

        public void setButtonMode(int mode) {
            boolean simple = mode == 1;
            this.requestButton.setVisible(!simple);
            this.responseButton.setVisible(!simple);
            this.allButton.setVisible(simple);
        }

        public JComponent getComponent() {
            return this.toolBar;
        }
    }
}

