/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.InvalidRedirectLocationException;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.AuthPolicy;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpMethodHelper;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.parosproxy.paros.network.HttpStatusCode;
import org.parosproxy.paros.network.SSLConnector;
import org.zaproxy.zap.ZapGetMethod;
import org.zaproxy.zap.ZapHttpConnectionManager;
import org.zaproxy.zap.network.HttpRedirectionValidator;
import org.zaproxy.zap.network.HttpRequestConfig;
import org.zaproxy.zap.network.HttpSenderListener;
import org.zaproxy.zap.network.ZapCookieSpec;
import org.zaproxy.zap.network.ZapNTLMScheme;
import org.zaproxy.zap.users.User;

public class HttpSender {
    public static final int PROXY_INITIATOR = 1;
    public static final int ACTIVE_SCANNER_INITIATOR = 2;
    public static final int SPIDER_INITIATOR = 3;
    public static final int FUZZER_INITIATOR = 4;
    public static final int AUTHENTICATION_INITIATOR = 5;
    public static final int MANUAL_REQUEST_INITIATOR = 6;
    public static final int CHECK_FOR_UPDATES_INITIATOR = 7;
    public static final int BEAN_SHELL_INITIATOR = 8;
    public static final int ACCESS_CONTROL_SCANNER_INITIATOR = 9;
    public static final int AJAX_SPIDER_INITIATOR = 10;
    public static final int FORCED_BROWSE_INITIATOR = 11;
    public static final int TOKEN_GENERATOR_INITIATOR = 12;
    public static final int WEB_SOCKET_INITIATOR = 13;
    public static final int AUTHENTICATION_HELPER_INITIATOR = 14;
    private static Logger log = Logger.getLogger(HttpSender.class);
    private static ProtocolSocketFactory sslFactory = null;
    private static Protocol protocol = null;
    private static List<HttpSenderListener> listeners = new ArrayList<HttpSenderListener>();
    private static Comparator<HttpSenderListener> listenersComparator = null;
    private User user = null;
    private static HttpMethodHelper helper;
    private static String userAgent;
    private static final ThreadLocal<Boolean> IN_LISTENER;
    private HttpClient client = null;
    private HttpClient clientViaProxy = null;
    private ConnectionParam param = null;
    private MultiThreadedHttpConnectionManager httpConnManager = null;
    private MultiThreadedHttpConnectionManager httpConnManagerProxy = null;
    private boolean followRedirect = false;
    private boolean useCookies;
    private boolean useGlobalState;
    private int initiator = -1;

    public HttpSender(ConnectionParam connectionParam, boolean useGlobalState, int initiator) {
        this.param = connectionParam;
        this.initiator = initiator;
        this.client = this.createHttpClient();
        this.clientViaProxy = this.createHttpClientViaProxy();
        this.setAllowCircularRedirects(true);
        boolean singleCookieRequestHeader = this.param.isSingleCookieRequestHeader();
        this.client.getParams().setBooleanParameter("http.protocol.single-cookie-header", singleCookieRequestHeader);
        this.clientViaProxy.getParams().setBooleanParameter("http.protocol.single-cookie-header", singleCookieRequestHeader);
        String defaultUserAgent = this.param.getDefaultUserAgent();
        this.client.getParams().setParameter("method.connect.default.user.agent", (Object)defaultUserAgent);
        this.clientViaProxy.getParams().setParameter("method.connect.default.user.agent", (Object)defaultUserAgent);
        this.setUseGlobalState(useGlobalState);
        this.setUseCookies(true);
    }

    private void setClientsCookiePolicy(String policy) {
        this.client.getParams().setCookiePolicy(policy);
        this.clientViaProxy.getParams().setCookiePolicy(policy);
    }

    public static SSLConnector getSSLConnector() {
        return (SSLConnector)protocol.getSocketFactory();
    }

    private void checkState() {
        if (!this.useCookies) {
            this.resetState();
            this.setClientsCookiePolicy("ignoreCookies");
        } else if (this.useGlobalState) {
            if (this.param.isHttpStateEnabled()) {
                this.client.setState(this.param.getHttpState());
                this.clientViaProxy.setState(this.param.getHttpState());
                this.setProxyAuth(this.clientViaProxy);
                this.setClientsCookiePolicy("compatibility");
            } else {
                this.setClientsCookiePolicy("ignoreCookies");
            }
        } else {
            this.resetState();
            this.setClientsCookiePolicy("compatibility");
        }
    }

    private void resetState() {
        HttpState state = new HttpState();
        HttpState proxyState = new HttpState();
        this.client.setState(state);
        this.clientViaProxy.setState(proxyState);
        this.setProxyAuth(this.clientViaProxy);
    }

    public void setUseGlobalState(boolean enableGlobalState) {
        this.useGlobalState = enableGlobalState;
        this.checkState();
    }

    public void setUseCookies(boolean shouldUseCookies) {
        this.useCookies = shouldUseCookies;
        this.checkState();
    }

    private HttpClient createHttpClient() {
        this.httpConnManager = new MultiThreadedHttpConnectionManager();
        this.setCommonManagerParams(this.httpConnManager);
        return new HttpClient((HttpConnectionManager)this.httpConnManager);
    }

    private HttpClient createHttpClientViaProxy() {
        if (!this.param.isUseProxyChain()) {
            return this.createHttpClient();
        }
        this.httpConnManagerProxy = new MultiThreadedHttpConnectionManager();
        this.setCommonManagerParams(this.httpConnManagerProxy);
        HttpClient clientProxy = new HttpClient((HttpConnectionManager)this.httpConnManagerProxy);
        clientProxy.getHostConfiguration().setProxy(this.param.getProxyChainName(), this.param.getProxyChainPort());
        this.setProxyAuth(clientProxy);
        return clientProxy;
    }

    private void setProxyAuth(HttpClient client) {
        this.setProxyAuth(client.getState());
    }

    private void setProxyAuth(HttpState state) {
        if (this.param.isUseProxyChain() && this.param.isUseProxyChainAuth()) {
            String realm = this.param.getProxyChainRealm();
            state.setProxyCredentials(new AuthScope(this.param.getProxyChainName(), this.param.getProxyChainPort(), realm.isEmpty() ? AuthScope.ANY_REALM : realm), (Credentials)new NTCredentials(this.param.getProxyChainUserName(), this.param.getProxyChainPassword(), "", realm));
        }
    }

    public int executeMethod(HttpMethod method, HttpState state) throws IOException {
        HttpClient requestClient;
        int responseCode = -1;
        String hostName = method.getURI().getHost();
        method.setDoAuthentication(true);
        HostConfiguration hc = null;
        if (HttpSender.isConnectionUpgrade(method)) {
            requestClient = new HttpClient((HttpConnectionManager)new ZapHttpConnectionManager());
            if (this.param.isUseProxy(hostName)) {
                requestClient.getHostConfiguration().setProxy(this.param.getProxyChainName(), this.param.getProxyChainPort());
                this.setProxyAuth(requestClient);
            }
        } else {
            requestClient = this.param.isUseProxy(hostName) ? this.clientViaProxy : this.client;
        }
        if (this.initiator == 7) {
            hc = new HostConfiguration(){

                public synchronized void setHost(URI uri) {
                    try {
                        this.setHost(new HttpHost(uri.getHost(), uri.getPort(), this.getProtocol()));
                    }
                    catch (URIException e) {
                        throw new IllegalArgumentException(e.toString());
                    }
                }
            };
            hc.setHost(hostName, method.getURI().getPort(), new Protocol("https", (ProtocolSocketFactory)new SSLConnector(false), 443));
            if (this.param.isUseProxy(hostName)) {
                hc.setProxyHost(new ProxyHost(this.param.getProxyChainName(), this.param.getProxyChainPort()));
                this.setProxyAuth(requestClient);
            }
        }
        if (state != null) {
            method.getParams().setCookiePolicy("compatibility");
            this.setProxyAuth(state);
        }
        responseCode = requestClient.executeMethod(hc, method, state);
        return responseCode;
    }

    private static boolean isConnectionUpgrade(HttpMethod method) {
        Header connectionHeader = method.getRequestHeader("connection");
        if (connectionHeader == null) {
            return false;
        }
        return connectionHeader.getValue().toLowerCase(Locale.ROOT).contains("upgrade");
    }

    public void shutdown() {
        if (this.httpConnManager != null) {
            this.httpConnManager.shutdown();
        }
        if (this.httpConnManagerProxy != null) {
            this.httpConnManagerProxy.shutdown();
        }
    }

    public void sendAndReceive(HttpMessage msg) throws IOException {
        this.sendAndReceive(msg, this.followRedirect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAndReceive(HttpMessage msg, boolean isFollowRedirect) throws IOException {
        log.debug((Object)("sendAndReceive " + msg.getRequestHeader().getMethod() + " " + msg.getRequestHeader().getURI() + " start"));
        msg.setTimeSentMillis(System.currentTimeMillis());
        try {
            this.notifyRequestListeners(msg);
            if (!isFollowRedirect || !msg.getRequestHeader().getMethod().equalsIgnoreCase("POST") && !msg.getRequestHeader().getMethod().equalsIgnoreCase("PUT")) {
                this.sendAuthenticated(msg, isFollowRedirect);
                return;
            }
            this.sendAuthenticated(msg, false);
            HttpMessage temp = msg.cloneAll();
            temp.setRequestingUser(this.getUser(msg));
            for (int i = 0; i < 1 && HttpStatusCode.isRedirection(temp.getResponseHeader().getStatusCode()) && temp.getResponseHeader().getStatusCode() != 304; ++i) {
                String location = temp.getResponseHeader().getHeader("Location");
                URI baseUri = temp.getRequestHeader().getURI();
                URI newLocation = new URI(baseUri, location, false);
                temp.getRequestHeader().setURI(newLocation);
                temp.getRequestHeader().setMethod("GET");
                temp.getRequestHeader().setHeader("Content-Length", null);
                this.sendAuthenticated(temp, true);
            }
            msg.setResponseHeader(temp.getResponseHeader());
            msg.setResponseBody(temp.getResponseBody());
        }
        finally {
            msg.setTimeElapsedMillis((int)(System.currentTimeMillis() - msg.getTimeSentMillis()));
            log.debug((Object)("sendAndReceive " + msg.getRequestHeader().getMethod() + " " + msg.getRequestHeader().getURI() + " took " + msg.getTimeElapsedMillis()));
            this.notifyResponseListeners(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRequestListeners(HttpMessage msg) {
        if (IN_LISTENER.get() != null) {
            return;
        }
        try {
            IN_LISTENER.set(true);
            for (HttpSenderListener listener : listeners) {
                try {
                    listener.onHttpRequestSend(msg, this.initiator, this);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            IN_LISTENER.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyResponseListeners(HttpMessage msg) {
        if (IN_LISTENER.get() != null) {
            return;
        }
        try {
            IN_LISTENER.set(true);
            for (HttpSenderListener listener : listeners) {
                try {
                    listener.onHttpResponseReceive(msg, this.initiator, this);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            IN_LISTENER.remove();
        }
    }

    public User getUser(HttpMessage msg) {
        if (this.user != null) {
            return this.user;
        }
        return msg.getRequestingUser();
    }

    private void sendAuthenticated(HttpMessage msg, boolean isFollowRedirect) throws IOException {
        this.sendAuthenticated(msg, isFollowRedirect, null);
    }

    private void sendAuthenticated(HttpMessage msg, boolean isFollowRedirect, HttpMethodParams params) throws IOException {
        User forceUser = this.getUser(msg);
        if (this.initiator != 5 && forceUser != null) {
            forceUser.processMessageToMatchUser(msg);
        }
        log.debug((Object)("Sending message to: " + msg.getRequestHeader().getURI().toString()));
        this.send(msg, isFollowRedirect, params);
        if (this.initiator != 5 && forceUser != null && !msg.getRequestHeader().isImage() && !forceUser.isAuthenticated(msg)) {
            log.debug((Object)("First try to send authenticated message failed for " + msg.getRequestHeader().getURI() + ". Authenticating and trying again..."));
            forceUser.queueAuthentication(msg);
            forceUser.processMessageToMatchUser(msg);
            this.send(msg, isFollowRedirect, params);
        } else {
            log.debug((Object)"SUCCESSFUL");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(HttpMessage msg, boolean isFollowRedirect, HttpMethodParams params) throws IOException {
        HttpMethod method = null;
        HttpResponseHeader resHeader = null;
        try {
            method = this.runMethod(msg, isFollowRedirect, params);
            resHeader = HttpMethodHelper.getHttpResponseHeader(method);
            resHeader.setHeader("Transfer-Encoding", null);
            msg.setResponseHeader(resHeader);
            msg.getResponseBody().setCharset(resHeader.getCharset());
            msg.getResponseBody().setLength(0);
            if (!msg.isEventStream()) {
                msg.getResponseBody().append(method.getResponseBody());
            }
            msg.setResponseFromTargetHost(true);
            if (method instanceof ZapGetMethod) {
                msg.setUserObject(method);
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private HttpMethod runMethod(HttpMessage msg, boolean isFollowRedirect, HttpMethodParams params) throws IOException {
        User forceUser;
        HttpMethod method = null;
        this.modifyUserAgent(msg);
        method = helper.createRequestMethod(msg.getRequestHeader(), msg.getRequestBody(), params);
        if (!(method instanceof EntityEnclosingMethod) || method instanceof ZapGetMethod) {
            method.setFollowRedirects(isFollowRedirect);
        }
        if ((forceUser = this.getUser(msg)) != null) {
            this.executeMethod(method, forceUser.getCorrespondingHttpState());
        } else {
            this.executeMethod(method, null);
        }
        HttpMethodHelper.updateHttpRequestHeaderSent(msg.getRequestHeader(), method);
        return method;
    }

    public void setFollowRedirect(boolean followRedirect) {
        this.followRedirect = followRedirect;
    }

    private void modifyUserAgent(HttpMessage msg) {
        try {
            if (userAgent.equals("") || msg.getRequestHeader().isEmpty()) {
                return;
            }
            String currentUserAgent = msg.getRequestHeader().getHeader("User-Agent");
            if (currentUserAgent == null) {
                currentUserAgent = "";
            }
            if (currentUserAgent.indexOf(userAgent) >= 0) {
                return;
            }
            String delimiter = "";
            if (!currentUserAgent.equals("") && !currentUserAgent.endsWith(" ")) {
                delimiter = " ";
            }
            currentUserAgent = currentUserAgent + delimiter + userAgent;
            msg.getRequestHeader().setHeader("User-Agent", currentUserAgent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getUserAgent() {
        return userAgent;
    }

    public static void setUserAgent(String userAgent) {
        HttpSender.userAgent = userAgent;
    }

    private void setCommonManagerParams(MultiThreadedHttpConnectionManager mgr) {
        int timeout = (int)TimeUnit.SECONDS.toMillis(this.param.getTimeoutInSecs());
        mgr.getParams().setSoTimeout(timeout);
        mgr.getParams().setConnectionTimeout(timeout);
        mgr.getParams().setStaleCheckingEnabled(true);
        mgr.getParams().setDefaultMaxConnectionsPerHost(10000);
        mgr.getParams().setMaxTotalConnections(200000);
    }

    public static void addListener(HttpSenderListener listener) {
        listeners.add(listener);
        Collections.sort(listeners, HttpSender.getListenersComparator());
    }

    public static void removeListener(HttpSenderListener listener) {
        listeners.remove(listener);
    }

    private static Comparator<HttpSenderListener> getListenersComparator() {
        if (listenersComparator == null) {
            HttpSender.createListenersComparator();
        }
        return listenersComparator;
    }

    private static synchronized void createListenersComparator() {
        if (listenersComparator == null) {
            listenersComparator = new Comparator<HttpSenderListener>(){

                @Override
                public int compare(HttpSenderListener o1, HttpSenderListener o2) {
                    int order2;
                    int order1 = o1.getListenerOrder();
                    if (order1 < (order2 = o2.getListenerOrder())) {
                        return -1;
                    }
                    if (order1 > order2) {
                        return 1;
                    }
                    return 0;
                }
            };
        }
    }

    public void setUser(User user) {
        this.user = user;
    }

    @Deprecated
    public HttpClient getClient() {
        return this.client;
    }

    public void setRemoveUserDefinedAuthHeaders(boolean removeHeaders) {
        this.client.getParams().setBooleanParameter("remove.user.defined.auth.headers", removeHeaders);
        this.clientViaProxy.getParams().setBooleanParameter("remove.user.defined.auth.headers", removeHeaders);
    }

    public void setMaxRetriesOnIOError(int retries) {
        if (retries < 0) {
            throw new IllegalArgumentException("Parameter retries must be greater or equal to zero.");
        }
        DefaultHttpMethodRetryHandler retryHandler = new DefaultHttpMethodRetryHandler(retries, false);
        this.client.getParams().setParameter("http.method.retry-handler", (Object)retryHandler);
        this.clientViaProxy.getParams().setParameter("http.method.retry-handler", (Object)retryHandler);
    }

    public void setMaxRedirects(int maxRedirects) {
        if (maxRedirects < 0) {
            throw new IllegalArgumentException("Parameter maxRedirects must be greater or equal to zero.");
        }
        this.client.getParams().setIntParameter("http.protocol.max-redirects", maxRedirects);
        this.clientViaProxy.getParams().setIntParameter("http.protocol.max-redirects", maxRedirects);
    }

    public void setAllowCircularRedirects(boolean allow) {
        this.client.getParams().setBooleanParameter("http.protocol.allow-circular-redirects", allow);
        this.clientViaProxy.getParams().setBooleanParameter("http.protocol.allow-circular-redirects", allow);
    }

    public void sendAndReceive(HttpMessage message, HttpRequestConfig requestConfig) throws IOException {
        if (message == null) {
            throw new IllegalArgumentException("Parameter message must not be null.");
        }
        if (requestConfig == null) {
            throw new IllegalArgumentException("Parameter requestConfig must not be null.");
        }
        this.sendAndReceiveImpl(message, requestConfig);
        if (requestConfig.isFollowRedirects()) {
            this.followRedirections(message, requestConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAndReceiveImpl(HttpMessage message, HttpRequestConfig requestConfig) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending " + message.getRequestHeader().getMethod() + " " + message.getRequestHeader().getURI()));
        }
        message.setTimeSentMillis(System.currentTimeMillis());
        try {
            if (requestConfig.isNotifyListeners()) {
                this.notifyRequestListeners(message);
            }
            HttpMethodParams params = null;
            if (requestConfig.getSoTimeout() != -1) {
                params = new HttpMethodParams();
                params.setSoTimeout(requestConfig.getSoTimeout());
            }
            this.sendAuthenticated(message, false, params);
        }
        finally {
            message.setTimeElapsedMillis((int)(System.currentTimeMillis() - message.getTimeSentMillis()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received response after " + message.getTimeElapsedMillis() + "ms for " + message.getRequestHeader().getMethod() + " " + message.getRequestHeader().getURI()));
            }
            if (requestConfig.isNotifyListeners()) {
                this.notifyResponseListeners(message);
            }
        }
    }

    private void followRedirections(HttpMessage message, HttpRequestConfig requestConfig) throws IOException {
        HttpRedirectionValidator validator = requestConfig.getRedirectionValidator();
        validator.notifyMessageReceived(message);
        User requestingUser = this.getUser(message);
        HttpMessage redirectMessage = message;
        int maxRedirections = this.client.getParams().getIntParameter("http.protocol.max-redirects", 100);
        for (int i = 0; i < maxRedirections && HttpSender.isRedirectionNeeded(redirectMessage.getResponseHeader().getStatusCode()); ++i) {
            URI newLocation = HttpSender.extractRedirectLocation(redirectMessage);
            if (newLocation == null || !validator.isValid(newLocation)) {
                return;
            }
            redirectMessage = redirectMessage.cloneAll();
            redirectMessage.setRequestingUser(requestingUser);
            redirectMessage.getRequestHeader().setURI(newLocation);
            if (HttpSender.isRequestRewriteNeeded(redirectMessage)) {
                redirectMessage.getRequestHeader().setMethod("GET");
                redirectMessage.getRequestHeader().setHeader("Content-Type", null);
                redirectMessage.getRequestHeader().setHeader("Content-Length", null);
                redirectMessage.setRequestBody("");
            }
            this.sendAndReceiveImpl(redirectMessage, requestConfig);
            validator.notifyMessageReceived(redirectMessage);
            message.setResponseHeader(redirectMessage.getResponseHeader());
            message.setResponseBody(redirectMessage.getResponseBody());
        }
    }

    private static boolean isRedirectionNeeded(int statusCode) {
        switch (statusCode) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    private static boolean isRequestRewriteNeeded(HttpMessage message) {
        int statusCode = message.getResponseHeader().getStatusCode();
        String method = message.getRequestHeader().getMethod();
        if (statusCode == 301 || statusCode == 302) {
            return "POST".equalsIgnoreCase(method);
        }
        return statusCode == 303 && !"GET".equalsIgnoreCase(method) && !"HEAD".equalsIgnoreCase(method);
    }

    private static URI extractRedirectLocation(HttpMessage message) throws InvalidRedirectLocationException {
        String location = message.getResponseHeader().getHeader("Location");
        if (location == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No Location header found: " + message.getResponseHeader()));
            }
            return null;
        }
        try {
            return new URI(message.getRequestHeader().getURI(), location, true);
        }
        catch (URIException ex) {
            throw new InvalidRedirectLocationException("Invalid redirect location: " + location, location, (Throwable)ex);
        }
    }

    static {
        try {
            protocol = Protocol.getProtocol((String)"https");
            sslFactory = protocol.getSocketFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sslFactory == null || !(sslFactory instanceof SSLConnector)) {
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new SSLConnector(true), 443));
        }
        AuthPolicy.registerAuthScheme((String)"NTLM", ZapNTLMScheme.class);
        CookiePolicy.registerCookieSpec((String)"default", ZapCookieSpec.class);
        CookiePolicy.registerCookieSpec((String)"compatibility", ZapCookieSpec.class);
        helper = new HttpMethodHelper();
        userAgent = "";
        IN_LISTENER = new ThreadLocal();
    }
}

