/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.rowio.RowInputInterface;

public class RowStoreAVLMemory
extends RowStoreAVL {
    AtomicInteger rowIdSequence = new AtomicInteger();

    public RowStoreAVLMemory(Table table) {
        this.database = table.database;
        this.table = table;
        this.indexList = table.getIndexList();
        this.accessorList = new CachedObject[this.indexList.length];
        this.lock = new ReentrantReadWriteLock();
        this.readLock = this.lock.readLock();
        this.writeLock = this.lock.writeLock();
    }

    @Override
    public boolean isMemory() {
        return true;
    }

    public int getAccessCount() {
        return 0;
    }

    @Override
    public void set(CachedObject cachedObject) {
    }

    @Override
    public CachedObject get(long l) {
        throw Error.runtimeError(201, "RowStoreAVMemory");
    }

    @Override
    public CachedObject get(long l, boolean bl) {
        throw Error.runtimeError(201, "RowStoreAVLMemory");
    }

    @Override
    public CachedObject get(CachedObject cachedObject, boolean bl) {
        return cachedObject;
    }

    @Override
    public void add(Session session, CachedObject cachedObject, boolean bl) {
    }

    @Override
    public CachedObject get(RowInputInterface rowInputInterface) {
        throw Error.runtimeError(201, "RowStoreAVLMemory");
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean bl) {
        long l = this.rowIdSequence.getAndIncrement();
        RowAVL rowAVL = new RowAVL(this.table, (Object[])object, l, this);
        if (bl) {
            RowAction.addInsertAction(session, this.table, rowAVL);
        }
        return rowAVL;
    }

    @Override
    public void removeAll() {
        this.destroy();
        this.setTimestamp(0L);
        this.elementCount.set(0L);
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void remove(CachedObject cachedObject) {
    }

    public void release(long l) {
    }

    @Override
    public void commitPersistence(CachedObject cachedObject) {
    }

    @Override
    public void postCommitAction(Session session, RowAction rowAction) {
        if (rowAction.getType() == 3 && !rowAction.isDeleteComplete()) {
            rowAction.setDeleteComplete();
            Row row = rowAction.getRow();
            this.delete(session, row);
        }
    }

    @Override
    public void commitRow(Session session, Row row, int n, int n2) {
        if (!this.database.logger.isCurrentlyLogged()) {
            return;
        }
        Object[] objectArray = row.getData();
        switch (n) {
            case 2: {
                this.database.logger.writeDeleteStatement(session, (Table)this.table, objectArray);
                break;
            }
            case 1: {
                this.database.logger.writeInsertStatement(session, row, (Table)this.table);
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                throw Error.runtimeError(201, "RowStore");
            }
        }
    }

    @Override
    public void rollbackRow(Session session, Row row, int n, int n2) {
        switch (n) {
            case 2: {
                if (n2 != 0) break;
                ((RowAVL)row).setNewNodes(this);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                this.delete(session, row);
                this.remove(row);
                break;
            }
            case 4: {
                if (n2 == 0) {
                    this.remove(row);
                    break;
                }
                this.delete(session, row);
                this.remove(row);
            }
        }
    }

    @Override
    public DataFileCache getCache() {
        return null;
    }

    @Override
    public void setCache(DataFileCache dataFileCache) {
    }

    @Override
    public void release() {
        this.destroy();
        this.setTimestamp(0L);
        this.elementCount.set(0L);
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void readLock() {
        this.readLock.lock();
    }

    @Override
    public void readUnlock() {
        this.readLock.unlock();
    }

    @Override
    public void writeLock() {
        this.writeLock.lock();
    }

    @Override
    public void writeUnlock() {
        this.writeLock.unlock();
    }
}

