/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.sms;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.config.Keys;
import org.traccar.helper.DataConverter;
import org.traccar.notification.MessageException;
import org.traccar.sms.SmsManager;

public class HttpSmsClient
implements SmsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpSmsClient.class);
    private final String url = Context.getConfig().getString(Keys.SMS_HTTP_URL);
    private final String authorizationHeader = Context.getConfig().getString(Keys.SMS_HTTP_AUTHORIZATION_HEADER);
    private final String authorization;
    private final String template;
    private final boolean encode;
    private final MediaType mediaType;

    public HttpSmsClient() {
        if (Context.getConfig().hasKey(Keys.SMS_HTTP_AUTHORIZATION)) {
            this.authorization = Context.getConfig().getString(Keys.SMS_HTTP_AUTHORIZATION);
        } else {
            String user = Context.getConfig().getString(Keys.SMS_HTTP_USER);
            String password = Context.getConfig().getString(Keys.SMS_HTTP_PASSWORD);
            this.authorization = user != null && password != null ? "Basic " + DataConverter.printBase64((user + ":" + password).getBytes(StandardCharsets.UTF_8)) : null;
        }
        this.template = Context.getConfig().getString(Keys.SMS_HTTP_TEMPLATE).trim();
        if (this.template.charAt(0) == '{' || this.template.charAt(0) == '[') {
            this.encode = false;
            this.mediaType = MediaType.APPLICATION_JSON_TYPE;
        } else {
            this.encode = true;
            this.mediaType = MediaType.APPLICATION_FORM_URLENCODED_TYPE;
        }
    }

    private String prepareValue(String value) throws UnsupportedEncodingException {
        return this.encode ? URLEncoder.encode(value, StandardCharsets.UTF_8.name()) : value;
    }

    private String preparePayload(String destAddress, String message) {
        try {
            return this.template.replace("{phone}", this.prepareValue(destAddress)).replace("{message}", this.prepareValue(message.trim()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private Invocation.Builder getRequestBuilder() {
        Invocation.Builder builder = Context.getClient().target(this.url).request();
        if (this.authorization != null) {
            builder = builder.header(this.authorizationHeader, (Object)this.authorization);
        }
        return builder;
    }

    @Override
    public void sendMessageSync(String destAddress, String message, boolean command) throws MessageException {
        Response response = this.getRequestBuilder().post(Entity.entity((Object)this.preparePayload(destAddress, message), (MediaType)this.mediaType));
        if (response.getStatus() / 100 != 2) {
            throw new MessageException((String)response.readEntity(String.class));
        }
    }

    @Override
    public void sendMessageAsync(String destAddress, String message, boolean command) {
        this.getRequestBuilder().async().post(Entity.entity((Object)this.preparePayload(destAddress, message), (MediaType)this.mediaType), (InvocationCallback)new InvocationCallback<String>(){

            public void completed(String s) {
            }

            public void failed(Throwable throwable) {
                LOGGER.warn("SMS send failed", throwable);
            }
        });
    }
}

