/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class Tr20ProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN_PING = new PatternBuilder().text("%%").expression("[^,]+,").number("(d+)").compile();
    private static final Pattern PATTERN_DATA = new PatternBuilder().text("%%").expression("([^,]+),").expression("([AL]),").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").expression("([NS])").number("(dd)(dd.d+)").expression("([EW])").number("(ddd)(dd.d+),").number("(d+),").number("(d+),").number("(?:NA|[FC]?(-?d+)),").number("(x{8}),").number("(d+)").any().compile();

    public Tr20ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN_PING, (String)msg);
        if (parser.matches()) {
            if (channel != null) {
                channel.writeAndFlush((Object)new NetworkMessage("&&" + parser.next() + "\r\n", remoteAddress));
            }
            return null;
        }
        parser = new Parser(PATTERN_DATA, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.setValid(parser.next().equals("A"));
        position.setTime(parser.nextDateTime());
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN));
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
        position.setCourse(parser.nextDouble());
        position.set("temp1", parser.nextInt());
        position.set("status", parser.nextHexLong());
        position.set("event", parser.nextInt());
        return position;
    }
}

