/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateBuilder;
import org.traccar.model.Position;

public class PstProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_ACK = 0;
    public static final int MSG_STATUS = 5;
    public static final int MSG_COMMAND = 6;

    public PstProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Date readDate(ByteBuf buf) {
        long value = buf.readUnsignedInt();
        return new DateBuilder().setYear((int)BitUtil.between(value, 26, 32)).setMonth((int)BitUtil.between(value, 22, 26)).setDay((int)BitUtil.between(value, 17, 22)).setHour((int)BitUtil.between(value, 12, 17)).setMinute((int)BitUtil.between(value, 6, 12)).setSecond((int)BitUtil.between(value, 0, 6)).getDate();
    }

    private double readCoordinate(ByteBuf buf) {
        long value = buf.readUnsignedInt();
        int sign = BitUtil.check(value, 31) ? -1 : 1;
        value = BitUtil.to(value, 31);
        return (double)sign * ((double)BitUtil.from(value, 16) + (double)BitUtil.to(value, 16) / 10000.0) / 60.0;
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, long id, int version, long index, int type) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeInt((int)id);
            response.writeByte(version);
            response.writeInt((int)index);
            response.writeByte(0);
            response.writeByte(type);
            response.writeShort(Checksum.crc16(Checksum.CRC16_XMODEM, response.nioBuffer()));
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        long id = buf.readUnsignedInt();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, String.valueOf(id));
        if (deviceSession == null) {
            return null;
        }
        short version = buf.readUnsignedByte();
        long index = buf.readUnsignedInt();
        short type = buf.readUnsignedByte();
        this.sendResponse(channel, remoteAddress, id, version, index, type);
        if (type == 5) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setDeviceTime(this.readDate(buf));
            short status = buf.readUnsignedByte();
            position.set("blocked", BitUtil.check(status, 4));
            position.set("ignition", BitUtil.check(status, 7));
            position.set("status", Integer.valueOf(status));
            int count = buf.readUnsignedByte();
            block5: for (int i = 0; i < count; ++i) {
                short tag = buf.readUnsignedByte();
                short length = buf.readUnsignedByte();
                switch (tag) {
                    case 9: {
                        buf.readUnsignedByte();
                        buf.readUnsignedByte();
                        buf.readUnsignedByte();
                        continue block5;
                    }
                    case 13: {
                        short battery = buf.readUnsignedByte();
                        if (battery > 20) continue block5;
                        position.set("batteryLevel", battery * 5);
                        continue block5;
                    }
                    case 16: {
                        position.setValid(true);
                        position.setFixTime(this.readDate(buf));
                        position.setLatitude(this.readCoordinate(buf));
                        position.setLongitude(this.readCoordinate(buf));
                        position.setSpeed(buf.readUnsignedByte());
                        position.setCourse(buf.readUnsignedByte() * 2);
                        position.setAltitude(buf.readShort());
                        buf.readUnsignedInt();
                        continue block5;
                    }
                    default: {
                        buf.skipBytes((int)length);
                    }
                }
            }
            return position.getFixTime() != null ? position : null;
        }
        return null;
    }
}

