/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import javax.json.Json;
import javax.json.JsonObject;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.model.Position;

public class PolteProtocolDecoder
extends BaseHttpProtocolDecoder {
    public PolteProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        String content = request.content().toString(StandardCharsets.UTF_8);
        JsonObject json = Json.createReader((Reader)new StringReader(content)).readObject();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, json.getString("ueToken"));
        if (deviceSession == null) {
            this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
            return null;
        }
        if (json.containsKey((Object)"location")) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            JsonObject location = json.getJsonObject("location");
            position.setValid(true);
            position.setTime(new Date((long)location.getInt("detected_at") * 1000L));
            position.setLatitude(location.getJsonNumber("latitude").doubleValue());
            position.setLongitude(location.getJsonNumber("longitude").doubleValue());
            position.setAltitude(location.getJsonNumber("altitude").doubleValue());
            if (json.containsKey((Object)"report")) {
                JsonObject report = json.getJsonObject("report");
                position.set("event", report.getInt("event"));
                if (report.containsKey((Object)"battery")) {
                    JsonObject battery = report.getJsonObject("battery");
                    position.set("batteryLevel", battery.getInt("level"));
                    position.set("battery", battery.getJsonNumber("voltage").doubleValue());
                }
            }
            return position;
        }
        this.sendResponse(channel, HttpResponseStatus.OK);
        return null;
    }
}

