/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.model.Position;

public class LeafSpyProtocolDecoder
extends BaseHttpProtocolDecoder {
    public LeafSpyProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        QueryStringDecoder decoder = new QueryStringDecoder(request.uri());
        Map params = decoder.parameters();
        if (params.isEmpty()) {
            decoder = new QueryStringDecoder(request.content().toString(StandardCharsets.US_ASCII), false);
            params = decoder.parameters();
        }
        Position position = new Position(this.getProtocolName());
        position.setValid(true);
        for (Map.Entry entry : params.entrySet()) {
            block33: for (String value : (List)entry.getValue()) {
                switch ((String)entry.getKey()) {
                    case "pass": {
                        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, value);
                        if (deviceSession == null) {
                            this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
                            return null;
                        }
                        position.setDeviceId(deviceSession.getDeviceId());
                        continue block33;
                    }
                    case "Lat": {
                        position.setLatitude(Double.parseDouble(value));
                        continue block33;
                    }
                    case "Long": {
                        position.setLongitude(Double.parseDouble(value));
                        continue block33;
                    }
                    case "RPM": {
                        position.set("rpm", Integer.parseInt(value));
                        position.setSpeed(this.convertSpeed(Double.parseDouble(value) / 63.0, "kmh"));
                        continue block33;
                    }
                    case "Elv": {
                        position.setAltitude(Double.parseDouble(value));
                        continue block33;
                    }
                    case "SOC": {
                        position.set("batteryLevel", Double.parseDouble(value));
                        continue block33;
                    }
                    case "user": {
                        position.set("driverUniqueId", value);
                        continue block33;
                    }
                    case "ChrgMode": {
                        position.set("charge", Integer.parseInt(value) != 0);
                        continue block33;
                    }
                    case "Odo": {
                        position.set("obdOdometer", Integer.parseInt(value) * 1000);
                        continue block33;
                    }
                }
                try {
                    position.set((String)entry.getKey(), Double.parseDouble(value));
                }
                catch (NumberFormatException e) {
                    switch (value) {
                        case "true": {
                            position.set((String)entry.getKey(), true);
                            continue block33;
                        }
                        case "false": {
                            position.set((String)entry.getKey(), false);
                            continue block33;
                        }
                    }
                    position.set((String)entry.getKey(), value);
                }
            }
        }
        if (position.getFixTime() == null) {
            position.setTime(new Date());
        }
        if (position.getLatitude() == 0.0 && position.getLongitude() == 0.0) {
            this.getLastLocation(position, position.getDeviceTime());
        }
        if (position.getDeviceId() != 0L) {
            this.sendResponse(channel, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)"\"status\":\"0\"", (Charset)StandardCharsets.US_ASCII));
            return position;
        }
        this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
        return null;
    }
}

