/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import io.netty.channel.ChannelHandler;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.traccar.BaseDataHandler;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.database.IdentityManager;
import org.traccar.helper.DistanceCalculator;
import org.traccar.model.Position;

@ChannelHandler.Sharable
public class DistanceHandler
extends BaseDataHandler {
    private final IdentityManager identityManager;
    private final boolean filter;
    private final int coordinatesMinError;
    private final int coordinatesMaxError;

    public DistanceHandler(Config config, IdentityManager identityManager) {
        this.identityManager = identityManager;
        this.filter = config.getBoolean(Keys.COORDINATES_FILTER);
        this.coordinatesMinError = config.getInteger(Keys.COORDINATES_MIN_ERROR);
        this.coordinatesMaxError = config.getInteger(Keys.COORDINATES_MAX_ERROR);
    }

    @Override
    protected Position handlePosition(Position position) {
        Position last;
        double distance = 0.0;
        if (position.getAttributes().containsKey("distance")) {
            distance = position.getDouble("distance");
        }
        double totalDistance = 0.0;
        Position position2 = last = this.identityManager != null ? this.identityManager.getLastPosition(position.getDeviceId()) : null;
        if (last != null) {
            totalDistance = last.getDouble("totalDistance");
            if (!position.getAttributes().containsKey("distance")) {
                distance = DistanceCalculator.distance(position.getLatitude(), position.getLongitude(), last.getLatitude(), last.getLongitude());
                distance = BigDecimal.valueOf(distance).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
            }
            if (this.filter && last.getValid() && last.getLatitude() != 0.0 && last.getLongitude() != 0.0) {
                boolean satisfiesMax;
                boolean satisfiesMin = this.coordinatesMinError == 0 || distance > (double)this.coordinatesMinError;
                boolean bl = satisfiesMax = this.coordinatesMaxError == 0 || distance < (double)this.coordinatesMaxError || position.getValid();
                if (!satisfiesMin || !satisfiesMax) {
                    position.setLatitude(last.getLatitude());
                    position.setLongitude(last.getLongitude());
                    distance = 0.0;
                }
            }
        }
        position.set("distance", distance);
        totalDistance = BigDecimal.valueOf(totalDistance + distance).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
        position.set("totalDistance", totalDistance);
        return position;
    }
}

