/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PSKKeyExchangeModesExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PSKKeyExchangeModesExtensionSerializer
extends ExtensionSerializer<PSKKeyExchangeModesExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PSKKeyExchangeModesExtensionMessage msg;

    public PSKKeyExchangeModesExtensionSerializer(PSKKeyExchangeModesExtensionMessage message) {
        super(message);
        this.msg = message;
    }

    @Override
    public byte[] serializeExtensionContent() {
        LOGGER.debug("Serializing PSKKeyExchangeModesExtensionMessage");
        this.writeKeyExchangeModesListLength(this.msg);
        this.writeKeyExchangeModesListBytes(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeKeyExchangeModesListLength(PSKKeyExchangeModesExtensionMessage msg) {
        this.appendInt((Integer)msg.getKeyExchangeModesListLength().getValue(), 1);
        LOGGER.debug("KeyExchangeModesListLength: " + msg.getKeyExchangeModesListLength().getValue());
    }

    private void writeKeyExchangeModesListBytes(PSKKeyExchangeModesExtensionMessage msg) {
        this.appendBytes((byte[])msg.getKeyExchangeModesListBytes().getValue());
        LOGGER.debug("KeyExchangeModesListBytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getKeyExchangeModesListBytes().getValue())));
    }
}

