/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.certificate.ocsp;

import com.google.common.io.ByteStreams;
import de.rub.nds.asn1.parser.ParserException;
import de.rub.nds.tlsattacker.core.certificate.ocsp.CertificateInformationExtractor;
import de.rub.nds.tlsattacker.core.certificate.ocsp.OCSPRequestMessage;
import de.rub.nds.tlsattacker.core.certificate.ocsp.OCSPResponse;
import de.rub.nds.tlsattacker.core.certificate.ocsp.OCSPResponseParser;
import de.rub.nds.tlsattacker.core.certificate.ocsp.OCSPResponseTypes;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.apache.commons.lang3.NotImplementedException;
import org.bouncycastle.asn1.x509.Certificate;

public class OCSPRequest {
    private final Certificate certificate;
    private final CertificateInformationExtractor infoExtractorMain;
    private Certificate issuerCertificate;
    private CertificateInformationExtractor infoExtractorIssuer;
    private OCSPRequestMessage requestMessage;
    private URL serverUrl;

    public OCSPRequest(org.bouncycastle.crypto.tls.Certificate certificateChain, URL serverUrl) {
        this.certificate = certificateChain.getCertificateAt(0);
        this.infoExtractorMain = new CertificateInformationExtractor(this.certificate);
        this.serverUrl = serverUrl;
        if (certificateChain.getLength() > 1) {
            this.issuerCertificate = certificateChain.getCertificateAt(1);
            this.infoExtractorIssuer = new CertificateInformationExtractor(this.issuerCertificate);
        }
    }

    public OCSPRequest(Certificate mainCertificate, Certificate issuerCertificate, URL serverUrl) {
        this.certificate = mainCertificate;
        this.infoExtractorMain = new CertificateInformationExtractor(this.certificate);
        this.issuerCertificate = issuerCertificate;
        this.infoExtractorIssuer = new CertificateInformationExtractor(issuerCertificate);
        this.serverUrl = serverUrl;
    }

    public URL getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(URL url) {
        this.serverUrl = url;
    }

    public void setServerUrl(String url) throws MalformedURLException {
        this.serverUrl = new URL(url);
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public Certificate getIssuerCertificate() {
        return this.issuerCertificate;
    }

    public OCSPRequestMessage getRequestMessage() {
        return this.requestMessage;
    }

    public void setRequestMessage(OCSPRequestMessage requestMessage) {
        this.requestMessage = requestMessage;
    }

    public OCSPResponse makeRequest() throws IOException, NoSuchAlgorithmException, ParserException {
        if (this.requestMessage == null) {
            this.requestMessage = this.createDefaultRequestMessage();
        }
        return this.performRequest(this.requestMessage, "POST");
    }

    public OCSPResponse makeRequest(OCSPRequestMessage requestMessage) throws IOException, ParserException {
        return this.performRequest(requestMessage, "POST");
    }

    public OCSPResponse makeGetRequest() throws IOException, NoSuchAlgorithmException, ParserException {
        if (this.requestMessage == null) {
            this.requestMessage = this.createDefaultRequestMessage();
        }
        return this.performRequest(this.requestMessage, "GET");
    }

    public OCSPResponse makeGetRequest(OCSPRequestMessage requestMessage) throws IOException, ParserException {
        return this.performRequest(requestMessage, "GET");
    }

    public OCSPRequestMessage createDefaultRequestMessage() throws IOException, NoSuchAlgorithmException {
        BigInteger serialNumber = this.infoExtractorMain.getSerialNumber();
        byte[] issuerNameHash = this.infoExtractorMain.getIssuerNameHash();
        byte[] issuerKeyHash = this.issuerCertificate != null && this.infoExtractorIssuer != null ? this.infoExtractorIssuer.getIssuerKeyHash() : this.infoExtractorMain.getIssuerKeyHash();
        OCSPRequestMessage requestMessage = new OCSPRequestMessage(issuerNameHash, issuerKeyHash, serialNumber);
        requestMessage.addExtension(OCSPResponseTypes.ACCEPTABLE_RESPONSES.getOID());
        return requestMessage;
    }

    private OCSPResponse performRequest(OCSPRequestMessage requestMessage, String requestMethod) throws IOException, ParserException {
        byte[] encodedRequest = requestMessage.getEncodedRequest();
        HttpURLConnection httpCon = null;
        if (requestMethod.equals("POST")) {
            httpCon = (HttpURLConnection)this.serverUrl.openConnection();
            httpCon.setRequestMethod("POST");
            httpCon.setRequestProperty("Content-Type", "application/ocsp-request");
            httpCon.setDoOutput(true);
            OutputStream os = httpCon.getOutputStream();
            os.write(encodedRequest);
            os.flush();
            os.close();
        } else if (requestMethod.equals("GET")) {
            byte[] encoded = Base64.getEncoder().encode(encodedRequest);
            URL requestUrl = new URL(this.serverUrl.toExternalForm() + "/" + new String(encoded));
            httpCon = (HttpURLConnection)requestUrl.openConnection();
            httpCon.setRequestMethod("GET");
        } else {
            throw new NotImplementedException("Request type is neither POST nor GET.");
        }
        httpCon.setConnectTimeout(5000);
        int status = httpCon.getResponseCode();
        if (status != 200) {
            throw new RuntimeException("Response not successful: Received status code " + status);
        }
        byte[] response = ByteStreams.toByteArray((InputStream)httpCon.getInputStream());
        httpCon.disconnect();
        return OCSPResponseParser.parseResponse(response);
    }
}

