/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.PaintBridge;
import org.apache.batik.bridge.PaintServer;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.svg.ICCColor;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Element;

public class SVGSolidColorElementBridge
extends AbstractSVGBridge
implements PaintBridge {
    public String getNamespaceURI() {
        return "http://www.w3.org/2000/svg";
    }

    public String getLocalName() {
        return "solidColor";
    }

    public Paint createPaint(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode, float f) {
        f = SVGSolidColorElementBridge.extractOpacity(element, f, bridgeContext);
        return SVGSolidColorElementBridge.extractColor(element, f, bridgeContext);
    }

    protected static float extractOpacity(Element element, float f, BridgeContext bridgeContext) {
        HashMap<ParsedURL, ParsedURL> hashMap = new HashMap<ParsedURL, ParsedURL>();
        CSSEngine cSSEngine = CSSUtilities.getCSSEngine(element);
        int n = cSSEngine.getPropertyIndex("solid-opacity");
        while (true) {
            Value value = CSSUtilities.getComputedStyle(element, n);
            StyleMap styleMap = ((CSSStylableElement)element).getComputedStyleMap(null);
            if (!styleMap.isNullCascaded(n)) {
                float f2 = PaintServer.convertOpacity(value);
                return f * f2;
            }
            String string = XLinkSupport.getXLinkHref(element);
            if (string.length() == 0) {
                return f;
            }
            SVGOMDocument sVGOMDocument = (SVGOMDocument)element.getOwnerDocument();
            ParsedURL parsedURL = new ParsedURL(sVGOMDocument.getURL(), string);
            if (hashMap.containsKey(parsedURL)) {
                throw new BridgeException(element, "xlink.href.circularDependencies", new Object[]{string});
            }
            hashMap.put(parsedURL, parsedURL);
            element = bridgeContext.getReferencedElement(element, string);
        }
    }

    protected static Color extractColor(Element element, float f, BridgeContext bridgeContext) {
        HashMap<ParsedURL, ParsedURL> hashMap = new HashMap<ParsedURL, ParsedURL>();
        CSSEngine cSSEngine = CSSUtilities.getCSSEngine(element);
        int n = cSSEngine.getPropertyIndex("solid-color");
        while (true) {
            Value value = CSSUtilities.getComputedStyle(element, n);
            StyleMap styleMap = ((CSSStylableElement)element).getComputedStyleMap(null);
            if (!styleMap.isNullCascaded(n)) {
                if (value.getCssValueType() == 1) {
                    return PaintServer.convertColor(value, f);
                }
                return PaintServer.convertRGBICCColor(element, value.item(0), (ICCColor)value.item(1), f, bridgeContext);
            }
            String string = XLinkSupport.getXLinkHref(element);
            if (string.length() == 0) {
                return new Color(0.0f, 0.0f, 0.0f, f);
            }
            SVGOMDocument sVGOMDocument = (SVGOMDocument)element.getOwnerDocument();
            ParsedURL parsedURL = new ParsedURL(sVGOMDocument.getURL(), string);
            if (hashMap.containsKey(parsedURL)) {
                throw new BridgeException(element, "xlink.href.circularDependencies", new Object[]{string});
            }
            hashMap.put(parsedURL, parsedURL);
            element = bridgeContext.getReferencedElement(element, string);
        }
    }
}

