/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.velocity.app.event.EventHandlerUtil;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.InputBase;
import org.apache.velocity.runtime.directive.MacroParseException;
import org.apache.velocity.runtime.directive.StopCommand;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.util.StringUtils;

public class Parse
extends InputBase {
    private int maxDepth;
    public boolean strictRef = false;

    @Override
    public String getName() {
        return "parse";
    }

    @Override
    public String getScopeName() {
        return "template";
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void init(RuntimeServices runtimeServices, InternalContextAdapter internalContextAdapter, Node node) throws TemplateInitException {
        super.init(runtimeServices, internalContextAdapter, node);
        this.maxDepth = this.rsvc.getInt("directive.parse.max.depth", 10);
        this.strictRef = this.rsvc.getBoolean("runtime.references.strict", false);
    }

    @Override
    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        Object object;
        if (node.jjtGetNumChildren() == 0) {
            throw new VelocityException("#parse(): argument missing at " + StringUtils.formatFileString(this));
        }
        Object object2 = node.jjtGetChild(0).value(internalContextAdapter);
        if (object2 == null) {
            this.log.debug("#parse(): null argument at {}", (Object)StringUtils.formatFileString(this));
        }
        String string = object2 == null ? null : object2.toString();
        String string2 = EventHandlerUtil.includeEvent(this.rsvc, internalContextAdapter, string, internalContextAdapter.getCurrentTemplateName(), this.getName());
        if (this.strictRef && object2 == null && string2 == null) {
            throw new VelocityException("The argument to #parse returned null at " + StringUtils.formatFileString(this));
        }
        if (string2 == null) {
            return true;
        }
        if (this.maxDepth > 0 && ((String[])(object = internalContextAdapter.getTemplateNameStack())).length >= this.maxDepth) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string3 : object) {
                stringBuilder.append(" > " + string3);
            }
            this.log.error("Max recursion depth reached ({}). File stack: {}", (Object)((String[])object).length, (Object)stringBuilder);
            return false;
        }
        object = null;
        try {
            object = this.rsvc.getTemplate(string2, this.getInputEncoding(internalContextAdapter));
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            this.log.error("#parse(): cannot find template '{}', called at {}", (Object)string2, (Object)StringUtils.formatFileString(this));
            throw resourceNotFoundException;
        }
        catch (ParseErrorException parseErrorException) {
            this.log.error("#parse(): syntax error in #parse()-ed template '{}', called at {}", (Object)string2, (Object)StringUtils.formatFileString(this));
            throw parseErrorException;
        }
        catch (RuntimeException runtimeException) {
            this.log.error("Exception rendering #parse({}) at {}", (Object)string2, (Object)StringUtils.formatFileString(this));
            throw runtimeException;
        }
        catch (Exception exception) {
            String string4 = "Exception rendering #parse(" + string2 + ") at " + StringUtils.formatFileString(this);
            this.log.error(string4, (Throwable)exception);
            throw new VelocityException(string4, exception);
        }
        ArrayList<Object> arrayList = internalContextAdapter.getMacroLibraries();
        if (arrayList == null) {
            arrayList = new ArrayList<Object>();
        }
        internalContextAdapter.setMacroLibraries(arrayList);
        arrayList.add(object);
        try {
            this.preRender(internalContextAdapter);
            internalContextAdapter.pushCurrentTemplateName(string2);
            ((SimpleNode)((Resource)object).getData()).render(internalContextAdapter, writer);
        }
        catch (StopCommand stopCommand) {
            if (!stopCommand.isFor(this)) {
                throw stopCommand;
            }
        }
        catch (RuntimeException runtimeException) {
            this.log.error("Exception rendering #parse({}) at {}", (Object)string2, (Object)StringUtils.formatFileString(this));
            throw runtimeException;
        }
        catch (Exception exception) {
            String string5 = "Exception rendering #parse(" + string2 + ") at " + StringUtils.formatFileString(this);
            this.log.error(string5, (Throwable)exception);
            throw new VelocityException(string5, exception);
        }
        finally {
            internalContextAdapter.popCurrentTemplateName();
            this.postRender(internalContextAdapter);
        }
        return true;
    }

    @Override
    public void checkArgs(ArrayList<Integer> arrayList, Token token, String string) throws ParseException {
        if (arrayList.size() != 1) {
            throw new MacroParseException("The #parse directive requires one argument", string, token);
        }
        if (arrayList.get(0) == 11) {
            throw new MacroParseException("The argument to #parse is of the wrong type", string, token);
        }
    }
}

