/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.util.Locale;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlJsonConstructorNullClause;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.validate.SqlValidator;

public class SqlJsonArrayFunction
extends SqlFunction {
    public SqlJsonArrayFunction() {
        super("JSON_ARRAY", SqlKind.OTHER_FUNCTION, ReturnTypes.VARCHAR_2000, null, OperandTypes.VARIADIC, SqlFunctionCategory.SYSTEM);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.from(1);
    }

    @Override
    protected void checkOperandCount(SqlValidator validator, SqlOperandTypeChecker argType, SqlCall call) {
        assert (call.operandCount() >= 1);
    }

    @Override
    public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        if (operands[0] == null) {
            operands[0] = SqlLiteral.createSymbol(SqlJsonConstructorNullClause.ABSENT_ON_NULL, pos);
        }
        return super.createCall(functionQualifier, pos, operands);
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        assert (operandsCount >= 1);
        StringBuilder sb = new StringBuilder();
        sb.append("{0}(");
        for (int i = 1; i < operandsCount; ++i) {
            sb.append(String.format(Locale.ROOT, "{%d} ", i + 1));
        }
        sb.append("{1})");
        return sb.toString();
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() >= 1);
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        SqlWriter.Frame listFrame = writer.startList("", "");
        for (int i = 1; i < call.operandCount(); ++i) {
            writer.sep(",");
            ((SqlNode)call.operand(i)).unparse(writer, leftPrec, rightPrec);
        }
        writer.endList(listFrame);
        SqlJsonConstructorNullClause nullClause = (SqlJsonConstructorNullClause)((Object)this.getEnumValue((SqlNode)call.operand(0)));
        switch (nullClause) {
            case ABSENT_ON_NULL: {
                writer.keyword("ABSENT ON NULL");
                break;
            }
            case NULL_ON_NULL: {
                writer.keyword("NULL ON NULL");
                break;
            }
            default: {
                throw new IllegalStateException("unreachable code");
            }
        }
        writer.endFunCall(frame);
    }

    private <E extends Enum<E>> E getEnumValue(SqlNode operand) {
        return (E)((Enum)((SqlLiteral)operand).getValue());
    }
}

