/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.FeatureField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.uninverting.UninvertingReader;

public class RankField
extends FieldType {
    public static final String INTERNAL_RANK_FIELD_NAME = "_rank_";

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        throw null;
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
    }

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        if (schema.getFieldOrNull(INTERNAL_RANK_FIELD_NAME) != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "A field named \"_rank_\" can't be defined in the schema");
        }
        for (int prop : new int[]{4, 32768, 32, 1024, 2048}) {
            if ((this.trueProperties & prop) == 0) continue;
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Property \"" + RankField.getPropertyName(prop) + "\" can't be set to true in RankFields");
        }
        for (int prop : new int[]{524288, 1, 512}) {
            if ((this.falseProperties & prop) == 0) continue;
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Property \"" + RankField.getPropertyName(prop) + "\" can't be set to false in RankFields");
        }
        this.properties &= 0xFFF77FFB;
    }

    @Override
    protected IndexableField createField(String name, String val, IndexableFieldType type) {
        float featureValue;
        if (val == null || val.isEmpty()) {
            return null;
        }
        try {
            featureValue = Float.parseFloat(val);
        }
        catch (NumberFormatException nfe) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error while creating field '" + name + "' from value '" + val + "'. Expecting float.", (Throwable)nfe);
        }
        return new FeatureField(INTERNAL_RANK_FIELD_NAME, name, featureValue);
    }

    @Override
    public Query getExistenceQuery(QParser parser, SchemaField field) {
        return new TermQuery(new Term(INTERNAL_RANK_FIELD_NAME, field.getName()));
    }

    @Override
    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only a \"*\" term query can be done on RankFields");
    }

    @Override
    protected Query getSpecializedRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Range queries not supported on RankFields");
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "can not sort on a rank field: " + field.getName());
    }
}

