/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.Iterator;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.FastWriter;
import org.apache.solr.common.util.TextWriter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BasicResultContext;
import org.apache.solr.response.DocsStreamer;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocList;
import org.apache.solr.search.ReturnFields;

public abstract class TextResponseWriter
implements TextWriter {
    protected final FastWriter writer;
    protected final IndexSchema schema;
    protected final SolrQueryRequest req;
    protected final SolrQueryResponse rsp;
    protected ReturnFields returnFields;
    protected int level;
    protected boolean doIndent;
    protected Calendar cal;

    public TextResponseWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) {
        this.writer = writer == null ? null : FastWriter.wrap((Writer)writer);
        this.schema = req.getSchema();
        this.req = req;
        this.rsp = rsp;
        String indent = req.getParams().get("indent");
        if (null == indent || !"off".equals(indent) && !"false".equals(indent)) {
            this.doIndent = true;
        }
        this.returnFields = rsp.getReturnFields();
        if (req.getParams().getBool("omitHeader", false)) {
            rsp.removeResponseHeader();
        }
    }

    TextResponseWriter(Writer writer, boolean indent) {
        this.writer = writer == null ? null : FastWriter.wrap((Writer)writer);
        this.schema = null;
        this.req = null;
        this.rsp = null;
        this.returnFields = null;
        this.doIndent = indent;
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.flushBuffer();
        }
    }

    public boolean doIndent() {
        return this.doIndent;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int level() {
        return this.level;
    }

    public int incLevel() {
        return ++this.level;
    }

    public int decLevel() {
        return --this.level;
    }

    public TextResponseWriter setIndent(boolean doIndent) {
        this.doIndent = doIndent;
        return this;
    }

    public final void writeVal(String name, Object val) throws IOException {
        if (val == null) {
            this.writeNull(name);
            return;
        }
        if (val instanceof IndexableField) {
            IndexableField f = (IndexableField)val;
            SchemaField sf = this.schema.getFieldOrNull(f.name());
            if (sf != null) {
                sf.getType().write(this, name, f);
            } else {
                this.writeStr(name, f.stringValue(), true);
            }
        } else if (val instanceof Document) {
            SolrDocument doc = DocsStreamer.convertLuceneDocToSolrDoc((Document)val, this.schema, this.returnFields);
            this.writeSolrDocument(name, doc, this.returnFields, 0);
        } else if (val instanceof SolrDocument) {
            this.writeSolrDocument(name, (SolrDocument)val, this.returnFields, 0);
        } else if (val instanceof ResultContext) {
            this.writeDocuments(name, (ResultContext)val);
        } else if (val instanceof DocList) {
            BasicResultContext ctx = new BasicResultContext((DocList)val, this.returnFields, null, null, this.req);
            this.writeDocuments(name, ctx);
        } else if (val instanceof SolrDocumentList) {
            this.writeSolrDocumentList(name, (SolrDocumentList)val, this.returnFields);
        } else if (val instanceof BytesRef) {
            BytesRef arr = (BytesRef)val;
            this.writeByteArr(name, arr.bytes, arr.offset, arr.length);
        } else {
            super.writeVal(name, val);
        }
    }

    public void writeStartDocumentList(String name, long start, int size, long numFound, Float maxScore, Boolean numFoundExact) throws IOException {
        this.writeStartDocumentList(name, start, size, numFound, maxScore);
    }

    @Deprecated
    public abstract void writeStartDocumentList(String var1, long var2, int var4, long var5, Float var7) throws IOException;

    public abstract void writeSolrDocument(String var1, SolrDocument var2, ReturnFields var3, int var4) throws IOException;

    public abstract void writeEndDocumentList() throws IOException;

    public final void writeSolrDocumentList(String name, SolrDocumentList docs, ReturnFields fields) throws IOException {
        this.writeStartDocumentList(name, docs.getStart(), docs.size(), docs.getNumFound(), docs.getMaxScore(), docs.getNumFoundExact());
        for (int i = 0; i < docs.size(); ++i) {
            this.writeSolrDocument(null, (SolrDocument)docs.get(i), fields, i);
        }
        this.writeEndDocumentList();
    }

    public final void writeDocuments(String name, ResultContext res) throws IOException {
        DocList ids = res.getDocList();
        Iterator<SolrDocument> docsStreamer = res.getProcessedDocuments();
        this.writeStartDocumentList(name, ids.offset(), ids.size(), ids.matches(), res.wantsScores() ? Float.valueOf(ids.maxScore()) : null, ids.hitCountRelation() == TotalHits.Relation.EQUAL_TO);
        int idx = 0;
        while (docsStreamer.hasNext()) {
            this.writeSolrDocument(null, docsStreamer.next(), res.getReturnFields(), idx);
            ++idx;
        }
        this.writeEndDocumentList();
    }
}

