/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.Constants;
import org.apache.commons.csv.IOUtils;
import org.apache.commons.csv.QuoteMode;

public final class CSVFormat
implements Serializable {
    public static final CSVFormat DEFAULT = new CSVFormat(',', Constants.DOUBLE_QUOTE_CHAR, null, null, null, false, true, "\r\n", null, null, null, false, false, false, false, false, false, true);
    public static final CSVFormat EXCEL = DEFAULT.withIgnoreEmptyLines(false).withAllowMissingColumnNames();
    public static final CSVFormat INFORMIX_UNLOAD = DEFAULT.withDelimiter('|').withEscape('\\').withQuote(Constants.DOUBLE_QUOTE_CHAR).withRecordSeparator('\n');
    public static final CSVFormat INFORMIX_UNLOAD_CSV = DEFAULT.withDelimiter(',').withQuote(Constants.DOUBLE_QUOTE_CHAR).withRecordSeparator('\n');
    public static final CSVFormat MONGODB_CSV = DEFAULT.withDelimiter(',').withEscape(Constants.DOUBLE_QUOTE_CHAR).withQuote(Constants.DOUBLE_QUOTE_CHAR).withQuoteMode(QuoteMode.MINIMAL).withSkipHeaderRecord(false);
    public static final CSVFormat MONGODB_TSV = DEFAULT.withDelimiter('\t').withEscape(Constants.DOUBLE_QUOTE_CHAR).withQuote(Constants.DOUBLE_QUOTE_CHAR).withQuoteMode(QuoteMode.MINIMAL).withSkipHeaderRecord(false);
    public static final CSVFormat MYSQL = DEFAULT.withDelimiter('\t').withEscape('\\').withIgnoreEmptyLines(false).withQuote(null).withRecordSeparator('\n').withNullString("\\N").withQuoteMode(QuoteMode.ALL_NON_NULL);
    public static final CSVFormat ORACLE = DEFAULT.withDelimiter(',').withEscape('\\').withIgnoreEmptyLines(false).withQuote(Constants.DOUBLE_QUOTE_CHAR).withNullString("\\N").withTrim().withSystemRecordSeparator().withQuoteMode(QuoteMode.MINIMAL);
    public static final CSVFormat POSTGRESQL_CSV = DEFAULT.withDelimiter(',').withEscape(Constants.DOUBLE_QUOTE_CHAR).withIgnoreEmptyLines(false).withQuote(Constants.DOUBLE_QUOTE_CHAR).withRecordSeparator('\n').withNullString("").withQuoteMode(QuoteMode.ALL_NON_NULL);
    public static final CSVFormat POSTGRESQL_TEXT = DEFAULT.withDelimiter('\t').withEscape('\\').withIgnoreEmptyLines(false).withQuote(Constants.DOUBLE_QUOTE_CHAR).withRecordSeparator('\n').withNullString("\\N").withQuoteMode(QuoteMode.ALL_NON_NULL);
    public static final CSVFormat RFC4180 = DEFAULT.withIgnoreEmptyLines(false);
    private static final long serialVersionUID = 1L;
    public static final CSVFormat TDF = DEFAULT.withDelimiter('\t').withIgnoreSurroundingSpaces();
    private final boolean allowDuplicateHeaderNames;
    private final boolean allowMissingColumnNames;
    private final boolean autoFlush;
    private final Character commentMarker;
    private final char delimiter;
    private final Character escapeCharacter;
    private final String[] header;
    private final String[] headerComments;
    private final boolean ignoreEmptyLines;
    private final boolean ignoreHeaderCase;
    private final boolean ignoreSurroundingSpaces;
    private final String nullString;
    private final Character quoteCharacter;
    private final String quotedNullString;
    private final QuoteMode quoteMode;
    private final String recordSeparator;
    private final boolean skipHeaderRecord;
    private final boolean trailingDelimiter;
    private final boolean trim;

    private static boolean isLineBreak(char c) {
        return c == '\n' || c == '\r';
    }

    private static boolean isLineBreak(Character c) {
        return c != null && CSVFormat.isLineBreak(c.charValue());
    }

    public static CSVFormat newFormat(char delimiter) {
        return new CSVFormat(delimiter, null, null, null, null, false, false, null, null, null, null, false, false, false, false, false, false, true);
    }

    public static CSVFormat valueOf(String format) {
        return Predefined.valueOf(format).getFormat();
    }

    private CSVFormat(char delimiter, Character quoteChar, QuoteMode quoteMode, Character commentStart, Character escape, boolean ignoreSurroundingSpaces, boolean ignoreEmptyLines, String recordSeparator, String nullString, Object[] headerComments, String[] header, boolean skipHeaderRecord, boolean allowMissingColumnNames, boolean ignoreHeaderCase, boolean trim, boolean trailingDelimiter, boolean autoFlush, boolean allowDuplicateHeaderNames) {
        this.delimiter = delimiter;
        this.quoteCharacter = quoteChar;
        this.quoteMode = quoteMode;
        this.commentMarker = commentStart;
        this.escapeCharacter = escape;
        this.ignoreSurroundingSpaces = ignoreSurroundingSpaces;
        this.allowMissingColumnNames = allowMissingColumnNames;
        this.ignoreEmptyLines = ignoreEmptyLines;
        this.recordSeparator = recordSeparator;
        this.nullString = nullString;
        this.headerComments = this.toStringArray(headerComments);
        this.header = header == null ? null : (String[])header.clone();
        this.skipHeaderRecord = skipHeaderRecord;
        this.ignoreHeaderCase = ignoreHeaderCase;
        this.trailingDelimiter = trailingDelimiter;
        this.trim = trim;
        this.autoFlush = autoFlush;
        this.quotedNullString = this.quoteCharacter + nullString + this.quoteCharacter;
        this.allowDuplicateHeaderNames = allowDuplicateHeaderNames;
        this.validate();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CSVFormat other = (CSVFormat)obj;
        if (this.delimiter != other.delimiter) {
            return false;
        }
        if (this.trailingDelimiter != other.trailingDelimiter) {
            return false;
        }
        if (this.autoFlush != other.autoFlush) {
            return false;
        }
        if (this.trim != other.trim) {
            return false;
        }
        if (this.allowMissingColumnNames != other.allowMissingColumnNames) {
            return false;
        }
        if (this.allowDuplicateHeaderNames != other.allowDuplicateHeaderNames) {
            return false;
        }
        if (this.ignoreHeaderCase != other.ignoreHeaderCase) {
            return false;
        }
        if (this.quoteMode != other.quoteMode) {
            return false;
        }
        if (this.quoteCharacter == null ? other.quoteCharacter != null : !this.quoteCharacter.equals(other.quoteCharacter)) {
            return false;
        }
        if (this.commentMarker == null ? other.commentMarker != null : !this.commentMarker.equals(other.commentMarker)) {
            return false;
        }
        if (this.escapeCharacter == null ? other.escapeCharacter != null : !this.escapeCharacter.equals(other.escapeCharacter)) {
            return false;
        }
        if (this.nullString == null ? other.nullString != null : !this.nullString.equals(other.nullString)) {
            return false;
        }
        if (!Arrays.equals(this.header, other.header)) {
            return false;
        }
        if (this.ignoreSurroundingSpaces != other.ignoreSurroundingSpaces) {
            return false;
        }
        if (this.ignoreEmptyLines != other.ignoreEmptyLines) {
            return false;
        }
        if (this.skipHeaderRecord != other.skipHeaderRecord) {
            return false;
        }
        if (this.recordSeparator == null ? other.recordSeparator != null : !this.recordSeparator.equals(other.recordSeparator)) {
            return false;
        }
        return Arrays.equals(this.headerComments, other.headerComments);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String format(Object ... values) {
        StringWriter out = new StringWriter();
        try (CSVPrinter csvPrinter = new CSVPrinter(out, this);){
            csvPrinter.printRecord(values);
            String string = out.toString().trim();
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean getAllowDuplicateHeaderNames() {
        return this.allowDuplicateHeaderNames;
    }

    public boolean getAllowMissingColumnNames() {
        return this.allowMissingColumnNames;
    }

    public boolean getAutoFlush() {
        return this.autoFlush;
    }

    public Character getCommentMarker() {
        return this.commentMarker;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public Character getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public String[] getHeader() {
        return this.header != null ? (String[])this.header.clone() : null;
    }

    public String[] getHeaderComments() {
        return this.headerComments != null ? (String[])this.headerComments.clone() : null;
    }

    public boolean getIgnoreEmptyLines() {
        return this.ignoreEmptyLines;
    }

    public boolean getIgnoreHeaderCase() {
        return this.ignoreHeaderCase;
    }

    public boolean getIgnoreSurroundingSpaces() {
        return this.ignoreSurroundingSpaces;
    }

    public String getNullString() {
        return this.nullString;
    }

    public Character getQuoteCharacter() {
        return this.quoteCharacter;
    }

    public QuoteMode getQuoteMode() {
        return this.quoteMode;
    }

    public String getRecordSeparator() {
        return this.recordSeparator;
    }

    public boolean getSkipHeaderRecord() {
        return this.skipHeaderRecord;
    }

    public boolean getTrailingDelimiter() {
        return this.trailingDelimiter;
    }

    public boolean getTrim() {
        return this.trim;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.delimiter;
        result = 31 * result + (this.quoteMode == null ? 0 : this.quoteMode.hashCode());
        result = 31 * result + (this.quoteCharacter == null ? 0 : this.quoteCharacter.hashCode());
        result = 31 * result + (this.commentMarker == null ? 0 : this.commentMarker.hashCode());
        result = 31 * result + (this.escapeCharacter == null ? 0 : this.escapeCharacter.hashCode());
        result = 31 * result + (this.nullString == null ? 0 : this.nullString.hashCode());
        result = 31 * result + (this.ignoreSurroundingSpaces ? 1231 : 1237);
        result = 31 * result + (this.ignoreHeaderCase ? 1231 : 1237);
        result = 31 * result + (this.ignoreEmptyLines ? 1231 : 1237);
        result = 31 * result + (this.skipHeaderRecord ? 1231 : 1237);
        result = 31 * result + (this.allowDuplicateHeaderNames ? 1231 : 1237);
        result = 31 * result + (this.trim ? 1231 : 1237);
        result = 31 * result + (this.autoFlush ? 1231 : 1237);
        result = 31 * result + (this.trailingDelimiter ? 1231 : 1237);
        result = 31 * result + (this.allowMissingColumnNames ? 1231 : 1237);
        result = 31 * result + (this.recordSeparator == null ? 0 : this.recordSeparator.hashCode());
        result = 31 * result + Arrays.hashCode(this.header);
        result = 31 * result + Arrays.hashCode(this.headerComments);
        return result;
    }

    public boolean isCommentMarkerSet() {
        return this.commentMarker != null;
    }

    public boolean isEscapeCharacterSet() {
        return this.escapeCharacter != null;
    }

    public boolean isNullStringSet() {
        return this.nullString != null;
    }

    public boolean isQuoteCharacterSet() {
        return this.quoteCharacter != null;
    }

    public CSVParser parse(Reader in) throws IOException {
        return new CSVParser(in, this);
    }

    public CSVPrinter print(Appendable out) throws IOException {
        return new CSVPrinter(out, this);
    }

    public CSVPrinter print(File out, Charset charset) throws IOException {
        return new CSVPrinter(new OutputStreamWriter((OutputStream)new FileOutputStream(out), charset), this);
    }

    public void print(Object value, Appendable out, boolean newRecord) throws IOException {
        CharSequence charSequence;
        if (value == null) {
            charSequence = null == this.nullString ? "" : (QuoteMode.ALL == this.quoteMode ? this.quotedNullString : this.nullString);
        } else if (value instanceof CharSequence) {
            charSequence = (CharSequence)value;
        } else {
            if (value instanceof Reader) {
                this.print((Reader)value, out, newRecord);
                return;
            }
            charSequence = value.toString();
        }
        charSequence = this.getTrim() ? this.trim(charSequence) : charSequence;
        this.print(value, charSequence, out, newRecord);
    }

    private void print(Object object, CharSequence value, Appendable out, boolean newRecord) throws IOException {
        boolean offset = false;
        int len = value.length();
        if (!newRecord) {
            out.append(this.getDelimiter());
        }
        if (object == null) {
            out.append(value);
        } else if (this.isQuoteCharacterSet()) {
            this.printWithQuotes(object, value, out, newRecord);
        } else if (this.isEscapeCharacterSet()) {
            this.printWithEscapes(value, out);
        } else {
            out.append(value, 0, len);
        }
    }

    public CSVPrinter print(Path out, Charset charset) throws IOException {
        return this.print(Files.newBufferedWriter(out, charset, new OpenOption[0]));
    }

    private void print(Reader reader, Appendable out, boolean newRecord) throws IOException {
        if (!newRecord) {
            out.append(this.getDelimiter());
        }
        if (this.isQuoteCharacterSet()) {
            this.printWithQuotes(reader, out);
        } else if (this.isEscapeCharacterSet()) {
            this.printWithEscapes(reader, out);
        } else if (out instanceof Writer) {
            IOUtils.copyLarge(reader, (Writer)out);
        } else {
            IOUtils.copy(reader, out);
        }
    }

    public CSVPrinter printer() throws IOException {
        return new CSVPrinter(System.out, this);
    }

    public void println(Appendable out) throws IOException {
        if (this.getTrailingDelimiter()) {
            out.append(this.getDelimiter());
        }
        if (this.recordSeparator != null) {
            out.append(this.recordSeparator);
        }
    }

    public void printRecord(Appendable out, Object ... values) throws IOException {
        for (int i = 0; i < values.length; ++i) {
            this.print(values[i], out, i == 0);
        }
        this.println(out);
    }

    private void printWithEscapes(CharSequence value, Appendable out) throws IOException {
        int pos;
        int len;
        int start = 0;
        int end = len = value.length();
        char delim = this.getDelimiter();
        char escape = this.getEscapeCharacter().charValue();
        for (pos = 0; pos < end; ++pos) {
            char c = value.charAt(pos);
            if (c != '\r' && c != '\n' && c != delim && c != escape) continue;
            if (pos > start) {
                out.append(value, start, pos);
            }
            if (c == '\n') {
                c = 'n';
            } else if (c == '\r') {
                c = 'r';
            }
            out.append(escape);
            out.append(c);
            start = pos + 1;
        }
        if (pos > start) {
            out.append(value, start, pos);
        }
    }

    private void printWithEscapes(Reader reader, Appendable out) throws IOException {
        int c;
        int start = 0;
        int pos = 0;
        char delim = this.getDelimiter();
        char escape = this.getEscapeCharacter().charValue();
        StringBuilder builder = new StringBuilder(4096);
        while (-1 != (c = reader.read())) {
            builder.append((char)c);
            if (c == 13 || c == 10 || c == delim || c == escape) {
                if (pos > start) {
                    out.append(builder.substring(start, pos));
                    builder.setLength(0);
                }
                if (c == 10) {
                    c = 110;
                } else if (c == 13) {
                    c = 114;
                }
                out.append(escape);
                out.append((char)c);
                start = pos + 1;
            }
            ++pos;
        }
        if (pos > start) {
            out.append(builder.substring(start, pos));
        }
    }

    private void printWithQuotes(Object object, CharSequence value, Appendable out, boolean newRecord) throws IOException {
        char c;
        int len;
        boolean quote = false;
        int start = 0;
        int pos = 0;
        int end = len = value.length();
        char delimChar = this.getDelimiter();
        char quoteChar = this.getQuoteCharacter().charValue();
        char escapeChar = this.isEscapeCharacterSet() ? this.getEscapeCharacter().charValue() : quoteChar;
        QuoteMode quoteModePolicy = this.getQuoteMode();
        if (quoteModePolicy == null) {
            quoteModePolicy = QuoteMode.MINIMAL;
        }
        switch (quoteModePolicy) {
            case ALL: 
            case ALL_NON_NULL: {
                quote = true;
                break;
            }
            case NON_NUMERIC: {
                quote = !(object instanceof Number);
                break;
            }
            case NONE: {
                this.printWithEscapes(value, out);
                return;
            }
            case MINIMAL: {
                if (len <= 0) {
                    if (newRecord) {
                        quote = true;
                    }
                } else {
                    c = value.charAt(pos);
                    if (c <= '#') {
                        quote = true;
                    } else {
                        while (pos < end) {
                            c = value.charAt(pos);
                            if (c == '\n' || c == '\r' || c == quoteChar || c == delimChar || c == escapeChar) {
                                quote = true;
                                break;
                            }
                            ++pos;
                        }
                        if (!quote && (c = value.charAt(pos = end - 1)) <= ' ') {
                            quote = true;
                        }
                    }
                }
                if (quote) break;
                out.append(value, start, end);
                return;
            }
            default: {
                throw new IllegalStateException("Unexpected Quote value: " + (Object)((Object)quoteModePolicy));
            }
        }
        if (!quote) {
            out.append(value, start, end);
            return;
        }
        out.append(quoteChar);
        while (pos < end) {
            c = value.charAt(pos);
            if (c == quoteChar || c == escapeChar) {
                out.append(value, start, pos);
                out.append(escapeChar);
                start = pos;
            }
            ++pos;
        }
        out.append(value, start, pos);
        out.append(quoteChar);
    }

    private void printWithQuotes(Reader reader, Appendable out) throws IOException {
        int c;
        if (this.getQuoteMode() == QuoteMode.NONE) {
            this.printWithEscapes(reader, out);
            return;
        }
        int pos = 0;
        char quote = this.getQuoteCharacter().charValue();
        StringBuilder builder = new StringBuilder(4096);
        out.append(quote);
        while (-1 != (c = reader.read())) {
            builder.append((char)c);
            if (c == quote) {
                if (pos > 0) {
                    out.append(builder.substring(0, pos));
                    builder.setLength(0);
                    pos = -1;
                }
                out.append(quote);
                out.append((char)c);
            }
            ++pos;
        }
        if (pos > 0) {
            out.append(builder.substring(0, pos));
        }
        out.append(quote);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Delimiter=<").append(this.delimiter).append('>');
        if (this.isEscapeCharacterSet()) {
            sb.append(' ');
            sb.append("Escape=<").append(this.escapeCharacter).append('>');
        }
        if (this.isQuoteCharacterSet()) {
            sb.append(' ');
            sb.append("QuoteChar=<").append(this.quoteCharacter).append('>');
        }
        if (this.quoteMode != null) {
            sb.append(' ');
            sb.append("QuoteMode=<").append((Object)this.quoteMode).append('>');
        }
        if (this.isCommentMarkerSet()) {
            sb.append(' ');
            sb.append("CommentStart=<").append(this.commentMarker).append('>');
        }
        if (this.isNullStringSet()) {
            sb.append(' ');
            sb.append("NullString=<").append(this.nullString).append('>');
        }
        if (this.recordSeparator != null) {
            sb.append(' ');
            sb.append("RecordSeparator=<").append(this.recordSeparator).append('>');
        }
        if (this.getIgnoreEmptyLines()) {
            sb.append(" EmptyLines:ignored");
        }
        if (this.getIgnoreSurroundingSpaces()) {
            sb.append(" SurroundingSpaces:ignored");
        }
        if (this.getIgnoreHeaderCase()) {
            sb.append(" IgnoreHeaderCase:ignored");
        }
        sb.append(" SkipHeaderRecord:").append(this.skipHeaderRecord);
        if (this.headerComments != null) {
            sb.append(' ');
            sb.append("HeaderComments:").append(Arrays.toString(this.headerComments));
        }
        if (this.header != null) {
            sb.append(' ');
            sb.append("Header:").append(Arrays.toString(this.header));
        }
        return sb.toString();
    }

    private String[] toStringArray(Object[] values) {
        if (values == null) {
            return null;
        }
        String[] strings = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            strings[i] = value == null ? null : value.toString();
        }
        return strings;
    }

    private CharSequence trim(CharSequence charSequence) {
        int pos;
        int count;
        if (charSequence instanceof String) {
            return ((String)charSequence).trim();
        }
        int len = count = charSequence.length();
        for (pos = 0; pos < len && charSequence.charAt(pos) <= ' '; ++pos) {
        }
        while (pos < len && charSequence.charAt(len - 1) <= ' ') {
            --len;
        }
        return pos > 0 || len < count ? charSequence.subSequence(pos, len) : charSequence;
    }

    private void validate() throws IllegalArgumentException {
        if (CSVFormat.isLineBreak(this.delimiter)) {
            throw new IllegalArgumentException("The delimiter cannot be a line break");
        }
        if (this.quoteCharacter != null && this.delimiter == this.quoteCharacter.charValue()) {
            throw new IllegalArgumentException("The quoteChar character and the delimiter cannot be the same ('" + this.quoteCharacter + "')");
        }
        if (this.escapeCharacter != null && this.delimiter == this.escapeCharacter.charValue()) {
            throw new IllegalArgumentException("The escape character and the delimiter cannot be the same ('" + this.escapeCharacter + "')");
        }
        if (this.commentMarker != null && this.delimiter == this.commentMarker.charValue()) {
            throw new IllegalArgumentException("The comment start character and the delimiter cannot be the same ('" + this.commentMarker + "')");
        }
        if (this.quoteCharacter != null && this.quoteCharacter.equals(this.commentMarker)) {
            throw new IllegalArgumentException("The comment start character and the quoteChar cannot be the same ('" + this.commentMarker + "')");
        }
        if (this.escapeCharacter != null && this.escapeCharacter.equals(this.commentMarker)) {
            throw new IllegalArgumentException("The comment start and the escape character cannot be the same ('" + this.commentMarker + "')");
        }
        if (this.escapeCharacter == null && this.quoteMode == QuoteMode.NONE) {
            throw new IllegalArgumentException("No quotes mode set but no escape character is set");
        }
        if (this.header != null && !this.allowDuplicateHeaderNames) {
            HashSet<String> dupCheck = new HashSet<String>();
            for (String hdr : this.header) {
                if (dupCheck.add(hdr)) continue;
                throw new IllegalArgumentException("The header contains a duplicate entry: '" + hdr + "' in " + Arrays.toString(this.header));
            }
        }
    }

    public CSVFormat withAllowDuplicateHeaderNames() {
        return this.withAllowDuplicateHeaderNames(true);
    }

    public CSVFormat withAllowDuplicateHeaderNames(boolean allowDuplicateHeaderNames) {
        return new CSVFormat(this.delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.headerComments, this.header, this.skipHeaderRecord, this.allowMissingColumnNames, this.ignoreHeaderCase, this.trim, this.trailingDelimiter, this.autoFlush, allowDuplicateHeaderNames);
    }

    public CSVFormat withAllowMissingColumnNames() {
        return this.withAllowMissingColumnNames(true);
    }

    public CSVFormat withAllowMissingColumnNames(boolean allowMissingColumnNames) {
        return new CSVFormat(this.delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.headerComments, this.header, this.skipHeaderRecord, allowMissingColumnNames, this.ignoreHeaderCase, this.trim, this.trailingDelimiter, this.autoFlush, this.allowDuplicateHeaderNames);
    }

    public CSVFormat withAutoFlush(boolean autoFlush) {
        return new CSVFormat(this.delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.headerComments, this.header, this.skipHeaderRecord, this.allowMissingColumnNames, this.ignoreHeaderCase, this.trim, this.trailingDelimiter, autoFlush, this.allowDuplicateHeaderNames);
    }

    public CSVFormat withCommentMarker(char commentMarker) {
        return this.withCommentMarker(Character.valueOf(commentMarker));
    }

    public CSVFormat withCommentMarker(Character commentMarker) {
        if (CSVFormat.isLineBreak(commentMarker)) {
            throw new IllegalArgumentException("The comment start marker character cannot be a line break");
        }
        return new CSVFormat(this.delimiter, this.quoteCharacter, this.quoteMode, commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.headerComments, this.header, this.skipHeaderRecord, this.allowMissingColumnNames, this.ignoreHeaderCase, this.trim, this.trailingDelimiter, this.autoFlush, this.allowDuplicateHeaderNames);
    }

    public CSVFormat withDelimiter(char delimiter) {
        if (CSVFormat.isLineBreak(delimiter)) {
            throw new IllegalArgumentException("The delimiter cannot be a line break");
        }
        return new CSVFormat(delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.headerComments, this.header, this.skipHeaderRecord, this.allowMissingColumnNames, this.ignoreHeaderCase, this.trim, this.trailingDelimiter, this.autoFlush, this.allowDuplicateHeaderNames);
    }

    public CSVFormat withEscape(char escape) {
        return this.withEscape(Character.valueOf(escape));
    }

    public CSVFormat withEscape(Character escape) {
        if (CSVFormat.isLineBreak(escape)) {
            throw new IllegalArgumentException("The escape character cannot be a line break");
        }
        return new CSVFormat(this.delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, escape, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.headerComments, this.header, this.skipHeaderRecord, this.allowMissingColumnNames, this.ignoreHeaderCase, this.trim, this.trailingDelimiter, this.autoFlush, this.allowDuplicateHeaderNames);
    }

    public CSVFormat withFirstRecordAsHeader() {
        return this.withHeader(new String[0]).withSkipHeaderRecord();
    }

    public CSVFormat withHeader(Class<? extends Enum<?>> headerEnum) {
        String[] header = null;
        if (headerEnum != null) {
            Enum<?>[] enumValues = headerEnum.getEnumConstants();
            header = new String[enumValues.length];
            for (int i = 0; i < enumValues.length; ++i) {
                header[i] = enumValues[i].name();
            }
        }
        return this.withHeader(header);
    }

    public CSVFormat withHeader(ResultSet resultSet) throws SQLException {
        return this.withHeader(resultSet != null ? resultSet.getMetaData() : null);
    }

    public CSVFormat withHeader(ResultSetMetaData metaData) throws SQLException {
        String[] labels = null;
        if (metaData != null) {
            int columnCount = metaData.getColumnCount();
            labels = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                labels[i] = metaData.getColumnLabel(i + 1);
            }
        }
        return this.withHeader(labels);
    }

    public CSVFormat withHeader(String ... header) {
        return new CSVFormat(this.delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.headerComments, header, this.skipHeaderRecord, this.allowMissingColumnNames, this.ignoreHeaderCase, this.trim, this.trailingDelimiter, this.autoFlush, this.allowDuplicateHeaderNames);
    }

    public CSVFormat withHeaderComments(Object ... headerComments) {
        return new CSVFormat(this.delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, headerComments, this.header, this.skipHeaderRecord, this.allowMissingColumnNames, this.ignoreHeaderCase, this.trim, this.trailingDelimiter, this.autoFlush, this.allowDuplicateHeaderNames);
    }

    public CSVFormat withIgnoreEmptyLines() {
        return this.withIgnoreEmptyLines(true);
    }

    public CSVFormat withIgnoreEmptyLines(boolean ignoreEmptyLines) {
        return new CSVFormat(this.delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, ignoreEmptyLines, this.recordSeparator, this.nullString, this.headerComments, this.header, this.skipHeaderRecord, this.allowMissingColumnNames, this.ignoreHeaderCase, this.trim, this.trailingDelimiter, this.autoFlush, this.allowDuplicateHeaderNames);
    }

    public CSVFormat withIgnoreHeaderCase() {
        return this.withIgnoreHeaderCase(true);
    }

    public CSVFormat withIgnoreHeaderCase(boolean ignoreHeaderCase) {
        return new CSVFormat(this.delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.headerComments, this.header, this.skipHeaderRecord, this.allowMissingColumnNames, ignoreHeaderCase, this.trim, this.trailingDelimiter, this.autoFlush, this.allowDuplicateHeaderNames);
    }

    public CSVFormat withIgnoreSurroundingSpaces() {
        return this.withIgnoreSurroundingSpaces(true);
    }

    public CSVFormat withIgnoreSurroundingSpaces(boolean ignoreSurroundingSpaces) {
        return new CSVFormat(this.delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, this.escapeCharacter, ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.headerComments, this.header, this.skipHeaderRecord, this.allowMissingColumnNames, this.ignoreHeaderCase, this.trim, this.trailingDelimiter, this.autoFlush, this.allowDuplicateHeaderNames);
    }

    public CSVFormat withNullString(String nullString) {
        return new CSVFormat(this.delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, nullString, this.headerComments, this.header, this.skipHeaderRecord, this.allowMissingColumnNames, this.ignoreHeaderCase, this.trim, this.trailingDelimiter, this.autoFlush, this.allowDuplicateHeaderNames);
    }

    public CSVFormat withQuote(char quoteChar) {
        return this.withQuote(Character.valueOf(quoteChar));
    }

    public CSVFormat withQuote(Character quoteChar) {
        if (CSVFormat.isLineBreak(quoteChar)) {
            throw new IllegalArgumentException("The quoteChar cannot be a line break");
        }
        return new CSVFormat(this.delimiter, quoteChar, this.quoteMode, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.headerComments, this.header, this.skipHeaderRecord, this.allowMissingColumnNames, this.ignoreHeaderCase, this.trim, this.trailingDelimiter, this.autoFlush, this.allowDuplicateHeaderNames);
    }

    public CSVFormat withQuoteMode(QuoteMode quoteModePolicy) {
        return new CSVFormat(this.delimiter, this.quoteCharacter, quoteModePolicy, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.headerComments, this.header, this.skipHeaderRecord, this.allowMissingColumnNames, this.ignoreHeaderCase, this.trim, this.trailingDelimiter, this.autoFlush, this.allowDuplicateHeaderNames);
    }

    public CSVFormat withRecordSeparator(char recordSeparator) {
        return this.withRecordSeparator(String.valueOf(recordSeparator));
    }

    public CSVFormat withRecordSeparator(String recordSeparator) {
        return new CSVFormat(this.delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, recordSeparator, this.nullString, this.headerComments, this.header, this.skipHeaderRecord, this.allowMissingColumnNames, this.ignoreHeaderCase, this.trim, this.trailingDelimiter, this.autoFlush, this.allowDuplicateHeaderNames);
    }

    public CSVFormat withSkipHeaderRecord() {
        return this.withSkipHeaderRecord(true);
    }

    public CSVFormat withSkipHeaderRecord(boolean skipHeaderRecord) {
        return new CSVFormat(this.delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.headerComments, this.header, skipHeaderRecord, this.allowMissingColumnNames, this.ignoreHeaderCase, this.trim, this.trailingDelimiter, this.autoFlush, this.allowDuplicateHeaderNames);
    }

    public CSVFormat withSystemRecordSeparator() {
        return this.withRecordSeparator(System.getProperty("line.separator"));
    }

    public CSVFormat withTrailingDelimiter() {
        return this.withTrailingDelimiter(true);
    }

    public CSVFormat withTrailingDelimiter(boolean trailingDelimiter) {
        return new CSVFormat(this.delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.headerComments, this.header, this.skipHeaderRecord, this.allowMissingColumnNames, this.ignoreHeaderCase, this.trim, trailingDelimiter, this.autoFlush, this.allowDuplicateHeaderNames);
    }

    public CSVFormat withTrim() {
        return this.withTrim(true);
    }

    public CSVFormat withTrim(boolean trim) {
        return new CSVFormat(this.delimiter, this.quoteCharacter, this.quoteMode, this.commentMarker, this.escapeCharacter, this.ignoreSurroundingSpaces, this.ignoreEmptyLines, this.recordSeparator, this.nullString, this.headerComments, this.header, this.skipHeaderRecord, this.allowMissingColumnNames, this.ignoreHeaderCase, trim, this.trailingDelimiter, this.autoFlush, this.allowDuplicateHeaderNames);
    }

    public static enum Predefined {
        Default(DEFAULT),
        Excel(EXCEL),
        InformixUnload(INFORMIX_UNLOAD),
        InformixUnloadCsv(INFORMIX_UNLOAD_CSV),
        MongoDBCsv(MONGODB_CSV),
        MongoDBTsv(MONGODB_TSV),
        MySQL(MYSQL),
        Oracle(ORACLE),
        PostgreSQLCsv(POSTGRESQL_CSV),
        PostgreSQLText(POSTGRESQL_TEXT),
        RFC4180(RFC4180),
        TDF(TDF);

        private final CSVFormat format;

        private Predefined(CSVFormat format) {
            this.format = format;
        }

        public CSVFormat getFormat() {
            return this.format;
        }
    }
}

