/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public final class FocusUtil {
    private static final Logger LOG = Logger.getInstance(FocusUtil.class);

    public static Component findFocusableComponentIn(Container searchIn, Component toSkip) {
        List components = UIUtil.uiTraverser(searchIn).toList();
        for (Component component : components) {
            if (component.equals(toSkip) || !component.isFocusable()) continue;
            return component;
        }
        return searchIn;
    }

    @Nullable
    public static Component getMostRecentComponent(Component component, Window ancestor) {
        if (ancestor != null) {
            try {
                Component mostRecentFocusOwner = (Component)Objects.requireNonNull(ReflectionUtil.getDeclaredMethod(KeyboardFocusManager.class, (String)"getMostRecentFocusOwner", (Class[])new Class[]{Window.class})).invoke(null, ancestor);
                if (mostRecentFocusOwner != null && SwingUtilities.isDescendingFrom(mostRecentFocusOwner, component) && mostRecentFocusOwner.isShowing()) {
                    return mostRecentFocusOwner;
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.debug((Throwable)e);
            }
        }
        return null;
    }

    public static Component getDefaultComponentInPanel(Component component) {
        if (component instanceof JPanel) {
            JPanel container = (JPanel)component;
            FocusTraversalPolicy policy = container.getFocusTraversalPolicy();
            if (policy == null) {
                return container;
            }
            Component defaultComponent = policy.getDefaultComponent(container);
            if (defaultComponent == null) {
                return container;
            }
            return policy.getDefaultComponent(container);
        }
        return null;
    }
}

