/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.NullableComponent;
import com.intellij.openapi.ui.Splittable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.util.MathUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Splitter
extends JPanel
implements Splittable {
    private static final Icon SplitGlueH = EmptyIcon.create(6, 17);
    private static final Icon SplitGlueV = EmptyIcon.create(17, 6);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.ui.Splitter");
    @NonNls
    public static final String PROP_PROPORTION = "proportion";
    @NonNls
    public static final String PROP_ORIENTATION = "orientation";
    private int myDividerWidth;
    private boolean myVerticalSplit;
    private boolean myHonorMinimumSize;
    private boolean myHonorPreferredSize;
    private final float myMinProp;
    private final float myMaxProp;
    protected float myProportion;
    protected final Divider myDivider;
    private JComponent mySecondComponent;
    private JComponent myFirstComponent;
    private final FocusWatcher myFocusWatcher;
    private boolean myShowDividerIcon;
    private boolean myShowDividerControls;
    private boolean mySkipNextLayout;
    private static final Rectangle myNullBounds = new Rectangle();
    @NotNull
    private LackOfSpaceStrategy myLackOfSpaceStrategy = LackOfSpaceStrategy.SIMPLE_RATIO;
    @NotNull
    private DividerPositionStrategy myDividerPositionStrategy = DividerPositionStrategy.KEEP_PROPORTION;

    public Splitter() {
        this(false);
    }

    public Splitter(boolean vertical) {
        this(vertical, 0.5f);
    }

    public Splitter(boolean vertical, float proportion) {
        this(vertical, proportion, 0.0f, 1.0f);
    }

    public Splitter(boolean vertical, float proportion, float minProp, float maxProp) {
        this.myMinProp = minProp;
        this.myMaxProp = maxProp;
        LOG.assertTrue(minProp >= 0.0f);
        LOG.assertTrue(maxProp <= 1.0f);
        LOG.assertTrue(minProp <= maxProp);
        this.myVerticalSplit = vertical;
        this.myShowDividerControls = false;
        this.myShowDividerIcon = true;
        this.myHonorMinimumSize = true;
        this.myHonorPreferredSize = false;
        this.myDivider = this.createDivider();
        this.setProportion(proportion);
        this.myDividerWidth = 7;
        super.add(this.myDivider);
        this.myFocusWatcher = new FocusWatcher();
        this.myFocusWatcher.install(this);
        this.setOpaque(false);
    }

    public void setShowDividerControls(boolean showDividerControls) {
        this.myShowDividerControls = showDividerControls;
        this.setOrientation(this.myVerticalSplit);
    }

    public void setShowDividerIcon(boolean showDividerIcon) {
        this.myShowDividerIcon = showDividerIcon;
        this.setOrientation(this.myVerticalSplit);
    }

    public void setResizeEnabled(boolean value) {
        this.myDivider.setResizeEnabled(value);
    }

    public void setAllowSwitchOrientationByMouseClick(boolean enabled) {
        this.myDivider.setSwitchOrientationEnabled(enabled);
    }

    public boolean isShowDividerIcon() {
        return this.myShowDividerIcon;
    }

    public boolean isShowDividerControls() {
        return this.myShowDividerControls;
    }

    public boolean isHonorMinimumSize() {
        return this.myHonorMinimumSize;
    }

    public void setHonorComponentsMinimumSize(boolean honorMinimumSize) {
        this.myHonorMinimumSize = honorMinimumSize;
    }

    public boolean isHonorPreferredSize() {
        return this.myHonorPreferredSize;
    }

    public void setHonorComponentsPreferredSize(boolean honorPreferredSize) {
        this.myHonorPreferredSize = honorPreferredSize;
    }

    public void setLackOfSpaceStrategy(@NotNull LackOfSpaceStrategy strategy) {
        if (strategy == null) {
            Splitter.$$$reportNull$$$0(0);
        }
        this.myLackOfSpaceStrategy = strategy;
    }

    @NotNull
    public LackOfSpaceStrategy getLackOfSpaceStrategy() {
        LackOfSpaceStrategy lackOfSpaceStrategy = this.myLackOfSpaceStrategy;
        if (lackOfSpaceStrategy == null) {
            Splitter.$$$reportNull$$$0(1);
        }
        return lackOfSpaceStrategy;
    }

    public void setDividerPositionStrategy(@NotNull DividerPositionStrategy dividerPositionStrategy) {
        if (dividerPositionStrategy == null) {
            Splitter.$$$reportNull$$$0(2);
        }
        this.myDividerPositionStrategy = dividerPositionStrategy;
    }

    @NotNull
    public DividerPositionStrategy getDividerPositionStrategy() {
        DividerPositionStrategy dividerPositionStrategy = this.myDividerPositionStrategy;
        if (dividerPositionStrategy == null) {
            Splitter.$$$reportNull$$$0(3);
        }
        return dividerPositionStrategy;
    }

    @Override
    @Deprecated
    public Component add(Component comp) {
        int childCount = this.getComponentCount();
        LOG.assertTrue(childCount >= 1);
        if (childCount > 3) {
            throw new IllegalStateException(String.valueOf(childCount));
        }
        if (childCount == 1) {
            this.setFirstComponent((JComponent)comp);
        } else {
            this.setSecondComponent((JComponent)comp);
        }
        return comp;
    }

    public void dispose() {
        this.myFocusWatcher.deinstall(this);
    }

    protected Divider createDivider() {
        return new DividerImpl();
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && (this.myFirstComponent != null && this.myFirstComponent.isVisible() || this.mySecondComponent != null && this.mySecondComponent.isVisible());
    }

    @Override
    public Dimension getMinimumSize() {
        int dividerWidth = this.getDividerWidth();
        if (this.myFirstComponent != null && this.myFirstComponent.isVisible() && this.mySecondComponent != null && this.mySecondComponent.isVisible()) {
            Dimension firstMinSize = this.myFirstComponent.getMinimumSize();
            Dimension secondMinSize = this.mySecondComponent.getMinimumSize();
            return this.isVertical() ? new Dimension(Math.max(firstMinSize.width, secondMinSize.width), firstMinSize.height + dividerWidth + secondMinSize.height) : new Dimension(firstMinSize.width + dividerWidth + secondMinSize.width, Math.max(firstMinSize.height, secondMinSize.height));
        }
        if (this.myFirstComponent != null && this.myFirstComponent.isVisible()) {
            return this.myFirstComponent.getMinimumSize();
        }
        if (this.mySecondComponent != null && this.mySecondComponent.isVisible()) {
            return this.mySecondComponent.getMinimumSize();
        }
        return super.getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        int dividerWidth = this.getDividerWidth();
        if (this.myFirstComponent != null && this.myFirstComponent.isVisible() && this.mySecondComponent != null && this.mySecondComponent.isVisible()) {
            Dimension firstPrefSize = this.myFirstComponent.getPreferredSize();
            Dimension secondPrefSize = this.mySecondComponent.getPreferredSize();
            return this.isVertical() ? new Dimension(Math.max(firstPrefSize.width, secondPrefSize.width), firstPrefSize.height + dividerWidth + secondPrefSize.height) : new Dimension(firstPrefSize.width + dividerWidth + secondPrefSize.width, Math.max(firstPrefSize.height, secondPrefSize.height));
        }
        if (this.myFirstComponent != null && this.myFirstComponent.isVisible()) {
            return this.myFirstComponent.getPreferredSize();
        }
        if (this.mySecondComponent != null && this.mySecondComponent.isVisible()) {
            return this.mySecondComponent.getPreferredSize();
        }
        return super.getPreferredSize();
    }

    public void skipNextLayout() {
        this.mySkipNextLayout = true;
    }

    @Override
    public void reshape(int x, int y, int w, int h) {
        if (w > 0 && h > 0 && this.myDividerPositionStrategy != DividerPositionStrategy.KEEP_PROPORTION && !Splitter.isNull(this.myFirstComponent) && this.myFirstComponent.isVisible() && !this.myFirstComponent.getBounds().isEmpty() && !Splitter.isNull(this.mySecondComponent) && this.mySecondComponent.isVisible() && !this.mySecondComponent.getBounds().isEmpty() && (this.myVerticalSplit && h > 2 * this.getDividerWidth() || !this.myVerticalSplit && w > 2 * this.getDividerWidth()) && (this.myVerticalSplit && h != this.getHeight() || !this.myVerticalSplit && w != this.getWidth())) {
            int total;
            int n = total = this.myVerticalSplit ? h : w;
            if (this.myDividerPositionStrategy == DividerPositionStrategy.KEEP_FIRST_SIZE) {
                this.myProportion = this.getProportionForFirstSize(this.myVerticalSplit ? this.myFirstComponent.getHeight() : this.myFirstComponent.getWidth(), total);
            } else if (this.myDividerPositionStrategy == DividerPositionStrategy.KEEP_SECOND_SIZE) {
                this.myProportion = this.getProportionForSecondSize(this.myVerticalSplit ? this.mySecondComponent.getHeight() : this.mySecondComponent.getWidth(), total);
            }
        }
        super.reshape(x, y, w, h);
    }

    @ApiStatus.Internal
    protected final float getProportionForFirstSize(int firstSize, int totalSize) {
        Splitter.checkSize(firstSize);
        this.checkTotalSize(totalSize);
        return (float)firstSize / (float)(totalSize - this.getDividerWidth());
    }

    @ApiStatus.Internal
    protected final float getProportionForSecondSize(int secondSize, int totalSize) {
        Splitter.checkSize(secondSize);
        this.checkTotalSize(totalSize);
        return (float)(totalSize - this.getDividerWidth() - secondSize) / (float)(totalSize - this.getDividerWidth());
    }

    private static void checkSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size is negative: " + size);
        }
    }

    private void checkTotalSize(int totalSize) {
        int d = this.getDividerWidth();
        if (totalSize <= d) {
            throw new IllegalArgumentException("divider width >= total size: " + d + " >= " + totalSize);
        }
    }

    @Override
    public void doLayout() {
        int total;
        if (this.mySkipNextLayout) {
            this.mySkipNextLayout = false;
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int n = total = this.isVertical() ? height : width;
        if (total <= 0) {
            return;
        }
        if (!Splitter.isNull(this.myFirstComponent) && this.myFirstComponent.isVisible() && !Splitter.isNull(this.mySecondComponent) && this.mySecondComponent.isVisible()) {
            double size1;
            Rectangle firstRect = new Rectangle();
            Rectangle dividerRect = new Rectangle();
            Rectangle secondRect = new Rectangle();
            int d = this.getDividerWidth();
            if (total <= d) {
                size1 = 0.0;
                d = total;
            } else {
                size1 = this.myProportion * (float)(total - d);
                double size2 = (double)total - size1 - (double)d;
                if (this.isHonorMinimumSize()) {
                    double pSize2;
                    double mSize1 = this.isVertical() ? this.myFirstComponent.getMinimumSize().getHeight() : this.myFirstComponent.getMinimumSize().getWidth();
                    double mSize2 = this.isVertical() ? this.mySecondComponent.getMinimumSize().getHeight() : this.mySecondComponent.getMinimumSize().getWidth();
                    double pSize1 = this.isVertical() ? this.myFirstComponent.getPreferredSize().getHeight() : this.myFirstComponent.getPreferredSize().getWidth();
                    double d2 = pSize2 = this.isVertical() ? this.mySecondComponent.getPreferredSize().getHeight() : this.mySecondComponent.getPreferredSize().getWidth();
                    if (this.myHonorPreferredSize && size1 + size2 > pSize1 + pSize2) {
                        mSize1 = pSize1;
                        mSize2 = pSize2;
                    }
                    if (size1 + size2 < mSize1 + mSize2) {
                        switch (this.myLackOfSpaceStrategy) {
                            case SIMPLE_RATIO: {
                                double proportion = mSize1 / (mSize1 + mSize2);
                                size1 = proportion * (double)total;
                                break;
                            }
                            case HONOR_THE_FIRST_MIN_SIZE: {
                                size1 = mSize1;
                                break;
                            }
                            case HONOR_THE_SECOND_MIN_SIZE: {
                                size1 = (double)total - mSize2 - (double)d;
                            }
                        }
                    } else if (size1 < mSize1) {
                        size1 = mSize1;
                    } else if (size2 < mSize2) {
                        size2 = mSize2;
                        size1 = (double)total - size2 - (double)d;
                    }
                }
            }
            int iSize1 = Math.max(0, (int)Math.round(size1));
            int iSize2 = Math.max(0, total - iSize1 - d);
            if (this.isVertical()) {
                firstRect.setBounds(0, 0, width, iSize1);
                dividerRect.setBounds(0, iSize1, width, d);
                secondRect.setBounds(0, iSize1 + d, width, iSize2);
            } else {
                firstRect.setBounds(0, 0, iSize1, height);
                dividerRect.setBounds(iSize1, 0, d, height);
                secondRect.setBounds(iSize1 + d, 0, iSize2, height);
            }
            this.myDivider.setVisible(true);
            this.myFirstComponent.setBounds(firstRect);
            this.myDivider.setBounds(dividerRect);
            this.mySecondComponent.setBounds(secondRect);
        } else if (!Splitter.isNull(this.myFirstComponent) && this.myFirstComponent.isVisible()) {
            Splitter.hideNull(this.mySecondComponent);
            this.myDivider.setVisible(false);
            this.myFirstComponent.setBounds(0, 0, width, height);
        } else if (!Splitter.isNull(this.mySecondComponent) && this.mySecondComponent.isVisible()) {
            Splitter.hideNull(this.myFirstComponent);
            this.myDivider.setVisible(false);
            this.mySecondComponent.setBounds(0, 0, width, height);
        } else {
            this.myDivider.setVisible(false);
            if (this.myFirstComponent != null) {
                this.myFirstComponent.setBounds(0, 0, 0, 0);
            } else {
                Splitter.hideNull(this.myFirstComponent);
            }
            if (this.mySecondComponent != null) {
                this.mySecondComponent.setBounds(0, 0, 0, 0);
            } else {
                Splitter.hideNull(this.mySecondComponent);
            }
        }
    }

    static boolean isNull(Component component) {
        return NullableComponent.Check.isNull(component);
    }

    static void hideNull(Component component) {
        if (component instanceof NullableComponent && !component.getBounds().equals(myNullBounds)) {
            component.setBounds(myNullBounds);
            component.validate();
        }
    }

    public int getDividerWidth() {
        return this.myDividerWidth;
    }

    public void setDividerWidth(int width) {
        if (width <= 0) {
            throw new IllegalArgumentException("Wrong divider width: " + width);
        }
        if (this.myDividerWidth != width) {
            this.myDividerWidth = width;
            this.revalidate();
            this.repaint();
        }
    }

    public float getProportion() {
        return this.myProportion;
    }

    @Override
    public void setProportion(float proportion) {
        if (this.myProportion == proportion) {
            return;
        }
        if (proportion < 0.0f || proportion > 1.0f) {
            LOG.warn("Wrong proportion: " + proportion);
        }
        proportion = MathUtil.clamp((float)proportion, (float)this.myMinProp, (float)this.myMaxProp);
        float oldProportion = this.myProportion;
        this.myProportion = proportion;
        this.firePropertyChange(PROP_PROPORTION, new Float(oldProportion), new Float(this.myProportion));
        this.revalidate();
        this.repaint();
    }

    public void swapComponents() {
        JComponent tmp = this.myFirstComponent;
        this.myFirstComponent = this.mySecondComponent;
        this.mySecondComponent = tmp;
        this.revalidate();
        this.repaint();
    }

    @Override
    public boolean getOrientation() {
        return this.myVerticalSplit;
    }

    public boolean isVertical() {
        return this.myVerticalSplit;
    }

    @Override
    public void setOrientation(boolean verticalSplit) {
        boolean changed = this.myVerticalSplit != verticalSplit;
        this.myVerticalSplit = verticalSplit;
        this.myDivider.setOrientation(verticalSplit);
        if (changed) {
            this.firePropertyChange(PROP_ORIENTATION, !this.myVerticalSplit, this.myVerticalSplit);
        }
        this.revalidate();
        this.repaint();
    }

    public JComponent getFirstComponent() {
        return this.myFirstComponent;
    }

    public void setFirstComponent(@Nullable JComponent component) {
        if (this.myFirstComponent != component) {
            if (this.myFirstComponent != null) {
                this.remove(this.myFirstComponent);
            }
            this.myFirstComponent = component;
            if (this.myFirstComponent != null) {
                super.add(this.myFirstComponent);
            }
            this.revalidate();
            this.repaint();
        }
    }

    public JComponent getSecondComponent() {
        return this.mySecondComponent;
    }

    public JComponent getOtherComponent(Component comp) {
        if (comp.equals(this.getFirstComponent())) {
            return this.getSecondComponent();
        }
        if (comp.equals(this.getSecondComponent())) {
            return this.getFirstComponent();
        }
        LOG.error("invalid component");
        return this.getFirstComponent();
    }

    public void setSecondComponent(@Nullable JComponent component) {
        if (this.mySecondComponent != component) {
            if (this.mySecondComponent != null) {
                this.remove(this.mySecondComponent);
            }
            this.mySecondComponent = component;
            if (this.mySecondComponent != null) {
                super.add(this.mySecondComponent);
            }
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public float getMinProportion(boolean first) {
        JComponent component;
        JComponent jComponent = component = first ? this.myFirstComponent : this.mySecondComponent;
        if (this.isHonorMinimumSize() && component != null && this.myFirstComponent != null && this.myFirstComponent.isVisible() && this.mySecondComponent != null && this.mySecondComponent.isVisible()) {
            if (this.isVertical()) {
                return (float)component.getMinimumSize().height / (float)(this.getHeight() - this.getDividerWidth());
            }
            return (float)component.getMinimumSize().width / (float)(this.getWidth() - this.getDividerWidth());
        }
        return 0.0f;
    }

    @Override
    @NotNull
    public Component asComponent() {
        Splitter splitter = this;
        if (splitter == null) {
            Splitter.$$$reportNull$$$0(4);
        }
        return splitter;
    }

    @Override
    public void setDragging(boolean dragging) {
    }

    public JPanel getDivider() {
        return this.myDivider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/Splitter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dividerPositionStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/Splitter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLackOfSpaceStrategy";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDividerPositionStrategy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "asComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setLackOfSpaceStrategy";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDividerPositionStrategy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class DividerImpl
    extends Divider {
        private boolean myResizeEnabled;
        private boolean mySwitchOrientationEnabled;
        protected Point myPoint;

        public DividerImpl() {
            super(new GridBagLayout());
            this.myResizeEnabled = true;
            this.mySwitchOrientationEnabled = false;
            this.setFocusable(false);
            this.enableEvents(48L);
            this.setOrientation(Splitter.this.myVerticalSplit);
        }

        @Override
        public void setOrientation(boolean isVerticalSplit) {
            this.removeAll();
            this.setCursor(Splitter.this.isVertical() ? Cursor.getPredefinedCursor(8) : Cursor.getPredefinedCursor(10));
            if (!Splitter.this.myShowDividerControls && !Splitter.this.myShowDividerIcon) {
                return;
            }
            Icon glueIcon = isVerticalSplit ? SplitGlueV : SplitGlueH;
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, JBUI.emptyInsets(), 0, 0));
            this.revalidate();
            this.repaint();
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e) {
            super.processMouseMotionEvent(e);
            if (!this.myResizeEnabled) {
                return;
            }
            if (506 == e.getID()) {
                this.myPoint = SwingUtilities.convertPoint(this, e.getPoint(), Splitter.this);
                if (Splitter.this.isVertical()) {
                    if (this.getHeight() > 0) {
                        float min = Splitter.this.getMinProportion(true);
                        float max = 1.0f - Splitter.this.getMinProportion(false);
                        float proportion = MathUtil.clamp((float)Math.min(max, Math.max((float)this.myPoint.y / (float)Splitter.this.getHeight(), min)), (float)0.0f, (float)1.0f);
                        Splitter.this.setProportion(proportion);
                    }
                } else if (this.getWidth() > 0) {
                    float min = Splitter.this.getMinProportion(true);
                    float max = 1.0f - Splitter.this.getMinProportion(false);
                    float proportion = MathUtil.clamp((float)Math.min(max, Math.max((float)this.myPoint.x / (float)Splitter.this.getWidth(), min)), (float)0.0f, (float)1.0f);
                    Splitter.this.setProportion(proportion);
                }
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            if (e.getID() == 500) {
                if (this.mySwitchOrientationEnabled && e.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(e) && (SystemInfo.isMac ? e.isMetaDown() : e.isControlDown())) {
                    Splitter.this.setOrientation(!Splitter.this.getOrientation());
                }
                if (this.myResizeEnabled && e.getClickCount() == 2) {
                    Splitter.this.setProportion(0.5f);
                }
            }
        }

        @Override
        public void setResizeEnabled(boolean resizeEnabled) {
            this.myResizeEnabled = resizeEnabled;
            if (!this.myResizeEnabled) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else {
                this.setCursor(Splitter.this.isVertical() ? Cursor.getPredefinedCursor(8) : Cursor.getPredefinedCursor(10));
            }
        }

        @Override
        public void setSwitchOrientationEnabled(boolean switchOrientationEnabled) {
            this.mySwitchOrientationEnabled = switchOrientationEnabled;
        }
    }

    public static enum DividerPositionStrategy {
        KEEP_PROPORTION,
        KEEP_FIRST_SIZE,
        KEEP_SECOND_SIZE;

    }

    public static enum LackOfSpaceStrategy {
        SIMPLE_RATIO,
        HONOR_THE_FIRST_MIN_SIZE,
        HONOR_THE_SECOND_MIN_SIZE;

    }
}

