/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.unittestLegacy;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.run.PythonScriptExecution;
import com.jetbrains.python.testing.AbstractPythonLegacyTestRunConfiguration;
import com.jetbrains.python.testing.PythonTestCommandLineStateBase;
import com.jetbrains.python.testing.PythonUnitTestTestIdUrlProvider;
import com.jetbrains.python.testing.unittestLegacy.PythonUnitTestRunConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonUnitTestCommandLineState
extends PythonTestCommandLineStateBase {
    private final PythonUnitTestRunConfiguration myConfig;

    public PythonUnitTestCommandLineState(PythonUnitTestRunConfiguration runConfiguration, ExecutionEnvironment env) {
        super(runConfiguration, env);
        this.myConfig = runConfiguration;
    }

    @Override
    protected PythonHelper getRunner() {
        if (this.myConfig.getTestType() == AbstractPythonLegacyTestRunConfiguration.TestType.TEST_SCRIPT && this.myConfig.getScriptName().endsWith("setup.py")) {
            return PythonHelper.SETUPPY;
        }
        return PythonHelper.UT_OLD;
    }

    @Override
    @NotNull
    protected List<String> getTestSpecs() {
        ArrayList<String> specs = new ArrayList<String>();
        String scriptName = FileUtil.toSystemDependentName((String)this.myConfig.getScriptName());
        switch (this.myConfig.getTestType()) {
            case TEST_SCRIPT: {
                specs.add(scriptName);
                break;
            }
            case TEST_CLASS: {
                specs.add(scriptName + "::" + this.myConfig.getClassName());
                break;
            }
            case TEST_METHOD: {
                specs.add(scriptName + "::" + this.myConfig.getClassName() + "::" + this.myConfig.getMethodName());
                break;
            }
            case TEST_FOLDER: {
                String folderName = FileUtil.toSystemDependentName((String)(this.myConfig.getFolderName() + "/"));
                if (!StringUtil.isEmpty((String)this.myConfig.getPattern()) && this.myConfig.usePattern()) {
                    specs.add(folderName + "_args_separator_" + this.myConfig.getPattern());
                    break;
                }
                specs.add(folderName);
                break;
            }
            case TEST_FUNCTION: {
                specs.add(scriptName + "::::" + this.myConfig.getMethodName());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown test type: " + this.myConfig.getTestType());
            }
        }
        ArrayList<String> arrayList = specs;
        if (arrayList == null) {
            PythonUnitTestCommandLineState.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Override
    @Nullable
    protected SMTestLocator getTestLocator() {
        return PythonUnitTestTestIdUrlProvider.INSTANCE;
    }

    @Override
    protected void addAfterParameters(GeneralCommandLine cmd) {
        ParamsGroup script_params = cmd.getParametersList().getParamsGroup("Script");
        assert (script_params != null);
        if (this.myConfig.useParam() && !StringUtil.isEmptyOrSpaces((String)this.myConfig.getParams())) {
            script_params.addParameter(this.myConfig.getParams());
        }
        if (this.myConfig.getTestType() != AbstractPythonLegacyTestRunConfiguration.TestType.TEST_SCRIPT || !this.myConfig.getScriptName().endsWith("setup.py")) {
            script_params.addParameter(String.valueOf(this.myConfig.isPureUnittest()));
        }
    }

    @Override
    protected void addAfterParameters(@NotNull TargetEnvironmentRequest targetEnvironmentRequest, @NotNull PythonScriptExecution testScriptExecution) {
        if (targetEnvironmentRequest == null) {
            PythonUnitTestCommandLineState.$$$reportNull$$$0(1);
        }
        if (testScriptExecution == null) {
            PythonUnitTestCommandLineState.$$$reportNull$$$0(2);
        }
        if (this.myConfig.useParam() && !StringUtil.isEmptyOrSpaces((String)this.myConfig.getParams())) {
            testScriptExecution.addParameter(this.myConfig.getParams());
        }
        if (this.myConfig.getTestType() != AbstractPythonLegacyTestRunConfiguration.TestType.TEST_SCRIPT || !this.myConfig.getScriptName().endsWith("setup.py")) {
            testScriptExecution.addParameter(String.valueOf(this.myConfig.isPureUnittest()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/testing/unittestLegacy/PythonUnitTestCommandLineState";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironmentRequest";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testScriptExecution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestSpecs";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/testing/unittestLegacy/PythonUnitTestCommandLineState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addAfterParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

