/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import com.jetbrains.python.sdk.add.PyAddSdkPanelKt;
import com.jetbrains.python.sdk.add.PySdkPathChoosingComboBox;
import com.jetbrains.python.sdk.conda.PyCondaSdkCustomizer;
import com.jetbrains.python.sdk.flavors.CondaEnvSdkFlavor;
import icons.PythonIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BK\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0010J\n\u0010!\u001a\u0004\u0018\u00010\bH\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0007H\u0016R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001aR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/python/sdk/add/PyAddExistingCondaEnvPanel;", "Lcom/jetbrains/python/sdk/add/PyAddSdkPanel;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "newProjectPath", "", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "onEnvsDetectionComplete", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Ljava/util/List;Ljava/lang/String;Lcom/intellij/openapi/util/UserDataHolder;Lkotlin/jvm/functions/Function0;)V", "condaPathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "makeSharedField", "Lcom/intellij/ui/components/JBCheckBox;", "getNewProjectPath", "()Ljava/lang/String;", "setNewProjectPath", "(Ljava/lang/String;)V", "panelName", "getPanelName", "sdkComboBox", "Lcom/jetbrains/python/sdk/add/PySdkPathChoosingComboBox;", "getOrCreateSdk", "validateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "intellij.python.community.impl"})
public final class PyAddExistingCondaEnvPanel
extends PyAddSdkPanel {
    @NotNull
    private final Icon icon;
    private final PySdkPathChoosingComboBox sdkComboBox;
    private final TextFieldWithBrowseButton condaPathField;
    private final JBCheckBox makeSharedField;
    private final Project project;
    private final Module module;
    private final List<Sdk> existingSdks;
    @Nullable
    private String newProjectPath;

    @Override
    @NotNull
    public String getPanelName() {
        String string = PyBundle.message("python.add.sdk.panel.name.existing.environment", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PyBundle.message(\"python\u2026me.existing.environment\")");
        return string;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public List<ValidationInfo> validateAll() {
        return CollectionsKt.listOfNotNull((Object[])new ValidationInfo[]{PyAddSdkPanel.Companion.validateSdkComboBox(this.sdkComboBox, this), CondaEnvSdkFlavor.validateCondaPath(this.condaPathField.getText())});
    }

    @Override
    @Nullable
    public Sdk getOrCreateSdk() {
        Sdk sdk;
        Sdk sdk2 = this.sdkComboBox.getSelectedSdk();
        PyCondaPackageService.onCondaEnvCreated(this.condaPathField.getText());
        Sdk sdk3 = sdk2;
        if (sdk3 instanceof PyDetectedSdk) {
            PyDetectedSdk pyDetectedSdk = (PyDetectedSdk)sdk2;
            String string = this.getNewProjectPath();
            if (string == null) {
                Project project = this.project;
                string = project != null ? project.getBasePath() : null;
            }
            Sdk sdk4 = PySdkExtKt.setupAssociated(pyDetectedSdk, this.existingSdks, string);
            if (sdk4 != null) {
                Sdk sdk5 = sdk4;
                boolean bl = false;
                boolean bl2 = false;
                Sdk $this$apply = sdk5;
                boolean bl3 = false;
                if (!this.makeSharedField.isSelected()) {
                    PySdkExtKt.associateWithModule($this$apply, this.module, this.getNewProjectPath());
                }
                sdk = sdk5;
            } else {
                sdk = null;
            }
        } else {
            sdk = sdk2;
        }
        return sdk;
    }

    @Override
    @Nullable
    public String getNewProjectPath() {
        return this.newProjectPath;
    }

    @Override
    public void setNewProjectPath(@Nullable String string) {
        this.newProjectPath = string;
    }

    /*
     * WARNING - void declaration
     */
    public PyAddExistingCondaEnvPanel(@Nullable Project project, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks, @Nullable String newProjectPath, final @NotNull UserDataHolder context, final @Nullable Function0<Boolean> onEnvsDetectionComplete) {
        void $this$apply;
        Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.project = project;
        this.module = module;
        this.existingSdks = existingSdks;
        this.newProjectPath = newProjectPath;
        Icon icon = PythonIcons.Python.Anaconda;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PythonIcons.Python.Anaconda");
        this.icon = icon;
        this.sdkComboBox = new PySdkPathChoosingComboBox(null, null, 3, null);
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        boolean bl = false;
        boolean bl2 = false;
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton;
        PyAddExistingCondaEnvPanel pyAddExistingCondaEnvPanel = this;
        boolean bl3 = false;
        String path = PyCondaPackageService.getCondaExecutable(null);
        if (path != null) {
            $this$apply.setText(path);
        }
        $this$apply.addBrowseFolderListener(PyBundle.message("python.sdk.select.conda.path.title", new Object[0]), null, this.project, FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor());
        Unit unit = Unit.INSTANCE;
        pyAddExistingCondaEnvPanel.condaPathField = textFieldWithBrowseButton;
        this.makeSharedField = new JBCheckBox(PyBundle.message("available.to.all.projects", new Object[0]));
        ((ComboBoxWithWidePopup)this.sdkComboBox.getChildComponent()).addItemListener(new ItemListener(){

            @Override
            public final void itemStateChanged(ItemEvent it) {
                ItemEvent itemEvent = it;
                Intrinsics.checkNotNullExpressionValue((Object)itemEvent, (String)"it");
                if (itemEvent.getStateChange() == 1) {
                    Sdk sdk = sdkComboBox.getSelectedSdk();
                    String respectiveCondaExecutable = PyCondaPackageService.getCondaExecutable(sdk != null ? sdk.getHomePath() : null);
                    TextFieldWithBrowseButton textFieldWithBrowseButton = condaPathField;
                    String string = respectiveCondaExecutable;
                    boolean bl = false;
                    String string2 = string;
                    if (string2 == null) {
                        string2 = "";
                    }
                    textFieldWithBrowseButton.setText(string2);
                }
            }
        });
        if (PyCondaSdkCustomizer.Companion.getInstance().getSharedEnvironmentsByDefault()) {
            this.makeSharedField.setSelected(true);
        }
        this.setLayout(new BorderLayout());
        FormBuilder formBuilder = FormBuilder.createFormBuilder().addLabeledComponent(PySdkBundle.message("python.interpreter.label", new Object[0]), (JComponent)((Object)this.sdkComboBox)).addLabeledComponent(PyBundle.message("python.sdk.conda.path", new Object[0]), (JComponent)this.condaPathField).addComponent((JComponent)this.makeSharedField);
        Intrinsics.checkNotNullExpressionValue((Object)formBuilder, (String)"FormBuilder.createFormBu\u2026omponent(makeSharedField)");
        JPanel formPanel = formBuilder.getPanel();
        this.add((Component)formPanel, "North");
        PyAddSdkPanelKt.addInterpretersAsync(this.sdkComboBox, (Function0<? extends List<? extends Sdk>>)((Function0)new Function0<List<? extends Sdk>>(){

            @NotNull
            public final List<Sdk> invoke() {
                return PySdkExtKt.detectCondaEnvs(module, existingSdks, context);
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                block0: {
                    Function0 function0 = onEnvsDetectionComplete;
                    if (function0 == null) break block0;
                    Boolean cfr_ignored_0 = (Boolean)function0.invoke();
                }
            }
        }));
    }

    public /* synthetic */ PyAddExistingCondaEnvPanel(Project project, Module module, List list, String string, UserDataHolder userDataHolder, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            function0 = null;
        }
        this(project, module, list, string, userDataHolder, (Function0<Boolean>)function0);
    }
}

